/*
 * Decompiled with CFR 0.152.
 */
package com.pcgroup.framework.web.exception;

import com.pcgroup.framework.api.entity.Response;
import com.pcgroup.framework.common.entity.IRestCode;
import com.pcgroup.framework.common.entity.RestCode;
import com.pcgroup.framework.common.exception.BusinessRuntimeException;
import com.pcgroup.framework.common.exception.SystemRuntimeException;
import com.pcgroup.framework.common.json.Jackson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ResponseBody
@ControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={RuntimeException.class})
    public Response<Void> handleRuntimeException(RuntimeException runtimeException) {
        logger.error("Handle runtime exception", (Throwable)runtimeException);
        if (runtimeException instanceof BusinessRuntimeException) {
            BusinessRuntimeException businessRuntimeException = (BusinessRuntimeException)runtimeException;
            return Response.error((String)businessRuntimeException.getCode(), (String)businessRuntimeException.getMessage());
        }
        if (runtimeException instanceof SystemRuntimeException) {
            SystemRuntimeException systemRuntimeException = (SystemRuntimeException)runtimeException;
            return Response.error((String)systemRuntimeException.getCode(), (String)systemRuntimeException.getMessage());
        }
        if (runtimeException instanceof HttpMessageNotReadableException) {
            return Response.error((IRestCode)RestCode.INVALID_REQUEST);
        }
        return Response.error((IRestCode)RestCode.SYSTEM_RUNTIME_EXCEPTION);
    }

    @ExceptionHandler(value={BindException.class, MethodArgumentNotValidException.class})
    public Response<Void> handleBindException(Exception exception) {
        logger.error("Handle bind exception");
        FieldError fieldError = exception instanceof BindException ? ((BindException)exception).getFieldError() : ((MethodArgumentNotValidException)exception).getBindingResult().getFieldError();
        if (fieldError != null) {
            return Response.errorMessage((String)("[" + Jackson.toSnakeCase((String)fieldError.getField()) + "]" + fieldError.getDefaultMessage()));
        }
        return Response.error((IRestCode)RestCode.INVALID_REQUEST);
    }

    @ExceptionHandler(value={Exception.class})
    public Response<Void> handleException(Exception exception) {
        logger.error("Handle generic exception", (Throwable)exception);
        if (exception instanceof MissingServletRequestParameterException) {
            return Response.errorMessage((String)exception.getMessage());
        }
        if (exception instanceof HttpMediaTypeNotSupportedException) {
            return Response.error((IRestCode)RestCode.HTTP_MEDIA_NOT_SUPPORT);
        }
        if (exception instanceof HttpRequestMethodNotSupportedException) {
            return Response.error((IRestCode)RestCode.METHOD_NOT_ALLOWED);
        }
        return Response.error((IRestCode)RestCode.SYSTEM_EXCEPTION);
    }
}

