/*
 * Decompiled with CFR 0.152.
 */
package com.pcgroup.framework.web.controller;

import com.pcgroup.framework.api.entity.Response;
import com.pcgroup.framework.common.entity.IRestCode;
import com.pcgroup.framework.common.entity.RestCode;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.web.servlet.error.AbstractErrorController;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"${server.error.path:${error.path:/error}}"})
public class CustomErrorController
extends AbstractErrorController {
    private static final Logger logger = LoggerFactory.getLogger(CustomErrorController.class);
    @Value(value="${server.error.path:${error.path:/error}}")
    private String errorPath;

    public CustomErrorController(ErrorAttributes errorAttributes) {
        super(errorAttributes, Collections.emptyList());
    }

    @RequestMapping
    public Response<Void> error(HttpServletRequest request, HttpServletResponse response) {
        HttpStatus status = this.getStatus(request);
        logger.error(status.toString());
        response.setCharacterEncoding("utf-8");
        if (status == HttpStatus.NOT_FOUND) {
            return Response.error((IRestCode)RestCode.RESOURCE_NOT_FOUND);
        }
        if (status == HttpStatus.INTERNAL_SERVER_ERROR) {
            return Response.error((IRestCode)RestCode.INTERNAL_SERVER_ERROR);
        }
        return Response.error((IRestCode)RestCode.SYSTEM_EXCEPTION);
    }

    public String getErrorPath() {
        return this.errorPath;
    }
}

