/*
 * Decompiled with CFR 0.152.
 */
package com.pcgroup.framework.web.filter;

import com.pcgroup.framework.web.request.CachedHttpServletRequest;
import com.pcgroup.framework.web.util.RequestUtil;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(LoggingFilter.class);

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        CachedHttpServletRequest cachedRequest = new CachedHttpServletRequest((HttpServletRequest)servletRequest);
        logger.info("Request begin. IP: " + cachedRequest.getRemoteAddr() + "\n" + RequestUtil.dumpHttpStandardContent((HttpServletRequest)cachedRequest));
        Instant begin = Instant.now();
        filterChain.doFilter((ServletRequest)cachedRequest, servletResponse);
        Instant end = Instant.now();
        logger.info("Request end. Takes " + Duration.between(begin, end).toMillis() + "ms");
    }
}

