/*
 * Decompiled with CFR 0.152.
 */
package com.pcgroup.framework.web.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.util.MimeType;

public class RequestUtil {
    private static final Logger logger = LoggerFactory.getLogger(RequestUtil.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String dumpHttpStandardContent(HttpServletRequest request) {
        StringBuilder builder = new StringBuilder();
        String queryString = request.getQueryString();
        builder.append(request.getMethod()).append(" ").append(request.getRequestURI()).append(StringUtils.isBlank((CharSequence)queryString) ? "" : "?" + queryString).append(" ").append(request.getProtocol()).append("\r\n");
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            String headerValue = request.getHeader(headerName);
            builder.append(headerName).append(":").append(" ").append(headerValue).append("\r\n");
        }
        String contentType = request.getContentType();
        if (StringUtils.isBlank((CharSequence)contentType)) {
            return builder.toString();
        }
        builder.append("\r\n");
        MediaType mediaType = MediaType.parseMediaType((String)contentType);
        if (MediaType.APPLICATION_FORM_URLENCODED.equalsTypeAndSubtype((MimeType)mediaType) || MediaType.MULTIPART_FORM_DATA.equalsTypeAndSubtype((MimeType)mediaType)) {
            Enumeration parameterNames = request.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String parameterName = (String)parameterNames.nextElement();
                String parameterValue = request.getParameter(parameterName);
                builder.append(parameterName).append("=").append(parameterValue);
                builder.append(parameterNames.hasMoreElements() ? "&" : "");
            }
            return builder.toString();
        } else {
            try {
                String body = IOUtils.toString((InputStream)request.getInputStream(), (Charset)StandardCharsets.UTF_8);
                if (!StringUtils.isNotBlank((CharSequence)body)) return builder.toString();
                builder.append(body);
                return builder.toString();
            }
            catch (IOException e) {
                logger.error("Dump request stream exception", (Throwable)e);
            }
        }
        return builder.toString();
    }

    private RequestUtil() {
    }
}

