/*
 * Decompiled with CFR 0.152.
 */
package com.pcgroup.framework.web.configuration;

import com.pcgroup.framework.web.filter.LoggingFilter;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FilterConfiguration {
    @Value(value="${pcgroup.framework.filter.logging.url-patterns:/*}")
    private String urlPatterns;

    @Bean
    @ConditionalOnProperty(value={"pcgroup.framework.filter.logging.enabled"}, havingValue="true")
    public FilterRegistrationBean<LoggingFilter> filterRegistrationBean() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)new LoggingFilter());
        filterRegistrationBean.addUrlPatterns(this.urlPatterns.split(","));
        filterRegistrationBean.setOrder(-1024);
        return filterRegistrationBean;
    }
}

