/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.gpio.impl;

import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.tasks.impl.GpioBlinkStopTaskImpl;
import com.pi4j.io.gpio.tasks.impl.GpioBlinkTaskImpl;
import com.pi4j.io.gpio.tasks.impl.GpioPulseTaskImpl;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class GpioScheduledExecutorImpl {
    private static final ConcurrentHashMap<GpioPinDigitalOutput, ArrayList<ScheduledFuture<?>>> pinTaskQueue = new ConcurrentHashMap();
    private static ScheduledExecutorService scheduledExecutorService;

    private static synchronized void init(GpioPinDigitalOutput pin) {
        if (scheduledExecutorService == null) {
            scheduledExecutorService = GpioFactory.getExecutorServiceFactory().getScheduledExecutorService();
        }
        if (pinTaskQueue.containsKey(pin)) {
            ArrayList<ScheduledFuture<?>> tasks = pinTaskQueue.get(pin);
            if (tasks != null && !tasks.isEmpty()) {
                for (int index = tasks.size() - 1; index >= 0; --index) {
                    ScheduledFuture<?> task = tasks.get(index);
                    task.cancel(true);
                    tasks.remove(index);
                }
            }
            if (tasks.isEmpty()) {
                pinTaskQueue.remove(pin);
            }
        }
    }

    private static synchronized ScheduledFuture<?> createCleanupTask(long delay) {
        ScheduledFuture cleanupFutureTask = scheduledExecutorService.schedule(new Callable(){

            public Object call() throws Exception {
                for (Map.Entry item : pinTaskQueue.entrySet()) {
                    ArrayList remainingTasks = (ArrayList)item.getValue();
                    if (remainingTasks == null || remainingTasks.isEmpty()) continue;
                    for (int index = remainingTasks.size() - 1; index >= 0; --index) {
                        ScheduledFuture remainingTask = (ScheduledFuture)remainingTasks.get(index);
                        if (!remainingTask.isCancelled() && !remainingTask.isDone()) continue;
                        remainingTasks.remove(index);
                    }
                    if (!remainingTasks.isEmpty()) continue;
                    pinTaskQueue.remove(item.getKey());
                }
                return null;
            }
        }, delay, TimeUnit.MILLISECONDS);
        return cleanupFutureTask;
    }

    public static synchronized Future<?> pulse(GpioPinDigitalOutput pin, long duration, PinState pulseState) {
        ScheduledFuture<?> scheduledFuture = null;
        GpioScheduledExecutorImpl.init(pin);
        if (duration > 0L) {
            pin.setState(pulseState);
            scheduledFuture = scheduledExecutorService.schedule(new GpioPulseTaskImpl(pin, PinState.getInverseState(pulseState)), duration, TimeUnit.MILLISECONDS);
            if (!pinTaskQueue.containsKey(pin)) {
                pinTaskQueue.put(pin, new ArrayList());
            }
            ArrayList<ScheduledFuture<?>> tasks = pinTaskQueue.get(pin);
            tasks.add(scheduledFuture);
            GpioScheduledExecutorImpl.createCleanupTask(duration + 500L);
        }
        return scheduledFuture;
    }

    public static synchronized Future<?> blink(GpioPinDigitalOutput pin, long delay, long duration, PinState blinkState) {
        GpioScheduledExecutorImpl.init(pin);
        if (delay > 0L) {
            pin.setState(blinkState);
            ScheduledFuture<?> scheduledFutureBlinkTask = scheduledExecutorService.scheduleAtFixedRate(new GpioBlinkTaskImpl(pin), delay, delay, TimeUnit.MILLISECONDS);
            if (!pinTaskQueue.containsKey(pin)) {
                pinTaskQueue.put(pin, new ArrayList());
            }
            ArrayList<ScheduledFuture<?>> tasks = pinTaskQueue.get(pin);
            tasks.add(scheduledFutureBlinkTask);
            if (duration > 0L) {
                ScheduledFuture<?> scheduledFutureBlinkStopTask = scheduledExecutorService.schedule(new GpioBlinkStopTaskImpl(pin, PinState.getInverseState(blinkState), scheduledFutureBlinkTask), duration, TimeUnit.MILLISECONDS);
                tasks.add(scheduledFutureBlinkStopTask);
                GpioScheduledExecutorImpl.createCleanupTask(duration + 500L);
            }
            return scheduledFutureBlinkTask;
        }
        return null;
    }
}

