/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.dump;

import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.model.event.ConfigDumpEvent;
import com.alibaba.nacos.config.server.service.AggrWhitelist;
import com.alibaba.nacos.config.server.service.ClientIpWhiteList;
import com.alibaba.nacos.config.server.service.ConfigCacheService;
import com.alibaba.nacos.config.server.service.SwitchService;
import com.alibaba.nacos.config.server.service.trace.ConfigTraceService;

public class DumpConfigHandler
extends Subscriber<ConfigDumpEvent> {
    public static boolean configDump(ConfigDumpEvent event) {
        boolean result;
        String dataId = event.getDataId();
        String group = event.getGroup();
        String namespaceId = event.getNamespaceId();
        String content = event.getContent();
        String type = event.getType();
        long lastModified = event.getLastModifiedTs();
        if (event.isBeta()) {
            boolean result2 = false;
            if (event.isRemove()) {
                result2 = ConfigCacheService.removeBeta(dataId, group, namespaceId);
                if (result2) {
                    ConfigTraceService.logDumpEvent(dataId, group, namespaceId, null, lastModified, event.getHandleIp(), "remove-ok", System.currentTimeMillis() - lastModified, 0L);
                }
                return result2;
            }
            result2 = ConfigCacheService.dumpBeta(dataId, group, namespaceId, content, lastModified, event.getBetaIps());
            if (result2) {
                ConfigTraceService.logDumpEvent(dataId, group, namespaceId, null, lastModified, event.getHandleIp(), "ok", System.currentTimeMillis() - lastModified, content.length());
            }
            return result2;
        }
        if (StringUtils.isBlank((CharSequence)event.getTag())) {
            boolean result3;
            if (dataId.equals("com.alibaba.nacos.metadata.aggrIDs")) {
                AggrWhitelist.load(content);
            }
            if (dataId.equals("com.alibaba.nacos.metadata.clientIpWhitelist")) {
                ClientIpWhiteList.load(content);
            }
            if (dataId.equals("com.alibaba.nacos.meta.switch")) {
                SwitchService.load(content);
            }
            if (!event.isRemove()) {
                result3 = ConfigCacheService.dump(dataId, group, namespaceId, content, lastModified, type);
                if (result3) {
                    ConfigTraceService.logDumpEvent(dataId, group, namespaceId, null, lastModified, event.getHandleIp(), "ok", System.currentTimeMillis() - lastModified, content.length());
                }
            } else {
                result3 = ConfigCacheService.remove(dataId, group, namespaceId);
                if (result3) {
                    ConfigTraceService.logDumpEvent(dataId, group, namespaceId, null, lastModified, event.getHandleIp(), "remove-ok", System.currentTimeMillis() - lastModified, 0L);
                }
            }
            return result3;
        }
        if (!event.isRemove()) {
            result = ConfigCacheService.dumpTag(dataId, group, namespaceId, event.getTag(), content, lastModified);
            if (result) {
                ConfigTraceService.logDumpEvent(dataId, group, namespaceId, null, lastModified, event.getHandleIp(), "ok", System.currentTimeMillis() - lastModified, content.length());
            }
        } else {
            result = ConfigCacheService.removeTag(dataId, group, namespaceId, event.getTag());
            if (result) {
                ConfigTraceService.logDumpEvent(dataId, group, namespaceId, null, lastModified, event.getHandleIp(), "remove-ok", System.currentTimeMillis() - lastModified, 0L);
            }
        }
        return result;
    }

    public void onEvent(ConfigDumpEvent event) {
        DumpConfigHandler.configDump(event);
    }

    public Class<? extends Event> subscribeType() {
        return ConfigDumpEvent.class;
    }
}

