/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.repository.extrnal;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.configuration.ConditionOnExternalStorage;
import com.alibaba.nacos.config.server.enums.FileTypeEnum;
import com.alibaba.nacos.config.server.model.ConfigAdvanceInfo;
import com.alibaba.nacos.config.server.model.ConfigAllInfo;
import com.alibaba.nacos.config.server.model.ConfigHistoryInfo;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfoAggr;
import com.alibaba.nacos.config.server.model.ConfigInfoBase;
import com.alibaba.nacos.config.server.model.ConfigInfoBetaWrapper;
import com.alibaba.nacos.config.server.model.ConfigInfoChanged;
import com.alibaba.nacos.config.server.model.ConfigInfoTagWrapper;
import com.alibaba.nacos.config.server.model.ConfigInfoWrapper;
import com.alibaba.nacos.config.server.model.ConfigKey;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.model.SameConfigPolicy;
import com.alibaba.nacos.config.server.model.SubInfo;
import com.alibaba.nacos.config.server.model.TenantInfo;
import com.alibaba.nacos.config.server.service.datasource.DataSourceService;
import com.alibaba.nacos.config.server.service.datasource.DynamicDataSource;
import com.alibaba.nacos.config.server.service.repository.PaginationHelper;
import com.alibaba.nacos.config.server.service.repository.PersistService;
import com.alibaba.nacos.config.server.service.repository.RowMapperManager;
import com.alibaba.nacos.config.server.service.repository.extrnal.ExternalStoragePaginationHelperImpl;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.ParamUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.context.annotation.Conditional;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

@Conditional(value={ConditionOnExternalStorage.class})
@Component
public class ExternalStoragePersistServiceImpl
implements PersistService {
    private DataSourceService dataSourceService;
    private static final String SQL_FIND_ALL_CONFIG_INFO = "SELECT id,data_id,group_id,tenant_id,app_name,content,type,md5,gmt_create,gmt_modified,src_user,src_ip,c_desc,c_use,effect,c_schema FROM config_info";
    private static final String SQL_TENANT_INFO_COUNT_BY_TENANT_ID = "SELECT count(*) FROM tenant_info WHERE tenant_id = ?";
    private static final String SQL_FIND_CONFIG_INFO_BY_IDS = "SELECT ID,data_id,group_id,tenant_id,app_name,content,md5 FROM config_info WHERE ";
    private static final String SQL_DELETE_CONFIG_INFO_BY_IDS = "DELETE FROM config_info WHERE ";
    private static final String PATTERN_STR = "*";
    private static final int QUERY_LIMIT_SIZE = 50;
    protected JdbcTemplate jt;
    protected TransactionTemplate tjt;
    public static final String SPOT = ".";

    @PostConstruct
    public void init() {
        this.dataSourceService = DynamicDataSource.getInstance().getDataSource();
        this.jt = this.getJdbcTemplate();
        this.tjt = this.getTransactionTemplate();
    }

    public boolean checkMasterWritable() {
        return this.dataSourceService.checkMasterWritable();
    }

    public void setBasicDataSourceService(DataSourceService dataSourceService) {
        this.dataSourceService = dataSourceService;
    }

    public synchronized void reload() throws IOException {
        this.dataSourceService.reload();
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.dataSourceService.getJdbcTemplate();
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.dataSourceService.getTransactionTemplate();
    }

    public String getCurrentDBUrl() {
        return this.dataSourceService.getCurrentDbUrl();
    }

    @Override
    public <E> PaginationHelper<E> createPaginationHelper() {
        return new ExternalStoragePaginationHelperImpl(this.jt);
    }

    @Override
    public void addConfigInfo(String srcIp, String srcUser, ConfigInfo configInfo, Timestamp time, Map<String, Object> configAdvanceInfo, boolean notify) {
        boolean result = (Boolean)this.tjt.execute(status -> {
            try {
                long configId = this.addConfigInfoAtomic(-1L, srcIp, srcUser, configInfo, time, configAdvanceInfo);
                String configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
                this.addConfigTagsRelation(configId, configTags, configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
                this.insertConfigHistoryAtomic(0L, configInfo, srcIp, srcUser, time, "I");
            }
            catch (CannotGetJdbcConnectionException e) {
                LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
                throw e;
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public void addConfigInfo4Beta(ConfigInfo configInfo, String betaIps, String srcIp, String srcUser, Timestamp time, boolean notify) {
        String appNameTmp = StringUtils.isBlank((CharSequence)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
        String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
        try {
            this.jt.update("INSERT INTO config_info_beta(data_id,group_id,tenant_id,app_name,content,md5,beta_ips,src_ip,src_user,gmt_create,gmt_modified) VALUES(?,?,?,?,?,?,?,?,?,?,?)", new Object[]{configInfo.getDataId(), configInfo.getGroup(), tenantTmp, appNameTmp, configInfo.getContent(), md5, betaIps, srcIp, srcUser, time, time});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void addConfigInfo4Tag(ConfigInfo configInfo, String tag, String srcIp, String srcUser, Timestamp time, boolean notify) {
        String appNameTmp = StringUtils.isBlank((CharSequence)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
        String tagTmp = StringUtils.isBlank((CharSequence)tag) ? "" : tag.trim();
        String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
        try {
            this.jt.update("INSERT INTO config_info_tag(data_id,group_id,tenant_id,tag_id,app_name,content,md5,src_ip,src_user,gmt_create,gmt_modified) VALUES(?,?,?,?,?,?,?,?,?,?,?)", new Object[]{configInfo.getDataId(), configInfo.getGroup(), tenantTmp, tagTmp, appNameTmp, configInfo.getContent(), md5, srcIp, srcUser, time, time});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void updateConfigInfo(ConfigInfo configInfo, String srcIp, String srcUser, Timestamp time, Map<String, Object> configAdvanceInfo, boolean notify) {
        boolean result = (Boolean)this.tjt.execute(status -> {
            try {
                String configTags;
                ConfigInfoWrapper oldConfigInfo = this.findConfigInfo(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
                String appNameTmp = oldConfigInfo.getAppName();
                if (configInfo.getAppName() == null) {
                    configInfo.setAppName(appNameTmp);
                }
                this.updateConfigInfoAtomic(configInfo, srcIp, srcUser, time, configAdvanceInfo);
                String string = configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
                if (configTags != null) {
                    this.removeTagByIdAtomic(oldConfigInfo.getId());
                    this.addConfigTagsRelation(oldConfigInfo.getId(), configTags, configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
                }
                this.insertConfigHistoryAtomic(oldConfigInfo.getId(), oldConfigInfo, srcIp, srcUser, time, "U");
            }
            catch (CannotGetJdbcConnectionException e) {
                LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
                throw e;
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public boolean updateConfigInfoCas(ConfigInfo configInfo, String srcIp, String srcUser, Timestamp time, Map<String, Object> configAdvanceInfo, boolean notify) {
        return (Boolean)this.tjt.execute(status -> {
            try {
                String configTags;
                int rows;
                ConfigInfoWrapper oldConfigInfo = this.findConfigInfo(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
                String appNameTmp = oldConfigInfo.getAppName();
                if (configInfo.getAppName() == null) {
                    configInfo.setAppName(appNameTmp);
                }
                if ((rows = this.updateConfigInfoAtomicCas(configInfo, srcIp, srcUser, time, configAdvanceInfo)) < 1) {
                    return Boolean.FALSE;
                }
                String string = configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
                if (configTags != null) {
                    this.removeTagByIdAtomic(oldConfigInfo.getId());
                    this.addConfigTagsRelation(oldConfigInfo.getId(), configTags, configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
                }
                this.insertConfigHistoryAtomic(oldConfigInfo.getId(), oldConfigInfo, srcIp, srcUser, time, "U");
            }
            catch (CannotGetJdbcConnectionException e) {
                LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
                throw e;
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public void updateConfigInfo4Beta(ConfigInfo configInfo, String betaIps, String srcIp, String srcUser, Timestamp time, boolean notify) {
        String appNameTmp = StringUtils.isBlank((CharSequence)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
        String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
        try {
            this.jt.update("UPDATE config_info_beta SET content=?, md5 = ?, src_ip=?,src_user=?,gmt_modified=?,app_name=? WHERE data_id=? AND group_id=? AND tenant_id=?", new Object[]{configInfo.getContent(), md5, srcIp, srcUser, time, appNameTmp, configInfo.getDataId(), configInfo.getGroup(), tenantTmp});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public boolean updateConfigInfo4BetaCas(ConfigInfo configInfo, String betaIps, String srcIp, String srcUser, Timestamp time, boolean notify) {
        String appNameTmp = StringUtils.isBlank((CharSequence)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
        String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
        try {
            return this.jt.update("UPDATE config_info_beta SET content=?, md5 = ?, src_ip=?,src_user=?,gmt_modified=?,app_name=? WHERE data_id=? AND group_id=? AND tenant_id=? AND (md5=? or md5 is null or md5='')", new Object[]{configInfo.getContent(), md5, srcIp, srcUser, time, appNameTmp, configInfo.getDataId(), configInfo.getGroup(), tenantTmp, configInfo.getMd5()}) > 0;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void updateConfigInfo4Tag(ConfigInfo configInfo, String tag, String srcIp, String srcUser, Timestamp time, boolean notify) {
        String appNameTmp = StringUtils.isBlank((CharSequence)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
        String tagTmp = StringUtils.isBlank((CharSequence)tag) ? "" : tag.trim();
        try {
            String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
            this.jt.update("UPDATE config_info_tag SET content=?, md5 = ?, src_ip=?,src_user=?,gmt_modified=?,app_name=? WHERE data_id=? AND group_id=? AND tenant_id=? AND tag_id=?", new Object[]{configInfo.getContent(), md5, srcIp, srcUser, time, appNameTmp, configInfo.getDataId(), configInfo.getGroup(), tenantTmp, tagTmp});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public boolean updateConfigInfo4TagCas(ConfigInfo configInfo, String tag, String srcIp, String srcUser, Timestamp time, boolean notify) {
        String appNameTmp = StringUtils.isBlank((CharSequence)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
        String tagTmp = StringUtils.isBlank((CharSequence)tag) ? "" : tag.trim();
        try {
            String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
            return this.jt.update("UPDATE config_info_tag SET content=?, md5 = ?, src_ip=?,src_user=?,gmt_modified=?,app_name=? WHERE data_id=? AND group_id=? AND tenant_id=? AND tag_id=? AND (md5=? or md5 is null or md5='')", new Object[]{configInfo.getContent(), md5, srcIp, srcUser, time, appNameTmp, configInfo.getDataId(), configInfo.getGroup(), tenantTmp, tagTmp, configInfo.getMd5()}) > 0;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void insertOrUpdateBeta(ConfigInfo configInfo, String betaIps, String srcIp, String srcUser, Timestamp time, boolean notify) {
        try {
            this.addConfigInfo4Beta(configInfo, betaIps, srcIp, null, time, notify);
        }
        catch (DataIntegrityViolationException ive) {
            this.updateConfigInfo4Beta(configInfo, betaIps, srcIp, null, time, notify);
        }
    }

    @Override
    public boolean insertOrUpdateBetaCas(ConfigInfo configInfo, String betaIps, String srcIp, String srcUser, Timestamp time, boolean notify) {
        try {
            this.addConfigInfo4Beta(configInfo, betaIps, srcIp, null, time, notify);
            return true;
        }
        catch (DataIntegrityViolationException ive) {
            return this.updateConfigInfo4BetaCas(configInfo, betaIps, srcIp, null, time, notify);
        }
    }

    @Override
    public void insertOrUpdateTag(ConfigInfo configInfo, String tag, String srcIp, String srcUser, Timestamp time, boolean notify) {
        try {
            this.addConfigInfo4Tag(configInfo, tag, srcIp, null, time, notify);
        }
        catch (DataIntegrityViolationException ive) {
            this.updateConfigInfo4Tag(configInfo, tag, srcIp, null, time, notify);
        }
    }

    @Override
    public boolean insertOrUpdateTagCas(ConfigInfo configInfo, String tag, String srcIp, String srcUser, Timestamp time, boolean notify) {
        try {
            this.addConfigInfo4Tag(configInfo, tag, srcIp, null, time, notify);
            return true;
        }
        catch (DataIntegrityViolationException ive) {
            return this.updateConfigInfo4TagCas(configInfo, tag, srcIp, null, time, notify);
        }
    }

    @Override
    public void updateMd5(String dataId, String group, String tenant, String md5, Timestamp lastTime) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        try {
            this.jt.update("UPDATE config_info SET md5 = ? WHERE data_id=? AND group_id=? AND tenant_id=? AND gmt_modified=?", new Object[]{md5, dataId, group, tenantTmp, lastTime});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void insertOrUpdate(String srcIp, String srcUser, ConfigInfo configInfo, Timestamp time, Map<String, Object> configAdvanceInfo) {
        this.insertOrUpdate(srcIp, srcUser, configInfo, time, configAdvanceInfo, true);
    }

    @Override
    public void insertOrUpdate(String srcIp, String srcUser, ConfigInfo configInfo, Timestamp time, Map<String, Object> configAdvanceInfo, boolean notify) {
        try {
            this.addConfigInfo(srcIp, srcUser, configInfo, time, configAdvanceInfo, notify);
        }
        catch (DataIntegrityViolationException ive) {
            this.updateConfigInfo(configInfo, srcIp, srcUser, time, configAdvanceInfo, notify);
        }
    }

    @Override
    public boolean insertOrUpdateCas(String srcIp, String srcUser, ConfigInfo configInfo, Timestamp time, Map<String, Object> configAdvanceInfo) {
        return this.insertOrUpdateCas(srcIp, srcUser, configInfo, time, configAdvanceInfo, true);
    }

    @Override
    public boolean insertOrUpdateCas(String srcIp, String srcUser, ConfigInfo configInfo, Timestamp time, Map<String, Object> configAdvanceInfo, boolean notify) {
        try {
            this.addConfigInfo(srcIp, srcUser, configInfo, time, configAdvanceInfo, notify);
            return true;
        }
        catch (DataIntegrityViolationException ive) {
            return this.updateConfigInfoCas(configInfo, srcIp, srcUser, time, configAdvanceInfo, notify);
        }
    }

    @Override
    public void insertOrUpdateSub(SubInfo subInfo) {
        try {
            this.addConfigSubAtomic(subInfo.getDataId(), subInfo.getGroup(), subInfo.getAppName(), subInfo.getDate());
        }
        catch (DataIntegrityViolationException ive) {
            this.updateConfigSubAtomic(subInfo.getDataId(), subInfo.getGroup(), subInfo.getAppName(), subInfo.getDate());
        }
    }

    @Override
    public void removeConfigInfo(final String dataId, final String group, final String tenant, final String srcIp, final String srcUser) {
        this.tjt.execute((TransactionCallback)new TransactionCallback<Boolean>(){
            final Timestamp time = new Timestamp(System.currentTimeMillis());

            public Boolean doInTransaction(TransactionStatus status) {
                try {
                    ConfigInfoWrapper configInfo = ExternalStoragePersistServiceImpl.this.findConfigInfo(dataId, group, tenant);
                    if (configInfo != null) {
                        ExternalStoragePersistServiceImpl.this.removeConfigInfoAtomic(dataId, group, tenant, srcIp, srcUser);
                        ExternalStoragePersistServiceImpl.this.removeTagByIdAtomic(configInfo.getId());
                        ExternalStoragePersistServiceImpl.this.insertConfigHistoryAtomic(configInfo.getId(), configInfo, srcIp, srcUser, this.time, "D");
                    }
                }
                catch (CannotGetJdbcConnectionException e) {
                    LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
                    throw e;
                }
                return Boolean.TRUE;
            }
        });
    }

    @Override
    public List<ConfigInfo> removeConfigInfoByIds(final List<Long> ids, final String srcIp, final String srcUser) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(ids)) {
            return null;
        }
        ids.removeAll(Collections.singleton(null));
        return (List)this.tjt.execute((TransactionCallback)new TransactionCallback<List<ConfigInfo>>(){
            final Timestamp time = new Timestamp(System.currentTimeMillis());

            public List<ConfigInfo> doInTransaction(TransactionStatus status) {
                try {
                    String idsStr = StringUtils.join((Collection)ids, (String)",");
                    List<ConfigInfo> configInfoList = ExternalStoragePersistServiceImpl.this.findConfigInfosByIds(idsStr);
                    if (!org.apache.commons.collections.CollectionUtils.isEmpty(configInfoList)) {
                        ExternalStoragePersistServiceImpl.this.removeConfigInfoByIdsAtomic(idsStr);
                        for (ConfigInfo configInfo : configInfoList) {
                            ExternalStoragePersistServiceImpl.this.removeTagByIdAtomic(configInfo.getId());
                            ExternalStoragePersistServiceImpl.this.insertConfigHistoryAtomic(configInfo.getId(), configInfo, srcIp, srcUser, this.time, "D");
                        }
                    }
                    return configInfoList;
                }
                catch (CannotGetJdbcConnectionException e) {
                    LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
                    throw e;
                }
            }
        });
    }

    @Override
    public void removeConfigInfo4Beta(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        this.tjt.execute(status -> {
            try {
                ConfigInfoBetaWrapper configInfo = this.findConfigInfo4Beta(dataId, group, tenant);
                if (configInfo != null) {
                    this.jt.update("DELETE FROM config_info_beta WHERE data_id=? AND group_id=? AND tenant_id=?", new Object[]{dataId, group, tenantTmp});
                }
            }
            catch (CannotGetJdbcConnectionException e) {
                LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
                throw e;
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public boolean addAggrConfigInfo(String dataId, String group, String tenant, String datumId, String appName, String content) {
        String appNameTmp = StringUtils.isBlank((CharSequence)appName) ? "" : appName;
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        Timestamp now = new Timestamp(System.currentTimeMillis());
        String select = "SELECT content FROM config_info_aggr WHERE data_id = ? AND group_id = ? AND tenant_id = ?  AND datum_id = ?";
        String insert = "INSERT INTO config_info_aggr(data_id, group_id, tenant_id, datum_id, app_name, content, gmt_modified) VALUES(?,?,?,?,?,?,?) ";
        String update = "UPDATE config_info_aggr SET content = ? , gmt_modified = ? WHERE data_id = ? AND group_id = ? AND tenant_id = ? AND datum_id = ?";
        try {
            try {
                String dbContent = (String)this.jt.queryForObject(select, new Object[]{dataId, group, tenantTmp, datumId}, String.class);
                if (dbContent != null && dbContent.equals(content)) {
                    return true;
                }
                return this.jt.update(update, new Object[]{content, now, dataId, group, tenantTmp, datumId}) > 0;
            }
            catch (EmptyResultDataAccessException ex) {
                return this.jt.update(insert, new Object[]{dataId, group, tenantTmp, datumId, appNameTmp, content, now}) > 0;
            }
        }
        catch (DataAccessException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void removeSingleAggrConfigInfo(final String dataId, final String group, String tenant, final String datumId) {
        final String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String sql = "DELETE FROM config_info_aggr WHERE data_id=? AND group_id=? AND tenant_id=? AND datum_id=?";
        try {
            this.jt.update(sql, new PreparedStatementSetter(){

                public void setValues(PreparedStatement ps) throws SQLException {
                    int index = 1;
                    ps.setString(index++, dataId);
                    ps.setString(index++, group);
                    ps.setString(index++, tenantTmp);
                    ps.setString(index, datumId);
                }
            });
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void removeAggrConfigInfo(final String dataId, final String group, String tenant) {
        final String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String sql = "DELETE FROM config_info_aggr WHERE data_id=? AND group_id=? AND tenant_id=?";
        try {
            this.jt.update(sql, new PreparedStatementSetter(){

                public void setValues(PreparedStatement ps) throws SQLException {
                    int index = 1;
                    ps.setString(index++, dataId);
                    ps.setString(index++, group);
                    ps.setString(index, tenantTmp);
                }
            });
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public boolean batchRemoveAggr(String dataId, String group, String tenant, List<String> datumList) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        StringBuilder datumString = new StringBuilder();
        for (String datum : datumList) {
            datumString.append('\'').append(datum).append("',");
        }
        datumString.deleteCharAt(datumString.length() - 1);
        String sql = "DELETE FROM config_info_aggr WHERE data_id=? AND group_id=? AND tenant_id=? AND datum_id IN (" + datumString.toString() + ")";
        try {
            this.jt.update(sql, new Object[]{dataId, group, tenantTmp});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public void removeConfigHistory(Timestamp startTime, int limitSize) {
        String sql = "DELETE FROM his_config_info WHERE gmt_modified < ? LIMIT ?";
        PaginationHelper helper = this.createPaginationHelper();
        try {
            helper.updateLimit(sql, new Object[]{startTime, limitSize});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public int findConfigHistoryCountByTime(Timestamp startTime) {
        String sql = "SELECT count(*) FROM his_config_info WHERE gmt_modified < ?";
        Integer result = (Integer)this.jt.queryForObject(sql, Integer.class, new Object[]{startTime});
        if (result == null) {
            throw new IllegalArgumentException("configInfoBetaCount error");
        }
        return result;
    }

    @Override
    public long findConfigMaxId() {
        String sql = "SELECT max(id) FROM config_info";
        try {
            return (Long)this.jt.queryForObject(sql, Long.class);
        }
        catch (NullPointerException e) {
            return 0L;
        }
    }

    @Override
    public boolean batchPublishAggr(final String dataId, final String group, final String tenant, final Map<String, String> datumMap, final String appName) {
        try {
            Boolean isPublishOk = (Boolean)this.tjt.execute((TransactionCallback)new TransactionCallback<Boolean>(){

                public Boolean doInTransaction(TransactionStatus status) {
                    for (Map.Entry entry : datumMap.entrySet()) {
                        try {
                            if (ExternalStoragePersistServiceImpl.this.addAggrConfigInfo(dataId, group, tenant, (String)entry.getKey(), appName, (String)entry.getValue())) continue;
                            throw new TransactionSystemException("error in addAggrConfigInfo");
                        }
                        catch (Throwable e) {
                            throw new TransactionSystemException("error in addAggrConfigInfo");
                        }
                    }
                    return Boolean.TRUE;
                }
            });
            if (isPublishOk == null) {
                return false;
            }
            return isPublishOk;
        }
        catch (TransactionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean replaceAggr(final String dataId, final String group, final String tenant, final Map<String, String> datumMap, final String appName) {
        try {
            Boolean isReplaceOk = (Boolean)this.tjt.execute((TransactionCallback)new TransactionCallback<Boolean>(){

                public Boolean doInTransaction(TransactionStatus status) {
                    try {
                        String appNameTmp = appName == null ? "" : appName;
                        ExternalStoragePersistServiceImpl.this.removeAggrConfigInfo(dataId, group, tenant);
                        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
                        String sql = "INSERT INTO config_info_aggr(data_id, group_id, tenant_id, datum_id, app_name, content, gmt_modified) VALUES(?,?,?,?,?,?,?) ";
                        for (Map.Entry datumEntry : datumMap.entrySet()) {
                            ExternalStoragePersistServiceImpl.this.jt.update(sql, new Object[]{dataId, group, tenantTmp, datumEntry.getKey(), appNameTmp, datumEntry.getValue(), new Timestamp(System.currentTimeMillis())});
                        }
                    }
                    catch (Throwable e) {
                        throw new TransactionSystemException("error in addAggrConfigInfo");
                    }
                    return Boolean.TRUE;
                }
            });
            if (isReplaceOk == null) {
                return false;
            }
            return isReplaceOk;
        }
        catch (TransactionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            return false;
        }
    }

    @Override
    @Deprecated
    public List<ConfigInfo> findAllDataIdAndGroup() {
        String sql = "SELECT DISTINCT data_id, group_id FROM config_info";
        try {
            return this.jt.query(sql, new Object[0], (RowMapper)RowMapperManager.CONFIG_INFO_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return Collections.emptyList();
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LogUtil.FATAL_LOG.error("[db-other-error]" + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public ConfigInfoBetaWrapper findConfigInfo4Beta(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        try {
            return (ConfigInfoBetaWrapper)this.jt.queryForObject("SELECT id,data_id,group_id,tenant_id,app_name,content,beta_ips FROM config_info_beta WHERE data_id=? AND group_id=? AND tenant_id=?", new Object[]{dataId, group, tenantTmp}, (RowMapper)RowMapperManager.CONFIG_INFO_BETA_WRAPPER_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public ConfigInfoTagWrapper findConfigInfo4Tag(String dataId, String group, String tenant, String tag) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String tagTmp = StringUtils.isBlank((CharSequence)tag) ? "" : tag.trim();
        try {
            return (ConfigInfoTagWrapper)this.jt.queryForObject("SELECT id,data_id,group_id,tenant_id,tag_id,app_name,content FROM config_info_tag WHERE data_id=? AND group_id=? AND tenant_id=? AND tag_id=?", new Object[]{dataId, group, tenantTmp, tagTmp}, (RowMapper)RowMapperManager.CONFIG_INFO_TAG_WRAPPER_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public ConfigInfo findConfigInfoApp(String dataId, String group, String tenant, String appName) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        try {
            return (ConfigInfo)this.jt.queryForObject("SELECT id,data_id,group_id,tenant_id,app_name,content FROM config_info WHERE data_id=? AND group_id=? AND tenant_id=? AND app_name=?", new Object[]{dataId, group, tenantTmp, appName}, (RowMapper)RowMapperManager.CONFIG_INFO_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public ConfigInfo findConfigInfoAdvanceInfo(String dataId, String group, String tenant, Map<String, Object> configAdvanceInfo) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String appName = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("appName");
        String configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(dataId);
        paramList.add(group);
        paramList.add(tenantTmp);
        StringBuilder sql = new StringBuilder("SELECT id,data_id,group_id,tenant_id,app_name,content FROM config_info WHERE data_id=? AND group_id=? AND tenant_id=? ");
        if (StringUtils.isNotBlank((String)configTags)) {
            sql = new StringBuilder("SELECT a.id,a.data_id,a.group_id,a.tenant_id,a.app_name,a.content FROM config_info  a LEFT JOIN config_tags_relation b ON a.id=b.id WHERE a.data_id=? AND a.group_id=? AND a.tenant_id=? ");
            sql.append(" AND b.tag_name IN (");
            String[] tagArr = configTags.split(",");
            for (int i = 0; i < tagArr.length; ++i) {
                if (i != 0) {
                    sql.append(", ");
                }
                sql.append('?');
                paramList.add(tagArr[i]);
            }
            sql.append(") ");
            if (StringUtils.isNotBlank((String)appName)) {
                sql.append(" AND a.app_name=? ");
                paramList.add(appName);
            }
        } else if (StringUtils.isNotBlank((String)appName)) {
            sql.append(" AND app_name=? ");
            paramList.add(appName);
        }
        try {
            return (ConfigInfo)this.jt.queryForObject(sql.toString(), paramList.toArray(), (RowMapper)RowMapperManager.CONFIG_INFO_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public ConfigInfoBase findConfigInfoBase(String dataId, String group) {
        try {
            return (ConfigInfoBase)this.jt.queryForObject("SELECT id,data_id,group_id,content FROM config_info WHERE data_id=? AND group_id=? AND tenant_id=?", new Object[]{dataId, group, ""}, (RowMapper)RowMapperManager.CONFIG_INFO_BASE_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public ConfigInfo findConfigInfo(long id) {
        try {
            return (ConfigInfo)this.jt.queryForObject("SELECT id,data_id,group_id,tenant_id,app_name,content FROM config_info WHERE id=?", new Object[]{id}, (RowMapper)RowMapperManager.CONFIG_INFO_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public ConfigInfoWrapper findConfigInfo(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        try {
            return (ConfigInfoWrapper)this.jt.queryForObject("SELECT id,data_id,group_id,tenant_id,app_name,content,md5,type FROM config_info WHERE data_id=? AND group_id=? AND tenant_id=?", new Object[]{dataId, group, tenantTmp}, RowMapperManager.CONFIG_INFO_WRAPPER_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<ConfigInfo> findConfigInfoByDataId(int pageNo, int pageSize, String dataId, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        PaginationHelper<ConfigInfo> helper = this.createPaginationHelper();
        try {
            return helper.fetchPage("SELECT count(*) FROM config_info WHERE data_id=? AND tenant_id=?", "SELECT id,data_id,group_id,tenant_id,app_name,content FROM config_info WHERE data_id=? AND tenant_id=?", new Object[]{dataId, tenantTmp}, pageNo, pageSize, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<ConfigInfo> findConfigInfoByDataIdAndApp(int pageNo, int pageSize, String dataId, String tenant, String appName) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        PaginationHelper<ConfigInfo> helper = this.createPaginationHelper();
        try {
            return helper.fetchPage("SELECT count(*) FROM config_info WHERE data_id=? AND tenant_id=? AND app_name=?", "SELECT id,data_id,group_id,tenant_id,app_name,content FROM config_info WHERE data_id=? AND tenant_id=? AND app_name=?", new Object[]{dataId, tenantTmp, appName}, pageNo, pageSize, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<ConfigInfo> findConfigInfoByDataIdAndAdvance(int pageNo, int pageSize, String dataId, String tenant, Map<String, Object> configAdvanceInfo) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        PaginationHelper<ConfigInfo> helper = this.createPaginationHelper();
        String appName = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("appName");
        String configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
        StringBuilder sqlCount = new StringBuilder("SELECT count(*) FROM config_info WHERE data_id=? AND tenant_id=? ");
        StringBuilder sql = new StringBuilder("SELECT id,data_id,group_id,tenant_id,app_name,content FROM config_info WHERE data_id=? AND tenant_id=? ");
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(dataId);
        paramList.add(tenantTmp);
        if (StringUtils.isNotBlank((String)configTags)) {
            sqlCount = new StringBuilder("SELECT count(*) FROM config_info  a LEFT JOIN config_tags_relation b ON a.id=b.id WHERE a.data_id=? AND a.tenant_id=? ");
            sql = new StringBuilder("SELECT a.id,a.data_id,a.group_id,a.tenant_id,a.app_name,a.content FROM config_info  a LEFT JOIN config_tags_relation b ON a.id=b.id WHERE a.data_id=? AND a.tenant_id=? ");
            sqlCount.append(" AND b.tag_name IN (");
            sql.append(" AND b.tag_name IN (");
            String[] tagArr = configTags.split(",");
            for (int i = 0; i < tagArr.length; ++i) {
                if (i != 0) {
                    sqlCount.append(", ");
                    sql.append(", ");
                }
                sqlCount.append('?');
                sql.append('?');
                paramList.add(tagArr[i]);
            }
            sqlCount.append(") ");
            sql.append(") ");
            if (StringUtils.isNotBlank((String)appName)) {
                sqlCount.append(" AND a.app_name=? ");
                sql.append(" AND a.app_name=? ");
                paramList.add(appName);
            }
        } else if (StringUtils.isNotBlank((String)appName)) {
            sqlCount.append(" AND app_name=? ");
            sql.append(" AND app_name=? ");
            paramList.add(appName);
        }
        try {
            return helper.fetchPage(sqlCount.toString(), sql.toString(), paramList.toArray(), pageNo, pageSize, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<ConfigInfo> findConfigInfo4Page(int pageNo, int pageSize, String dataId, String group, String tenant, Map<String, Object> configAdvanceInfo) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        PaginationHelper<ConfigInfo> helper = this.createPaginationHelper();
        String appName = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("appName");
        String configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
        String sqlCount = "SELECT count(*) FROM config_info";
        String sql = "SELECT id,data_id,group_id,tenant_id,app_name,content,type FROM config_info";
        StringBuilder where = new StringBuilder(" WHERE ");
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(tenantTmp);
        if (StringUtils.isNotBlank((String)configTags)) {
            sqlCount = "SELECT count(*) FROM config_info  a LEFT JOIN config_tags_relation b ON a.id=b.id";
            sql = "SELECT a.id,a.data_id,a.group_id,a.tenant_id,a.app_name,a.content FROM config_info  a LEFT JOIN config_tags_relation b ON a.id=b.id";
            where.append(" a.tenant_id=? ");
            if (StringUtils.isNotBlank((String)dataId)) {
                where.append(" AND a.data_id=? ");
                paramList.add(dataId);
            }
            if (StringUtils.isNotBlank((String)group)) {
                where.append(" AND a.group_id=? ");
                paramList.add(group);
            }
            if (StringUtils.isNotBlank((String)appName)) {
                where.append(" AND a.app_name=? ");
                paramList.add(appName);
            }
            where.append(" AND b.tag_name IN (");
            String[] tagArr = configTags.split(",");
            for (int i = 0; i < tagArr.length; ++i) {
                if (i != 0) {
                    where.append(", ");
                }
                where.append('?');
                paramList.add(tagArr[i]);
            }
            where.append(") ");
        } else {
            where.append(" tenant_id=? ");
            if (StringUtils.isNotBlank((String)dataId)) {
                where.append(" AND data_id=? ");
                paramList.add(dataId);
            }
            if (StringUtils.isNotBlank((String)group)) {
                where.append(" AND group_id=? ");
                paramList.add(group);
            }
            if (StringUtils.isNotBlank((String)appName)) {
                where.append(" AND app_name=? ");
                paramList.add(appName);
            }
        }
        try {
            return helper.fetchPage(sqlCount + where, sql + where, paramList.toArray(), pageNo, pageSize, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<ConfigInfoBase> findConfigInfoBaseByDataId(int pageNo, int pageSize, String dataId) {
        PaginationHelper<ConfigInfoBase> helper = this.createPaginationHelper();
        try {
            return helper.fetchPage("SELECT count(*) FROM config_info WHERE data_id=? AND tenant_id=?", "SELECT id,data_id,group_id,content FROM config_info WHERE data_id=? AND tenant_id=?", new Object[]{dataId, ""}, pageNo, pageSize, RowMapperManager.CONFIG_INFO_BASE_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<ConfigInfo> findConfigInfoByGroup(int pageNo, int pageSize, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        PaginationHelper<ConfigInfo> helper = this.createPaginationHelper();
        try {
            return helper.fetchPage("SELECT count(*) FROM config_info WHERE group_id=? AND tenant_id=?", "SELECT id,data_id,group_id,tenant_id,app_name,content FROM config_info WHERE group_id=? AND tenant_id=?", new Object[]{group, tenantTmp}, pageNo, pageSize, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<ConfigInfo> findConfigInfoByGroupAndApp(int pageNo, int pageSize, String group, String tenant, String appName) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        PaginationHelper<ConfigInfo> helper = this.createPaginationHelper();
        try {
            return helper.fetchPage("SELECT count(*) FROM config_info WHERE group_id=? AND tenant_id=? AND app_name =?", "SELECT id,data_id,group_id,tenant_id,app_name,content FROM config_info WHERE group_id=? AND tenant_id=? AND app_name =?", new Object[]{group, tenantTmp, appName}, pageNo, pageSize, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<ConfigInfo> findConfigInfoByGroupAndAdvance(int pageNo, int pageSize, String group, String tenant, Map<String, Object> configAdvanceInfo) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        PaginationHelper<ConfigInfo> helper = this.createPaginationHelper();
        String appName = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("appName");
        String configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
        StringBuilder sqlCount = new StringBuilder("SELECT count(*) FROM config_info WHERE group_id=? AND tenant_id=? ");
        StringBuilder sql = new StringBuilder("SELECT id,data_id,group_id,tenant_id,app_name,content FROM config_info WHERE group_id=? AND tenant_id=? ");
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(group);
        paramList.add(tenantTmp);
        if (StringUtils.isNotBlank((String)configTags)) {
            sqlCount = new StringBuilder("SELECT count(*) FROM config_info  a LEFT JOIN config_tags_relation b ON a.id=b.id WHERE a.group_id=? AND a.tenant_id=? ");
            sql = new StringBuilder("SELECT a.id,a.data_id,a.group_id,a.tenant_id,a.app_name,a.content FROM config_info  a LEFT JOIN config_tags_relation b ON a.id=b.id WHERE a.group_id=? AND a.tenant_id=? ");
            sqlCount.append(" AND b.tag_name IN (");
            sql.append(" AND b.tag_name IN (");
            String[] tagArr = configTags.split(",");
            for (int i = 0; i < tagArr.length; ++i) {
                if (i != 0) {
                    sqlCount.append(", ");
                    sql.append(", ");
                }
                sqlCount.append('?');
                sql.append('?');
                paramList.add(tagArr[i]);
            }
            sqlCount.append(") ");
            sql.append(") ");
            if (StringUtils.isNotBlank((String)appName)) {
                sqlCount.append(" AND a.app_name=? ");
                sql.append(" AND a.app_name=? ");
                paramList.add(appName);
            }
        } else if (StringUtils.isNotBlank((String)appName)) {
            sqlCount.append(" AND app_name=? ");
            sql.append(" AND app_name=? ");
            paramList.add(appName);
        }
        try {
            return helper.fetchPage(sqlCount.toString(), sql.toString(), paramList.toArray(), pageNo, pageSize, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<ConfigInfo> findConfigInfoByApp(int pageNo, int pageSize, String tenant, String appName) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        PaginationHelper<ConfigInfo> helper = this.createPaginationHelper();
        try {
            return helper.fetchPage("SELECT count(*) FROM config_info WHERE tenant_id LIKE ? AND app_name=?", "SELECT id,data_id,group_id,tenant_id,app_name,content FROM config_info WHERE tenant_id LIKE ? AND app_name=?", new Object[]{this.generateLikeArgument(tenantTmp), appName}, pageNo, pageSize, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<ConfigInfo> findConfigInfoByAdvance(int pageNo, int pageSize, String tenant, Map<String, Object> configAdvanceInfo) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        PaginationHelper<ConfigInfo> helper = this.createPaginationHelper();
        String appName = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("appName");
        String configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
        StringBuilder sqlCount = new StringBuilder("SELECT count(*) FROM config_info WHERE tenant_id LIKE ? ");
        StringBuilder sql = new StringBuilder("SELECT id,data_id,group_id,tenant_id,app_name,content FROM config_info WHERE tenant_id LIKE ? ");
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(tenantTmp);
        if (StringUtils.isNotBlank((String)configTags)) {
            sqlCount = new StringBuilder("SELECT count(*) FROM config_info a LEFT JOIN config_tags_relation b ON a.id=b.id WHERE a.tenant_id=? ");
            sql = new StringBuilder("SELECT a.id,a.data_id,a.group_id,a.tenant_id,a.app_name,a.content FROM config_info  a LEFT JOIN config_tags_relation b ON a.id=b.id WHERE a.tenant_id=? ");
            sqlCount.append(" AND b.tag_name IN (");
            sql.append(" AND b.tag_name IN (");
            String[] tagArr = configTags.split(",");
            for (int i = 0; i < tagArr.length; ++i) {
                if (i != 0) {
                    sqlCount.append(", ");
                    sql.append(", ");
                }
                sqlCount.append('?');
                sql.append('?');
                paramList.add(tagArr[i]);
            }
            sqlCount.append(") ");
            sql.append(") ");
            if (StringUtils.isNotBlank((String)appName)) {
                sqlCount.append(" AND a.app_name=? ");
                sql.append(" AND a.app_name=? ");
                paramList.add(appName);
            }
        } else if (StringUtils.isNotBlank((String)appName)) {
            sqlCount.append(" AND app_name=? ");
            sql.append(" AND app_name=? ");
            paramList.add(appName);
        }
        try {
            return helper.fetchPage(sqlCount.toString(), sql.toString(), paramList.toArray(), pageNo, pageSize, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<ConfigInfoBase> findConfigInfoBaseByGroup(int pageNo, int pageSize, String group) {
        PaginationHelper<ConfigInfoBase> helper = this.createPaginationHelper();
        try {
            return helper.fetchPage("SELECT count(*) FROM config_info WHERE group_id=? AND tenant_id=?", "SELECT id,data_id,group_id,content FROM config_info WHERE group_id=? AND tenant_id=?", new Object[]{group, ""}, pageNo, pageSize, RowMapperManager.CONFIG_INFO_BASE_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public int configInfoCount() {
        String sql = " SELECT count(*) FROM config_info ";
        Integer result = (Integer)this.jt.queryForObject(sql, Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("configInfoCount error");
        }
        return result;
    }

    @Override
    public int configInfoCount(String tenant) {
        String sql = " SELECT count(*) FROM config_info WHERE tenant_id LIKE ?";
        Integer result = (Integer)this.jt.queryForObject(sql, new Object[]{tenant}, Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("configInfoCount error");
        }
        return result;
    }

    @Override
    public int configInfoBetaCount() {
        String sql = " SELECT count(*) FROM config_info_beta ";
        Integer result = (Integer)this.jt.queryForObject(sql, Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("configInfoBetaCount error");
        }
        return result;
    }

    @Override
    public int configInfoTagCount() {
        String sql = " SELECT count(ID) FROM config_info_tag ";
        Integer result = (Integer)this.jt.queryForObject(sql, Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("configInfoBetaCount error");
        }
        return result;
    }

    @Override
    public List<String> getTenantIdList(int page, int pageSize) {
        String sql = "SELECT tenant_id FROM config_info WHERE tenant_id != '' GROUP BY tenant_id LIMIT ?, ?";
        int from = (page - 1) * pageSize;
        return this.jt.queryForList(sql, String.class, new Object[]{from, pageSize});
    }

    @Override
    public List<String> getGroupIdList(int page, int pageSize) {
        String sql = "SELECT group_id FROM config_info WHERE tenant_id ='' GROUP BY group_id LIMIT ?, ?";
        int from = (page - 1) * pageSize;
        return this.jt.queryForList(sql, String.class, new Object[]{from, pageSize});
    }

    @Override
    public int aggrConfigInfoCount(String dataId, String group, String tenant) {
        String sql = " SELECT count(*) FROM config_info_aggr WHERE data_id = ? AND group_id = ? AND tenant_id = ?";
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        Integer result = (Integer)this.jt.queryForObject(sql, Integer.class, new Object[]{dataId, group, tenantTmp});
        if (result == null) {
            throw new IllegalArgumentException("aggrConfigInfoCount error");
        }
        return result;
    }

    @Override
    public int aggrConfigInfoCount(String dataId, String group, String tenant, List<String> datumIds, boolean isIn) {
        if (datumIds == null || datumIds.isEmpty()) {
            return 0;
        }
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        StringBuilder sql = new StringBuilder(" SELECT count(*) FROM config_info_aggr WHERE data_id = ? AND group_id = ? AND tenant_id = ? AND datum_id");
        if (isIn) {
            sql.append(" IN (");
        } else {
            sql.append(" NOT IN (");
        }
        int size = datumIds.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append('?');
        }
        sql.append(')');
        List objectList = CollectionUtils.list((Object[])new Object[]{dataId, group, tenantTmp});
        objectList.addAll(datumIds);
        Integer result = (Integer)this.jt.queryForObject(sql.toString(), Integer.class, objectList.toArray());
        if (result == null) {
            throw new IllegalArgumentException("aggrConfigInfoCount error");
        }
        return result;
    }

    @Override
    public int aggrConfigInfoCountIn(String dataId, String group, String tenant, List<String> datumIds) {
        return this.aggrConfigInfoCount(dataId, group, tenant, datumIds, true);
    }

    @Override
    public int aggrConfigInfoCountNotIn(String dataId, String group, String tenant, List<String> datumIds) {
        return this.aggrConfigInfoCount(dataId, group, tenant, datumIds, false);
    }

    @Override
    public Page<ConfigInfo> findAllConfigInfo(int pageNo, int pageSize, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String sqlCountRows = "SELECT count(*) FROM config_info";
        String sqlFetchRows = " SELECT t.id,data_id,group_id,tenant_id,app_name,content,md5  FROM (  SELECT id FROM config_info WHERE tenant_id LIKE ? ORDER BY id LIMIT ?,? ) g, config_info t  WHERE g.id = t.id ";
        PaginationHelper<ConfigInfo> helper = this.createPaginationHelper();
        try {
            return helper.fetchPageLimit(sqlCountRows, sqlFetchRows, new Object[]{this.generateLikeArgument(tenantTmp), (pageNo - 1) * pageSize, pageSize}, pageNo, pageSize, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<ConfigKey> findAllConfigKey(int pageNo, int pageSize, String tenant) {
        int pageCount;
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String select = " SELECT data_id,group_id,app_name  FROM (  SELECT id FROM config_info WHERE tenant_id LIKE ? ORDER BY id LIMIT ?, ?  ) g, config_info t WHERE g.id = t.id  ";
        int totalCount = this.configInfoCount(tenant);
        if (totalCount > pageSize * (pageCount = totalCount / pageSize)) {
            ++pageCount;
        }
        if (pageNo > pageCount) {
            return null;
        }
        Page<ConfigKey> page = new Page<ConfigKey>();
        page.setPageNumber(pageNo);
        page.setPagesAvailable(pageCount);
        page.setTotalCount(totalCount);
        try {
            List result = this.jt.query(select, new Object[]{this.generateLikeArgument(tenantTmp), (pageNo - 1) * pageSize, pageSize}, RowMapperManager.CONFIG_KEY_ROW_MAPPER);
            for (ConfigKey item : result) {
                page.getPageItems().add(item);
            }
            return page;
        }
        catch (EmptyResultDataAccessException e) {
            return page;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    @Deprecated
    public Page<ConfigInfoBase> findAllConfigInfoBase(int pageNo, int pageSize) {
        String sqlCountRows = "SELECT count(*) FROM config_info";
        String sqlFetchRows = " SELECT t.id,data_id,group_id,content,md5 FROM ( SELECT id FROM config_info ORDER BY id LIMIT ?,?  )  g, config_info t  WHERE g.id = t.id ";
        PaginationHelper<ConfigInfoBase> helper = this.createPaginationHelper();
        try {
            return helper.fetchPageLimit(sqlCountRows, sqlFetchRows, new Object[]{(pageNo - 1) * pageSize, pageSize}, pageNo, pageSize, RowMapperManager.CONFIG_INFO_BASE_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<ConfigInfoWrapper> findAllConfigInfoForDumpAll(int pageNo, int pageSize) {
        String sqlCountRows = "SELECT count(*) FROM config_info";
        String sqlFetchRows = " SELECT t.id,type,data_id,group_id,tenant_id,app_name,content,type,md5,gmt_modified  FROM ( SELECT id FROM config_info   ORDER BY id LIMIT ?,?  ) g, config_info t WHERE g.id = t.id ";
        PaginationHelper<ConfigInfoWrapper> helper = this.createPaginationHelper();
        ArrayList params = new ArrayList();
        try {
            return helper.fetchPageLimit(sqlCountRows, sqlFetchRows, params.toArray(), pageNo, pageSize, RowMapperManager.CONFIG_INFO_WRAPPER_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<ConfigInfoWrapper> findAllConfigInfoFragment(long lastMaxId, int pageSize) {
        String select = "SELECT id,data_id,group_id,tenant_id,app_name,content,md5,gmt_modified,type FROM config_info WHERE id > ? ORDER BY id ASC LIMIT ?,?";
        PaginationHelper<ConfigInfoWrapper> helper = this.createPaginationHelper();
        try {
            return helper.fetchPageLimit(select, new Object[]{lastMaxId, 0, pageSize}, 1, pageSize, RowMapperManager.CONFIG_INFO_WRAPPER_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<ConfigInfoBetaWrapper> findAllConfigInfoBetaForDumpAll(int pageNo, int pageSize) {
        String sqlCountRows = "SELECT count(*) FROM config_info_beta";
        String sqlFetchRows = " SELECT t.id,data_id,group_id,tenant_id,app_name,content,md5,gmt_modified,beta_ips  FROM ( SELECT id FROM config_info_beta  ORDER BY id LIMIT ?,?  )  g, config_info_beta t WHERE g.id = t.id ";
        PaginationHelper<ConfigInfoBetaWrapper> helper = this.createPaginationHelper();
        try {
            return helper.fetchPageLimit(sqlCountRows, sqlFetchRows, new Object[]{(pageNo - 1) * pageSize, pageSize}, pageNo, pageSize, RowMapperManager.CONFIG_INFO_BETA_WRAPPER_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<ConfigInfoTagWrapper> findAllConfigInfoTagForDumpAll(int pageNo, int pageSize) {
        String sqlCountRows = "SELECT count(*) FROM config_info_tag";
        String sqlFetchRows = " SELECT t.id,data_id,group_id,tenant_id,tag_id,app_name,content,md5,gmt_modified  FROM (  SELECT id FROM config_info_tag  ORDER BY id LIMIT ?,? ) g, config_info_tag t  WHERE g.id = t.id  ";
        PaginationHelper<ConfigInfoTagWrapper> helper = this.createPaginationHelper();
        try {
            return helper.fetchPageLimit(sqlCountRows, sqlFetchRows, new Object[]{(pageNo - 1) * pageSize, pageSize}, pageNo, pageSize, RowMapperManager.CONFIG_INFO_TAG_WRAPPER_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<ConfigInfo> findConfigInfoByBatch(List<String> dataIds, String group, String tenant, int subQueryLimit) {
        String tenantTmp;
        String string = tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        if (org.apache.commons.collections.CollectionUtils.isEmpty(dataIds)) {
            return Collections.emptyList();
        }
        if (subQueryLimit > 50) {
            subQueryLimit = 50;
        }
        ArrayList<ConfigInfo> result = new ArrayList<ConfigInfo>(dataIds.size());
        String sqlStart = "SELECT data_id, group_id, tenant_id, app_name, content FROM config_info WHERE group_id = ? AND tenant_id = ? AND data_id IN (";
        String sqlEnd = ")";
        StringBuilder subQuerySql = new StringBuilder();
        for (int i = 0; i < dataIds.size(); i += subQueryLimit) {
            ArrayList<String> params = new ArrayList<String>(dataIds.subList(i, i + subQueryLimit < dataIds.size() ? i + subQueryLimit : dataIds.size()));
            for (int j = 0; j < params.size(); ++j) {
                subQuerySql.append('?');
                if (j == params.size() - 1) continue;
                subQuerySql.append(',');
            }
            params.add(0, group);
            params.add(1, tenantTmp);
            List r = this.jt.query(sqlStart + subQuerySql.toString() + sqlEnd, params.toArray(), (RowMapper)RowMapperManager.CONFIG_INFO_ROW_MAPPER);
            if (r == null || r.size() <= 0) continue;
            result.addAll(r);
        }
        return result;
    }

    @Override
    public Page<ConfigInfo> findConfigInfoLike(int pageNo, int pageSize, String dataId, String group, String tenant, String appName, String content) {
        String tenantTmp;
        String string = tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        if (StringUtils.isBlank((CharSequence)dataId) && StringUtils.isBlank((CharSequence)group)) {
            if (StringUtils.isBlank((CharSequence)appName)) {
                return this.findAllConfigInfo(pageNo, pageSize, tenantTmp);
            }
            return this.findConfigInfoByApp(pageNo, pageSize, tenantTmp, appName);
        }
        PaginationHelper<ConfigInfo> helper = this.createPaginationHelper();
        String sqlCountRows = "SELECT count(*) FROM config_info WHERE ";
        String sqlFetchRows = "SELECT id,data_id,group_id,tenant_id,app_name,content FROM config_info WHERE ";
        String where = " 1=1 ";
        ArrayList<String> params = new ArrayList<String>();
        if (!StringUtils.isBlank((CharSequence)dataId)) {
            where = where + " AND data_id LIKE ? ";
            params.add(this.generateLikeArgument(dataId));
        }
        if (!StringUtils.isBlank((CharSequence)group)) {
            where = where + " AND group_id LIKE ? ";
            params.add(this.generateLikeArgument(group));
        }
        where = where + " AND tenant_id LIKE ? ";
        params.add(this.generateLikeArgument(tenantTmp));
        if (!StringUtils.isBlank((CharSequence)appName)) {
            where = where + " AND app_name = ? ";
            params.add(appName);
        }
        if (!StringUtils.isBlank((CharSequence)content)) {
            where = where + " AND content LIKE ? ";
            params.add(this.generateLikeArgument(content));
        }
        try {
            return helper.fetchPage(sqlCountRows + where, sqlFetchRows + where, params.toArray(), pageNo, pageSize, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<ConfigInfo> findConfigInfoLike(int pageNo, int pageSize, ConfigKey[] configKeys, boolean blacklist) {
        String sqlCountRows = "SELECT count(*) FROM config_info WHERE ";
        String sqlFetchRows = "SELECT id,data_id,group_id,tenant_id,app_name,content FROM config_info WHERE ";
        StringBuilder where = new StringBuilder(" 1=1 ");
        if (configKeys.length == 0 && !blacklist) {
            Page<ConfigInfo> page = new Page<ConfigInfo>();
            page.setTotalCount(0);
            return page;
        }
        PaginationHelper<ConfigInfo> helper = this.createPaginationHelper();
        ArrayList<String> params = new ArrayList<String>();
        boolean isFirst = true;
        for (ConfigKey configInfo : configKeys) {
            boolean isFirstSub;
            String dataId = configInfo.getDataId();
            String group = configInfo.getGroup();
            String appName = configInfo.getAppName();
            if (StringUtils.isBlank((CharSequence)dataId) && StringUtils.isBlank((CharSequence)group) && StringUtils.isBlank((CharSequence)appName)) break;
            if (blacklist) {
                if (isFirst) {
                    isFirst = false;
                    where.append(" AND ");
                } else {
                    where.append(" AND ");
                }
                where.append('(');
                isFirstSub = true;
                if (!StringUtils.isBlank((CharSequence)dataId)) {
                    where.append(" data_id NOT LIKE ? ");
                    params.add(this.generateLikeArgument(dataId));
                    isFirstSub = false;
                }
                if (!StringUtils.isBlank((CharSequence)group)) {
                    if (!isFirstSub) {
                        where.append(" OR ");
                    }
                    where.append(" group_id NOT LIKE ? ");
                    params.add(this.generateLikeArgument(group));
                    isFirstSub = false;
                }
                if (!StringUtils.isBlank((CharSequence)appName)) {
                    if (!isFirstSub) {
                        where.append(" OR ");
                    }
                    where.append(" app_name != ? ");
                    params.add(appName);
                    isFirstSub = false;
                }
                where.append(") ");
                continue;
            }
            if (isFirst) {
                isFirst = false;
                where.append(" AND ");
            } else {
                where.append(" OR ");
            }
            where.append('(');
            isFirstSub = true;
            if (!StringUtils.isBlank((CharSequence)dataId)) {
                where.append(" data_id LIKE ? ");
                params.add(this.generateLikeArgument(dataId));
                isFirstSub = false;
            }
            if (!StringUtils.isBlank((CharSequence)group)) {
                if (!isFirstSub) {
                    where.append(" AND ");
                }
                where.append(" group_id LIKE ? ");
                params.add(this.generateLikeArgument(group));
                isFirstSub = false;
            }
            if (!StringUtils.isBlank((CharSequence)appName)) {
                if (!isFirstSub) {
                    where.append(" AND ");
                }
                where.append(" app_name = ? ");
                params.add(appName);
                isFirstSub = false;
            }
            where.append(") ");
        }
        try {
            return helper.fetchPage(sqlCountRows + where.toString(), sqlFetchRows + where.toString(), params.toArray(), pageNo, pageSize, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<ConfigInfo> findConfigInfoLike4Page(int pageNo, int pageSize, String dataId, String group, String tenant, Map<String, Object> configAdvanceInfo) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String appName = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("appName");
        String content = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("content");
        String configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
        PaginationHelper<ConfigInfo> helper = this.createPaginationHelper();
        String sqlCountRows = "SELECT count(*) FROM config_info";
        String sqlFetchRows = "SELECT id,data_id,group_id,tenant_id,app_name,content FROM config_info";
        StringBuilder where = new StringBuilder(" WHERE ");
        ArrayList<String> params = new ArrayList<String>();
        params.add(this.generateLikeArgument(tenantTmp));
        if (StringUtils.isNotBlank((String)configTags)) {
            sqlCountRows = "SELECT count(*) FROM config_info  a LEFT JOIN config_tags_relation b ON a.id=b.id ";
            sqlFetchRows = "SELECT a.id,a.data_id,a.group_id,a.tenant_id,a.app_name,a.content FROM config_info a LEFT JOIN config_tags_relation b ON a.id=b.id ";
            where.append(" a.tenant_id LIKE ? ");
            if (!StringUtils.isBlank((CharSequence)dataId)) {
                where.append(" AND a.data_id LIKE ? ");
                params.add(this.generateLikeArgument(dataId));
            }
            if (!StringUtils.isBlank((CharSequence)group)) {
                where.append(" AND a.group_id LIKE ? ");
                params.add(this.generateLikeArgument(group));
            }
            if (!StringUtils.isBlank((CharSequence)appName)) {
                where.append(" AND a.app_name = ? ");
                params.add(appName);
            }
            if (!StringUtils.isBlank((CharSequence)content)) {
                where.append(" AND a.content LIKE ? ");
                params.add(this.generateLikeArgument(content));
            }
            where.append(" AND b.tag_name IN (");
            String[] tagArr = configTags.split(",");
            for (int i = 0; i < tagArr.length; ++i) {
                if (i != 0) {
                    where.append(", ");
                }
                where.append('?');
                params.add(tagArr[i]);
            }
            where.append(") ");
        } else {
            where.append(" tenant_id LIKE ? ");
            if (!StringUtils.isBlank((CharSequence)dataId)) {
                where.append(" AND data_id LIKE ? ");
                params.add(this.generateLikeArgument(dataId));
            }
            if (!StringUtils.isBlank((CharSequence)group)) {
                where.append(" AND group_id LIKE ? ");
                params.add(this.generateLikeArgument(group));
            }
            if (!StringUtils.isBlank((CharSequence)appName)) {
                where.append(" AND app_name = ? ");
                params.add(appName);
            }
            if (!StringUtils.isBlank((CharSequence)content)) {
                where.append(" AND content LIKE ? ");
                params.add(this.generateLikeArgument(content));
            }
        }
        try {
            return helper.fetchPage(sqlCountRows + where, sqlFetchRows + where, params.toArray(), pageNo, pageSize, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<ConfigInfoBase> findConfigInfoBaseLike(int pageNo, int pageSize, String dataId, String group, String content) throws IOException {
        if (StringUtils.isBlank((CharSequence)dataId) && StringUtils.isBlank((CharSequence)group)) {
            throw new IOException("invalid param");
        }
        PaginationHelper<ConfigInfoBase> helper = this.createPaginationHelper();
        String sqlCountRows = "SELECT count(*) FROM config_info WHERE ";
        String sqlFetchRows = "SELECT id,data_id,group_id,tenant_id,content FROM config_info WHERE ";
        String where = " 1=1 AND tenant_id='' ";
        ArrayList<String> params = new ArrayList<String>();
        if (!StringUtils.isBlank((CharSequence)dataId)) {
            where = where + " AND data_id LIKE ? ";
            params.add(this.generateLikeArgument(dataId));
        }
        if (!StringUtils.isBlank((CharSequence)group)) {
            where = where + " AND group_id LIKE ";
            params.add(this.generateLikeArgument(group));
        }
        if (!StringUtils.isBlank((CharSequence)content)) {
            where = where + " AND content LIKE ? ";
            params.add(this.generateLikeArgument(content));
        }
        try {
            return helper.fetchPage(sqlCountRows + where, sqlFetchRows + where, params.toArray(), pageNo, pageSize, RowMapperManager.CONFIG_INFO_BASE_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public ConfigInfoAggr findSingleConfigInfoAggr(String dataId, String group, String tenant, String datumId) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String sql = "SELECT id,data_id,group_id,tenant_id,datum_id,app_name,content FROM config_info_aggr WHERE data_id=? AND group_id=? AND tenant_id=? AND datum_id=?";
        try {
            return (ConfigInfoAggr)this.jt.queryForObject(sql, new Object[]{dataId, group, tenantTmp, datumId}, (RowMapper)RowMapperManager.CONFIG_INFO_AGGR_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LogUtil.FATAL_LOG.error("[db-other-error]" + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<ConfigInfoAggr> findConfigInfoAggr(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String sql = "SELECT data_id,group_id,tenant_id,datum_id,app_name,content FROM config_info_aggr WHERE data_id=? AND group_id=? AND tenant_id=? ORDER BY datum_id";
        try {
            return this.jt.query(sql, new Object[]{dataId, group, tenantTmp}, (RowMapper)RowMapperManager.CONFIG_INFO_AGGR_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
        catch (EmptyResultDataAccessException e) {
            return Collections.emptyList();
        }
        catch (Exception e) {
            LogUtil.FATAL_LOG.error("[db-other-error]" + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public Page<ConfigInfoAggr> findConfigInfoAggrByPage(String dataId, String group, String tenant, int pageNo, int pageSize) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String sqlCountRows = "SELECT count(*) FROM config_info_aggr WHERE data_id = ? AND group_id = ? AND tenant_id = ?";
        String sqlFetchRows = "SELECT data_id,group_id,tenant_id,datum_id,app_name,content FROM config_info_aggr WHERE data_id=? AND group_id=? AND tenant_id=? ORDER BY datum_id LIMIT ?,?";
        PaginationHelper<ConfigInfoAggr> helper = this.createPaginationHelper();
        try {
            return helper.fetchPageLimit(sqlCountRows, new Object[]{dataId, group, tenantTmp}, sqlFetchRows, new Object[]{dataId, group, tenantTmp, (pageNo - 1) * pageSize, pageSize}, pageNo, pageSize, RowMapperManager.CONFIG_INFO_AGGR_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<ConfigInfoAggr> findConfigInfoAggrLike(int pageNo, int pageSize, ConfigKey[] configKeys, boolean blacklist) {
        String sqlCountRows = "SELECT count(*) FROM config_info_aggr WHERE ";
        String sqlFetchRows = "SELECT data_id,group_id,tenant_id,datum_id,app_name,content FROM config_info_aggr WHERE ";
        StringBuilder where = new StringBuilder(" 1=1 ");
        if (configKeys.length == 0 && !blacklist) {
            Page<ConfigInfoAggr> page = new Page<ConfigInfoAggr>();
            page.setTotalCount(0);
            return page;
        }
        PaginationHelper<ConfigInfoAggr> helper = this.createPaginationHelper();
        ArrayList<String> params = new ArrayList<String>();
        boolean isFirst = true;
        for (ConfigKey configInfoAggr : configKeys) {
            boolean isFirstSub;
            String dataId = configInfoAggr.getDataId();
            String group = configInfoAggr.getGroup();
            String appName = configInfoAggr.getAppName();
            if (StringUtils.isBlank((CharSequence)dataId) && StringUtils.isBlank((CharSequence)group) && StringUtils.isBlank((CharSequence)appName)) break;
            if (blacklist) {
                if (isFirst) {
                    isFirst = false;
                    where.append(" AND ");
                } else {
                    where.append(" AND ");
                }
                where.append('(');
                isFirstSub = true;
                if (!StringUtils.isBlank((CharSequence)dataId)) {
                    where.append(" data_id NOT LIKE ? ");
                    params.add(this.generateLikeArgument(dataId));
                    isFirstSub = false;
                }
                if (!StringUtils.isBlank((CharSequence)group)) {
                    if (!isFirstSub) {
                        where.append(" OR ");
                    }
                    where.append(" group_id NOT LIKE ? ");
                    params.add(this.generateLikeArgument(group));
                    isFirstSub = false;
                }
                if (!StringUtils.isBlank((CharSequence)appName)) {
                    if (!isFirstSub) {
                        where.append(" OR ");
                    }
                    where.append(" app_name != ? ");
                    params.add(appName);
                    isFirstSub = false;
                }
                where.append(") ");
                continue;
            }
            if (isFirst) {
                isFirst = false;
                where.append(" AND ");
            } else {
                where.append(" OR ");
            }
            where.append('(');
            isFirstSub = true;
            if (!StringUtils.isBlank((CharSequence)dataId)) {
                where.append(" data_id LIKE ? ");
                params.add(this.generateLikeArgument(dataId));
                isFirstSub = false;
            }
            if (!StringUtils.isBlank((CharSequence)group)) {
                if (!isFirstSub) {
                    where.append(" AND ");
                }
                where.append(" group_id LIKE ? ");
                params.add(this.generateLikeArgument(group));
                isFirstSub = false;
            }
            if (!StringUtils.isBlank((CharSequence)appName)) {
                if (!isFirstSub) {
                    where.append(" AND ");
                }
                where.append(" app_name = ? ");
                params.add(appName);
                isFirstSub = false;
            }
            where.append(") ");
        }
        try {
            Page<ConfigInfoAggr> result = helper.fetchPage(sqlCountRows + where.toString(), sqlFetchRows + where.toString(), params.toArray(), pageNo, pageSize, RowMapperManager.CONFIG_INFO_AGGR_ROW_MAPPER);
            return result;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<ConfigInfoChanged> findAllAggrGroup() {
        String sql = "SELECT DISTINCT data_id, group_id, tenant_id FROM config_info_aggr";
        try {
            return this.jt.query(sql, new Object[0], (RowMapper)RowMapperManager.CONFIG_INFO_CHANGED_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (Exception e) {
            LogUtil.FATAL_LOG.error("[db-other-error]" + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<String> findDatumIdByContent(String dataId, String groupId, String content) {
        String sql = "SELECT datum_id FROM config_info_aggr WHERE data_id = ? AND group_id = ? AND content = ? ";
        try {
            return this.jt.queryForList(sql, new Object[]{dataId, groupId, content}, String.class);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (IncorrectResultSizeDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<ConfigInfoWrapper> findChangeConfig(Timestamp startTime, Timestamp endTime) {
        try {
            List list = this.jt.queryForList("SELECT data_id, group_id, tenant_id, app_name, content, gmt_modified FROM config_info WHERE gmt_modified >=? AND gmt_modified <= ?", new Object[]{startTime, endTime});
            return this.convertChangeConfig(list);
        }
        catch (DataAccessException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<ConfigInfoWrapper> findChangeConfig(String dataId, String group, String tenant, String appName, Timestamp startTime, Timestamp endTime, int pageNo, int pageSize, long lastMaxId) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String sqlCountRows = "SELECT count(*) FROM config_info WHERE ";
        String sqlFetchRows = "SELECT id,data_id,group_id,tenant_id,app_name,content,type,md5,gmt_modified FROM config_info WHERE ";
        String where = " 1=1 ";
        ArrayList<Object> params = new ArrayList<Object>();
        if (!StringUtils.isBlank((CharSequence)dataId)) {
            where = where + " AND data_id LIKE ? ";
            params.add(this.generateLikeArgument(dataId));
        }
        if (!StringUtils.isBlank((CharSequence)group)) {
            where = where + " AND group_id LIKE ? ";
            params.add(this.generateLikeArgument(group));
        }
        if (!StringUtils.isBlank((CharSequence)tenantTmp)) {
            where = where + " AND tenant_id = ? ";
            params.add(tenantTmp);
        }
        if (!StringUtils.isBlank((CharSequence)appName)) {
            where = where + " AND app_name = ? ";
            params.add(appName);
        }
        if (startTime != null) {
            where = where + " AND gmt_modified >=? ";
            params.add(startTime);
        }
        if (endTime != null) {
            where = where + " AND gmt_modified <=? ";
            params.add(endTime);
        }
        PaginationHelper<ConfigInfoWrapper> helper = this.createPaginationHelper();
        try {
            return helper.fetchPage(sqlCountRows + where, sqlFetchRows + where, params.toArray(), pageNo, pageSize, lastMaxId, RowMapperManager.CONFIG_INFO_WRAPPER_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<ConfigInfo> findDeletedConfig(Timestamp startTime, Timestamp endTime) {
        try {
            List list = this.jt.queryForList("SELECT DISTINCT data_id, group_id, tenant_id FROM his_config_info WHERE op_type = 'D' AND gmt_modified >=? AND gmt_modified <= ?", new Object[]{startTime, endTime});
            return this.convertDeletedConfig(list);
        }
        catch (DataAccessException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public long addConfigInfoAtomic(long configId, final String srcIp, final String srcUser, final ConfigInfo configInfo, final Timestamp time, Map<String, Object> configAdvanceInfo) {
        final String appNameTmp = StringUtils.isBlank((CharSequence)configInfo.getAppName()) ? "" : configInfo.getAppName();
        final String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
        final String desc = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("desc");
        final String use = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("use");
        final String effect = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("effect");
        final String type = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("type");
        final String schema = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("schema");
        final String md5Tmp = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        String sql = "INSERT INTO config_info(data_id,group_id,tenant_id,app_name,content,md5,src_ip,src_user,gmt_create,gmt_modified,c_desc,c_use,effect,type,c_schema) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        try {
            this.jt.update(new PreparedStatementCreator(){

                public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                    PreparedStatement ps = connection.prepareStatement("INSERT INTO config_info(data_id,group_id,tenant_id,app_name,content,md5,src_ip,src_user,gmt_create,gmt_modified,c_desc,c_use,effect,type,c_schema) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", 1);
                    ps.setString(1, configInfo.getDataId());
                    ps.setString(2, configInfo.getGroup());
                    ps.setString(3, tenantTmp);
                    ps.setString(4, appNameTmp);
                    ps.setString(5, configInfo.getContent());
                    ps.setString(6, md5Tmp);
                    ps.setString(7, srcIp);
                    ps.setString(8, srcUser);
                    ps.setTimestamp(9, time);
                    ps.setTimestamp(10, time);
                    ps.setString(11, desc);
                    ps.setString(12, use);
                    ps.setString(13, effect);
                    ps.setString(14, type);
                    ps.setString(15, schema);
                    return ps;
                }
            }, (KeyHolder)keyHolder);
            Number nu = keyHolder.getKey();
            if (nu == null) {
                throw new IllegalArgumentException("insert config_info fail");
            }
            return nu.longValue();
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void addConfigTagsRelation(long configId, String configTags, String dataId, String group, String tenant) {
        if (StringUtils.isNotBlank((String)configTags)) {
            String[] tagArr = configTags.split(",");
            for (int i = 0; i < tagArr.length; ++i) {
                this.addConfigTagRelationAtomic(configId, tagArr[i], dataId, group, tenant);
            }
        }
    }

    @Override
    public void addConfigTagRelationAtomic(long configId, String tagName, String dataId, String group, String tenant) {
        try {
            this.jt.update("INSERT INTO config_tags_relation(id,tag_name,tag_type,data_id,group_id,tenant_id) VALUES(?,?,?,?,?,?)", new Object[]{configId, tagName, null, dataId, group, tenant});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void removeTagByIdAtomic(long id) {
        try {
            this.jt.update("DELETE FROM config_tags_relation WHERE id=?", new Object[]{id});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<String> getConfigTagsByTenant(String tenant) {
        String sql = "SELECT tag_name FROM config_tags_relation WHERE tenant_id = ? ";
        try {
            return this.jt.queryForList(sql, new Object[]{tenant}, String.class);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (IncorrectResultSizeDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<String> selectTagByConfig(String dataId, String group, String tenant) {
        String sql = "SELECT tag_name FROM config_tags_relation WHERE data_id=? AND group_id=? AND tenant_id = ? ";
        try {
            return this.jt.queryForList(sql, new Object[]{dataId, group, tenant}, String.class);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (IncorrectResultSizeDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void removeConfigInfoAtomic(String dataId, String group, String tenant, String srcIp, String srcUser) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        try {
            this.jt.update("DELETE FROM config_info WHERE data_id=? AND group_id=? AND tenant_id=?", new Object[]{dataId, group, tenantTmp});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void removeConfigInfoByIdsAtomic(String ids) {
        if (StringUtils.isBlank((CharSequence)ids)) {
            return;
        }
        StringBuilder sql = new StringBuilder(SQL_DELETE_CONFIG_INFO_BY_IDS);
        sql.append("id IN (");
        ArrayList<Long> paramList = new ArrayList<Long>();
        String[] tagArr = ids.split(",");
        for (int i = 0; i < tagArr.length; ++i) {
            if (i != 0) {
                sql.append(", ");
            }
            sql.append('?');
            paramList.add(Long.parseLong(tagArr[i]));
        }
        sql.append(") ");
        try {
            this.jt.update(sql.toString(), paramList.toArray());
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void removeConfigInfoTag(String dataId, String group, String tenant, String tag, String srcIp, String srcUser) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String tagTmp = StringUtils.isBlank((CharSequence)tag) ? "" : tag;
        try {
            this.jt.update("DELETE FROM config_info_tag WHERE data_id=? AND group_id=? AND tenant_id=? AND tag_id=?", new Object[]{dataId, group, tenantTmp, tagTmp});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void updateConfigInfoAtomic(ConfigInfo configInfo, String srcIp, String srcUser, Timestamp time, Map<String, Object> configAdvanceInfo) {
        String appNameTmp = StringUtils.isBlank((CharSequence)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
        String md5Tmp = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
        String desc = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("desc");
        String use = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("use");
        String effect = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("effect");
        String type = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("type");
        String schema = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("schema");
        try {
            this.jt.update("UPDATE config_info SET content=?, md5 = ?, src_ip=?,src_user=?,gmt_modified=?,app_name=?,c_desc=?,c_use=?,effect=?,type=?,c_schema=? WHERE data_id=? AND group_id=? AND tenant_id=?", new Object[]{configInfo.getContent(), md5Tmp, srcIp, srcUser, time, appNameTmp, desc, use, effect, type, schema, configInfo.getDataId(), configInfo.getGroup(), tenantTmp});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    private int updateConfigInfoAtomicCas(ConfigInfo configInfo, String srcIp, String srcUser, Timestamp time, Map<String, Object> configAdvanceInfo) {
        String appNameTmp = StringUtils.isBlank((CharSequence)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
        String md5Tmp = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
        String desc = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("desc");
        String use = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("use");
        String effect = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("effect");
        String type = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("type");
        String schema = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("schema");
        try {
            return this.jt.update("UPDATE config_info SET content=?, md5 = ?, src_ip=?,src_user=?,gmt_modified=?,app_name=?,c_desc=?,c_use=?,effect=?,type=?,c_schema=? WHERE data_id=? AND group_id=? AND tenant_id=? AND (md5=? OR md5 IS NULL OR md5='')", new Object[]{configInfo.getContent(), md5Tmp, srcIp, srcUser, time, appNameTmp, desc, use, effect, type, schema, configInfo.getDataId(), configInfo.getGroup(), tenantTmp, configInfo.getMd5()});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<ConfigInfo> findConfigInfosByIds(String ids) {
        if (StringUtils.isBlank((CharSequence)ids)) {
            return null;
        }
        StringBuilder sql = new StringBuilder(SQL_FIND_CONFIG_INFO_BY_IDS);
        sql.append("id IN (");
        ArrayList<Long> paramList = new ArrayList<Long>();
        String[] tagArr = ids.split(",");
        for (int i = 0; i < tagArr.length; ++i) {
            if (i != 0) {
                sql.append(", ");
            }
            sql.append('?');
            paramList.add(Long.parseLong(tagArr[i]));
        }
        sql.append(") ");
        try {
            return this.jt.query(sql.toString(), paramList.toArray(), (RowMapper)RowMapperManager.CONFIG_INFO_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public ConfigAdvanceInfo findConfigAdvanceInfo(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        try {
            List<String> configTagList = this.selectTagByConfig(dataId, group, tenant);
            ConfigAdvanceInfo configAdvance = (ConfigAdvanceInfo)this.jt.queryForObject("SELECT gmt_create,gmt_modified,src_user,src_ip,c_desc,c_use,effect,type,c_schema FROM config_info WHERE data_id=? AND group_id=? AND tenant_id=?", new Object[]{dataId, group, tenantTmp}, (RowMapper)RowMapperManager.CONFIG_ADVANCE_INFO_ROW_MAPPER);
            if (configTagList != null && !configTagList.isEmpty()) {
                StringBuilder configTagsTmp = new StringBuilder();
                for (String configTag : configTagList) {
                    if (configTagsTmp.length() == 0) {
                        configTagsTmp.append(configTag);
                        continue;
                    }
                    configTagsTmp.append(',').append(configTag);
                }
                configAdvance.setConfigTags(configTagsTmp.toString());
            }
            return configAdvance;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public ConfigAllInfo findConfigAllInfo(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        try {
            List<String> configTagList = this.selectTagByConfig(dataId, group, tenant);
            ConfigAllInfo configAdvance = (ConfigAllInfo)this.jt.queryForObject("SELECT id,data_id,group_id,tenant_id,app_name,content,md5,gmt_create,gmt_modified,src_user,src_ip,c_desc,c_use,effect,type,c_schema FROM config_info WHERE data_id=? AND group_id=? AND tenant_id=?", new Object[]{dataId, group, tenantTmp}, (RowMapper)RowMapperManager.CONFIG_ALL_INFO_ROW_MAPPER);
            if (configTagList != null && !configTagList.isEmpty()) {
                StringBuilder configTagsTmp = new StringBuilder();
                for (String configTag : configTagList) {
                    if (configTagsTmp.length() == 0) {
                        configTagsTmp.append(configTag);
                        continue;
                    }
                    configTagsTmp.append(',').append(configTag);
                }
                configAdvance.setConfigTags(configTagsTmp.toString());
            }
            return configAdvance;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void insertConfigHistoryAtomic(long id, ConfigInfo configInfo, String srcIp, String srcUser, Timestamp time, String ops) {
        String appNameTmp = StringUtils.isBlank((CharSequence)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
        String md5Tmp = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
        try {
            this.jt.update("INSERT INTO his_config_info (id,data_id,group_id,tenant_id,app_name,content,md5,src_ip,src_user,gmt_modified,op_type) VALUES(?,?,?,?,?,?,?,?,?,?,?)", new Object[]{id, configInfo.getDataId(), configInfo.getGroup(), tenantTmp, appNameTmp, configInfo.getContent(), md5Tmp, srcIp, srcUser, time, ops});
        }
        catch (DataAccessException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<ConfigHistoryInfo> findConfigHistory(String dataId, String group, String tenant, int pageNo, int pageSize) {
        PaginationHelper<ConfigHistoryInfo> helper = this.createPaginationHelper();
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String sqlCountRows = "SELECT count(*) FROM his_config_info WHERE data_id = ? AND group_id = ? AND tenant_id = ?";
        String sqlFetchRows = "SELECT nid,data_id,group_id,tenant_id,app_name,src_ip,src_user,op_type,gmt_create,gmt_modified FROM his_config_info WHERE data_id = ? AND group_id = ? AND tenant_id = ? ORDER BY nid DESC";
        Page<ConfigHistoryInfo> page = null;
        try {
            page = helper.fetchPage(sqlCountRows, sqlFetchRows, new Object[]{dataId, group, tenantTmp}, pageNo, pageSize, RowMapperManager.HISTORY_LIST_ROW_MAPPER);
        }
        catch (DataAccessException e) {
            LogUtil.FATAL_LOG.error("[list-config-history] error, dataId:{}, group:{}", (Object)new Object[]{dataId, group}, (Object)e);
            throw e;
        }
        return page;
    }

    @Override
    public void addConfigSubAtomic(String dataId, String group, String appName, Timestamp date) {
        String appNameTmp = appName == null ? "" : appName;
        try {
            this.jt.update("INSERT INTO app_configdata_relation_subs(data_id,group_id,app_name,gmt_modified) VALUES(?,?,?,?)", new Object[]{dataId, group, appNameTmp, date});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void updateConfigSubAtomic(String dataId, String group, String appName, Timestamp time) {
        String appNameTmp = appName == null ? "" : appName;
        try {
            this.jt.update("UPDATE app_configdata_relation_subs SET gmt_modified=? WHERE data_id=? AND group_id=? AND app_name=?", new Object[]{time, dataId, group, appNameTmp});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public ConfigHistoryInfo detailConfigHistory(Long nid) {
        String sqlFetchRows = "SELECT nid,data_id,group_id,tenant_id,app_name,content,md5,src_user,src_ip,op_type,gmt_create,gmt_modified FROM his_config_info WHERE nid = ?";
        try {
            ConfigHistoryInfo historyInfo = (ConfigHistoryInfo)this.jt.queryForObject(sqlFetchRows, new Object[]{nid}, (RowMapper)RowMapperManager.HISTORY_DETAIL_ROW_MAPPER);
            return historyInfo;
        }
        catch (DataAccessException e) {
            LogUtil.FATAL_LOG.error("[detail-config-history] error, nid:{}", (Object)new Object[]{nid}, (Object)e);
            throw e;
        }
    }

    @Override
    public ConfigHistoryInfo detailPreviousConfigHistory(Long id) {
        String sqlFetchRows = "SELECT nid,data_id,group_id,tenant_id,app_name,content,md5,src_user,src_ip,op_type,gmt_create,gmt_modified FROM his_config_info WHERE nid = (SELECT max(nid) FROM his_config_info WHERE id = ?) ";
        try {
            ConfigHistoryInfo historyInfo = (ConfigHistoryInfo)this.jt.queryForObject(sqlFetchRows, new Object[]{id}, (RowMapper)RowMapperManager.HISTORY_DETAIL_ROW_MAPPER);
            return historyInfo;
        }
        catch (DataAccessException e) {
            LogUtil.FATAL_LOG.error("[detail-previous-config-history] error, id:{}", (Object)new Object[]{id}, (Object)e);
            throw e;
        }
    }

    @Override
    public void insertTenantInfoAtomic(String kp, String tenantId, String tenantName, String tenantDesc, String createResoure, long time) {
        try {
            this.jt.update("INSERT INTO tenant_info(kp,tenant_id,tenant_name,tenant_desc,create_source,gmt_create,gmt_modified) VALUES(?,?,?,?,?,?,?)", new Object[]{kp, tenantId, tenantName, tenantDesc, createResoure, time, time});
        }
        catch (DataAccessException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void updateTenantNameAtomic(String kp, String tenantId, String tenantName, String tenantDesc) {
        try {
            this.jt.update("UPDATE tenant_info SET tenant_name = ?, tenant_desc = ?, gmt_modified= ? WHERE kp=? AND tenant_id=?", new Object[]{tenantName, tenantDesc, System.currentTimeMillis(), kp, tenantId});
        }
        catch (DataAccessException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<TenantInfo> findTenantByKp(String kp) {
        String sql = "SELECT tenant_id,tenant_name,tenant_desc FROM tenant_info WHERE kp=?";
        try {
            return this.jt.query(sql, new Object[]{kp}, RowMapperManager.TENANT_INFO_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
        catch (EmptyResultDataAccessException e) {
            return Collections.emptyList();
        }
        catch (Exception e) {
            LogUtil.FATAL_LOG.error("[db-other-error]" + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public TenantInfo findTenantByKp(String kp, String tenantId) {
        String sql = "SELECT tenant_id,tenant_name,tenant_desc FROM tenant_info WHERE kp=? AND tenant_id=?";
        try {
            return (TenantInfo)this.jt.queryForObject(sql, new Object[]{kp, tenantId}, RowMapperManager.TENANT_INFO_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (Exception e) {
            LogUtil.FATAL_LOG.error("[db-other-error]" + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void removeTenantInfoAtomic(String kp, String tenantId) {
        try {
            this.jt.update("DELETE FROM tenant_info WHERE kp=? AND tenant_id=?", new Object[]{kp, tenantId});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<ConfigInfo> convertDeletedConfig(List<Map<String, Object>> list) {
        ArrayList<ConfigInfo> configs = new ArrayList<ConfigInfo>();
        for (Map<String, Object> map : list) {
            String dataId = (String)map.get("data_id");
            String group = (String)map.get("group_id");
            String tenant = (String)map.get("tenant_id");
            ConfigInfo config = new ConfigInfo();
            config.setDataId(dataId);
            config.setGroup(group);
            config.setTenant(tenant);
            configs.add(config);
        }
        return configs;
    }

    @Override
    public List<ConfigInfoWrapper> convertChangeConfig(List<Map<String, Object>> list) {
        ArrayList<ConfigInfoWrapper> configs = new ArrayList<ConfigInfoWrapper>();
        for (Map<String, Object> map : list) {
            String dataId = (String)map.get("data_id");
            String group = (String)map.get("group_id");
            String tenant = (String)map.get("tenant_id");
            String content = (String)map.get("content");
            long mTime = ((Timestamp)map.get("gmt_modified")).getTime();
            ConfigInfoWrapper config = new ConfigInfoWrapper();
            config.setDataId(dataId);
            config.setGroup(group);
            config.setTenant(tenant);
            config.setContent(content);
            config.setLastModified(mTime);
            configs.add(config);
        }
        return configs;
    }

    @Override
    public List<ConfigInfoWrapper> listAllGroupKeyMd5() {
        int pageSize = 10000;
        int totalCount = this.configInfoCount();
        int pageCount = (int)Math.ceil((double)totalCount * 1.0 / 10000.0);
        ArrayList<ConfigInfoWrapper> allConfigInfo = new ArrayList<ConfigInfoWrapper>();
        for (int pageNo = 1; pageNo <= pageCount; ++pageNo) {
            List<ConfigInfoWrapper> configInfoList = this.listGroupKeyMd5ByPage(pageNo, 10000);
            allConfigInfo.addAll(configInfoList);
        }
        return allConfigInfo;
    }

    @Override
    public List<ConfigInfoWrapper> listGroupKeyMd5ByPage(int pageNo, int pageSize) {
        String sqlCountRows = " SELECT count(*) FROM config_info ";
        String sqlFetchRows = " SELECT t.id,data_id,group_id,tenant_id,app_name,md5,type,gmt_modified FROM ( SELECT id FROM config_info ORDER BY id LIMIT ?,?  ) g, config_info t WHERE g.id = t.id";
        PaginationHelper<ConfigInfoWrapper> helper = this.createPaginationHelper();
        try {
            Page<ConfigInfoWrapper> page = helper.fetchPageLimit(sqlCountRows, sqlFetchRows, new Object[]{(pageNo - 1) * pageSize, pageSize}, pageNo, pageSize, RowMapperManager.CONFIG_INFO_WRAPPER_ROW_MAPPER);
            return page.getPageItems();
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public String generateLikeArgument(String s) {
        String fuzzySearchSign = "\\*";
        String sqlLikePercentSign = "%";
        if (s.contains(PATTERN_STR)) {
            return s.replaceAll(fuzzySearchSign, sqlLikePercentSign);
        }
        return s;
    }

    @Override
    public ConfigInfoWrapper queryConfigInfo(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        try {
            return (ConfigInfoWrapper)this.jt.queryForObject("SELECT id,data_id,group_id,tenant_id,app_name,content,type,gmt_modified,md5 FROM config_info WHERE data_id=? AND group_id=? AND tenant_id=?", new Object[]{dataId, group, tenantTmp}, RowMapperManager.CONFIG_INFO_WRAPPER_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public boolean isExistTable(String tableName) {
        String sql = String.format("SELECT 1 FROM %s LIMIT 1", tableName);
        try {
            this.jt.queryForObject(sql, Integer.class);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public Boolean completeMd5() {
        LogUtil.DEFAULT_LOG.info("[start completeMd5]");
        int perPageSize = 1000;
        int rowCount = this.configInfoCount();
        int pageCount = (int)Math.ceil((double)rowCount * 1.0 / (double)perPageSize);
        int actualRowCount = 0;
        for (int pageNo = 1; pageNo <= pageCount; ++pageNo) {
            Page<ConfigInfoWrapper> page = this.findAllConfigInfoForDumpAll(pageNo, perPageSize);
            if (page == null) continue;
            for (ConfigInfoWrapper cf : page.getPageItems()) {
                String md5InDb = cf.getMd5();
                String content = cf.getContent();
                String tenant = cf.getTenant();
                String md5 = MD5Utils.md5Hex((String)content, (String)"UTF-8");
                if (StringUtils.isBlank((CharSequence)md5InDb)) {
                    try {
                        this.updateMd5(cf.getDataId(), cf.getGroup(), tenant, md5, new Timestamp(cf.getLastModified()));
                    }
                    catch (Exception e) {
                        LogUtil.DEFAULT_LOG.error("[completeMd5-error] datId:{} group:{} lastModified:{}", new Object[]{cf.getDataId(), cf.getGroup(), new Timestamp(cf.getLastModified())});
                    }
                    continue;
                }
                if (md5InDb.equals(md5)) continue;
                try {
                    this.updateMd5(cf.getDataId(), cf.getGroup(), tenant, md5, new Timestamp(cf.getLastModified()));
                }
                catch (Exception e) {
                    LogUtil.DEFAULT_LOG.error("[completeMd5-error] datId:{} group:{} lastModified:{}", new Object[]{cf.getDataId(), cf.getGroup(), new Timestamp(cf.getLastModified())});
                }
            }
            LogUtil.DEFAULT_LOG.info("[completeMd5] {} / {}", (Object)(actualRowCount += page.getPageItems().size()), (Object)rowCount);
        }
        return true;
    }

    @Override
    public List<ConfigAllInfo> findAllConfigInfo4Export(String dataId, String group, String tenant, String appName, List<Long> ids) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        StringBuilder where = new StringBuilder(" WHERE ");
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(ids)) {
            where.append(" id IN (");
            for (int i = 0; i < ids.size(); ++i) {
                if (i != 0) {
                    where.append(", ");
                }
                where.append('?');
                paramList.add(ids.get(i));
            }
            where.append(") ");
        } else {
            where.append(" tenant_id=? ");
            paramList.add(tenantTmp);
            if (!StringUtils.isBlank((CharSequence)dataId)) {
                where.append(" AND data_id LIKE ? ");
                paramList.add(this.generateLikeArgument(dataId));
            }
            if (StringUtils.isNotBlank((String)group)) {
                where.append(" AND group_id=? ");
                paramList.add(group);
            }
            if (StringUtils.isNotBlank((String)appName)) {
                where.append(" AND app_name=? ");
                paramList.add(appName);
            }
        }
        try {
            return this.jt.query(SQL_FIND_ALL_CONFIG_INFO + where, paramList.toArray(), (RowMapper)RowMapperManager.CONFIG_ALL_INFO_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Map<String, Object> batchInsertOrUpdate(List<ConfigAllInfo> configInfoList, String srcUser, String srcIp, Map<String, Object> configAdvanceInfo, Timestamp time, boolean notify, SameConfigPolicy policy) throws NacosException {
        int succCount = 0;
        int skipCount = 0;
        ArrayList failData = null;
        ArrayList skipData = null;
        for (int i = 0; i < configInfoList.size(); ++i) {
            ConfigAllInfo configInfo = configInfoList.get(i);
            try {
                ParamUtils.checkParam(configInfo.getDataId(), configInfo.getGroup(), "datumId", configInfo.getContent());
            }
            catch (NacosException e) {
                LogUtil.DEFAULT_LOG.error("data verification failed", (Throwable)e);
                throw e;
            }
            ConfigInfo configInfo2Save = new ConfigInfo(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), configInfo.getAppName(), configInfo.getContent());
            String type = configInfo.getType();
            if (StringUtils.isBlank((CharSequence)type)) {
                if (configInfo.getDataId().contains(SPOT)) {
                    String extName = configInfo.getDataId().substring(configInfo.getDataId().lastIndexOf(SPOT) + 1);
                    FileTypeEnum fileTypeEnum = FileTypeEnum.getFileTypeEnumByFileExtensionOrFileType(extName);
                    type = fileTypeEnum.getFileType();
                } else {
                    type = FileTypeEnum.getFileTypeEnumByFileExtensionOrFileType(null).getFileType();
                }
            }
            if (configAdvanceInfo == null) {
                configAdvanceInfo = new HashMap<String, Object>(16);
            }
            configAdvanceInfo.put("type", type);
            configAdvanceInfo.put("desc", configInfo.getDesc());
            try {
                this.addConfigInfo(srcIp, srcUser, configInfo2Save, time, configAdvanceInfo, notify);
                ++succCount;
                continue;
            }
            catch (DataIntegrityViolationException ive) {
                if (SameConfigPolicy.ABORT.equals((Object)policy)) {
                    failData = new ArrayList();
                    skipData = new ArrayList();
                    HashMap<String, String> faileditem = new HashMap<String, String>(2);
                    faileditem.put("dataId", configInfo2Save.getDataId());
                    faileditem.put("group", configInfo2Save.getGroup());
                    failData.add(faileditem);
                    for (int j = i + 1; j < configInfoList.size(); ++j) {
                        ConfigInfo skipConfigInfo = configInfoList.get(j);
                        HashMap<String, String> skipitem = new HashMap<String, String>(2);
                        skipitem.put("dataId", skipConfigInfo.getDataId());
                        skipitem.put("group", skipConfigInfo.getGroup());
                        skipData.add(skipitem);
                    }
                    break;
                }
                if (SameConfigPolicy.SKIP.equals((Object)policy)) {
                    ++skipCount;
                    if (skipData == null) {
                        skipData = new ArrayList();
                    }
                    HashMap<String, String> skipitem = new HashMap<String, String>(2);
                    skipitem.put("dataId", configInfo2Save.getDataId());
                    skipitem.put("group", configInfo2Save.getGroup());
                    skipData.add(skipitem);
                    continue;
                }
                if (!SameConfigPolicy.OVERWRITE.equals((Object)policy)) continue;
                ++succCount;
                this.updateConfigInfo(configInfo2Save, srcIp, srcUser, time, configAdvanceInfo, notify);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        result.put("succCount", succCount);
        result.put("skipCount", skipCount);
        if (failData != null && !failData.isEmpty()) {
            result.put("failData", failData);
        }
        if (skipData != null && !skipData.isEmpty()) {
            result.put("skipData", skipData);
        }
        return result;
    }

    @Override
    public int tenantInfoCountByTenantId(String tenantId) {
        Assert.hasText((String)tenantId, (String)"tenantId can not be null");
        Integer result = (Integer)this.jt.queryForObject(SQL_TENANT_INFO_COUNT_BY_TENANT_ID, (Object[])new String[]{tenantId}, Integer.class);
        if (result == null) {
            return 0;
        }
        return result;
    }
}

