/*
 * Decompiled with CFR 0.152.
 */
package com.plumelog.core;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.plumelog.core.client.AbstractClient;
import com.plumelog.core.dto.RunLogCompressMessage;
import com.plumelog.core.exception.LogQueueConnectException;
import com.plumelog.core.util.GfJsonUtil;
import com.plumelog.core.util.HttpClient;
import com.plumelog.core.util.LZ4Util;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class MessageAppenderFactory {
    private static final Cache<String, Boolean> cache = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();
    public static BlockingQueue<String> rundataQueue;
    public static BlockingQueue<String> tracedataQueue;
    public static int queueSize;
    private static Boolean logOutPut;
    private static AtomicLong lastRunPushTime;
    private static AtomicLong lastTracePushTime;

    public static void initQueue(int logQueueSize) {
        queueSize = logQueueSize;
        if (rundataQueue == null) {
            rundataQueue = new LinkedBlockingQueue<String>(logQueueSize);
        }
        if (tracedataQueue == null) {
            tracedataQueue = new LinkedBlockingQueue<String>(logQueueSize);
        }
    }

    public static void pushRundataQueue(String message) {
        if (message != null && rundataQueue.size() < queueSize) {
            rundataQueue.add(message);
        }
    }

    public static void pushTracedataQueue(String message) {
        if (message != null && tracedataQueue.size() < queueSize) {
            tracedataQueue.add(message);
        }
    }

    public static void pushRundataQueue(String message, int size) {
        if (message != null) {
            rundataQueue.add(message);
        }
    }

    public static void pushTracedataQueue(String message, int size) {
        if (message != null) {
            tracedataQueue.add(message);
        }
    }

    public static void push(String key, List<String> baseLogMessage, AbstractClient client, String logOutPutKey, boolean compress) {
        logOutPut = (Boolean)cache.getIfPresent((Object)logOutPutKey);
        if (logOutPut == null || logOutPut.booleanValue()) {
            try {
                client.putMessageList(key, MessageAppenderFactory.compress(baseLogMessage, compress));
                cache.put((Object)logOutPutKey, (Object)true);
            }
            catch (LogQueueConnectException e) {
                cache.put((Object)logOutPutKey, (Object)false);
                System.out.println("plumelog error:----------------" + e.getMessage() + "-------------------");
            }
        }
    }

    private static void push(String plumelogHost, String key, List<String> baseLogMessage, String logOutPutKey) {
        if (baseLogMessage.size() == 0) {
            return;
        }
        ArrayList<Map> logs = new ArrayList<Map>();
        for (String str : baseLogMessage) {
            Map map = GfJsonUtil.parseObject(str, Map.class);
            logs.add(map);
        }
        logOutPut = (Boolean)cache.getIfPresent((Object)logOutPutKey);
        if (logOutPut == null || logOutPut.booleanValue()) {
            try {
                String url = "http://" + plumelogHost;
                String root = "";
                if (key.equals("plume_log_list")) {
                    root = "sendRunLog";
                }
                if (key.equals("plume_trace_list")) {
                    root = "sendTraceLog";
                }
                url = url + "/" + root;
                String param = GfJsonUtil.toJSONString(logs);
                HttpClient.doPostBody(url, param);
                cache.put((Object)logOutPutKey, (Object)true);
            }
            catch (Exception e) {
                cache.put((Object)logOutPutKey, (Object)false);
                System.out.println("plumelog error:----------------" + e.getMessage() + "-------------------");
            }
        }
    }

    private static List<String> compress(List<String> baseLogMessage, boolean compress) {
        if (!compress) {
            return baseLogMessage;
        }
        String text = GfJsonUtil.toJSONString(baseLogMessage);
        byte[] textByte = text.getBytes(StandardCharsets.UTF_8);
        byte[] compressedByte = LZ4Util.compressedByte(textByte);
        RunLogCompressMessage message = new RunLogCompressMessage();
        message.setBody(compressedByte);
        message.setLength(textByte.length);
        return Lists.newArrayList((Object[])new String[]{GfJsonUtil.toJSONString(message)});
    }

    public static void startRunLog(AbstractClient client, int maxCount) {
        MessageAppenderFactory.startRunLog(client, maxCount, "plume_log_list");
    }

    public static void startRunLog(AbstractClient client, int maxCount, String key) {
        MessageAppenderFactory.startRunLog(client, maxCount, key, false);
    }

    public static void startRunLog(AbstractClient client, int maxCount, String key, boolean compress) {
        while (true) {
            try {
                while (true) {
                    MessageAppenderFactory.doStartLog(client, maxCount, rundataQueue, key, "plume.log.ack", lastRunPushTime, compress);
                }
            }
            catch (Exception e) {
                String exMsg = e.getMessage();
                if (e instanceof InvocationTargetException && exMsg == null) {
                    exMsg = ((InvocationTargetException)e).getTargetException().getMessage();
                }
                System.out.println("plumelog error:--------doStartLog--------" + exMsg + "-------------------");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    public static void startRunLog(String plumelogHost, int maxCount, String key, boolean compress) {
        while (true) {
            try {
                while (true) {
                    MessageAppenderFactory.doStartLog(plumelogHost, maxCount, rundataQueue, key, "plume.log.ack", lastRunPushTime);
                }
            }
            catch (Exception e) {
                String exMsg = e.getMessage();
                if (e instanceof InvocationTargetException && exMsg == null) {
                    exMsg = ((InvocationTargetException)e).getTargetException().getMessage();
                }
                System.out.println("plumelog error:--------doStartLog--------" + exMsg + "-------------------");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    public static void startTraceLog(AbstractClient client, int maxCount) {
        MessageAppenderFactory.startTraceLog(client, maxCount, "plume_trace_list");
    }

    public static void startTraceLog(AbstractClient client, int maxCount, String key) {
        MessageAppenderFactory.startTraceLog(client, maxCount, key, false);
    }

    public static void startTraceLog(AbstractClient client, int maxCount, String key, boolean compress) {
        while (true) {
            try {
                while (true) {
                    MessageAppenderFactory.doStartLog(client, maxCount, tracedataQueue, key, "plume.log.ack", lastTracePushTime, compress);
                }
            }
            catch (Exception e) {
                String exMsg = e.getMessage();
                if (e instanceof InvocationTargetException && exMsg == null) {
                    exMsg = ((InvocationTargetException)e).getTargetException().getMessage();
                }
                System.out.println("plumelog error:--------doStartLog--------" + exMsg + "-------------------");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    public static void startTraceLog(String plumelogHost, int maxCount, String key, boolean compress) {
        while (true) {
            try {
                while (true) {
                    MessageAppenderFactory.doStartLog(plumelogHost, maxCount, tracedataQueue, key, "plume.log.ack", lastTracePushTime);
                }
            }
            catch (Exception e) {
                String exMsg = e.getMessage();
                if (e instanceof InvocationTargetException && exMsg == null) {
                    exMsg = ((InvocationTargetException)e).getTargetException().getMessage();
                }
                System.out.println("plumelog error:--------doStartLog--------" + exMsg + "-------------------");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    private static void doStartLog(AbstractClient client, int maxCount, BlockingQueue<String> queue, String key, String lock, AtomicLong pushTime, boolean compress) throws InterruptedException {
        ArrayList<String> logs = new ArrayList<String>();
        int size = queue.size();
        long currentTimeMillis = System.currentTimeMillis();
        long time = currentTimeMillis - pushTime.get();
        if (size >= maxCount || time > 500L) {
            queue.drainTo(logs, maxCount);
            MessageAppenderFactory.push(key, logs, client, lock, compress);
            pushTime.set(currentTimeMillis);
        } else if (size == 0) {
            String log = queue.take();
            logs.add(log);
            MessageAppenderFactory.push(key, logs, client, lock, compress);
            pushTime.set(currentTimeMillis);
        } else {
            Thread.sleep(100L);
        }
    }

    private static void doStartLog(String plumelogHost, int maxCount, BlockingQueue<String> queue, String key, String lock, AtomicLong pushTime) throws InterruptedException {
        ArrayList<String> logs = new ArrayList<String>();
        int size = queue.size();
        long currentTimeMillis = System.currentTimeMillis();
        long time = currentTimeMillis - pushTime.get();
        if (size >= maxCount || time > 500L) {
            queue.drainTo(logs, maxCount);
            MessageAppenderFactory.push(plumelogHost, key, logs, lock);
            pushTime.set(currentTimeMillis);
        } else if (size == 0) {
            String log = queue.take();
            logs.add(log);
            MessageAppenderFactory.push(plumelogHost, key, logs, lock);
            pushTime.set(currentTimeMillis);
        } else {
            Thread.sleep(100L);
        }
    }

    static {
        queueSize = 10000;
        logOutPut = true;
        lastRunPushTime = new AtomicLong(0L);
        lastTracePushTime = new AtomicLong(0L);
    }
}

