/*
 * Decompiled with CFR 0.152.
 */
package com.plumelog.core.kafka;

import java.util.Properties;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.StringDeserializer;

public class KafkaConsumerClient {
    private static volatile KafkaConsumerClient instance = null;
    private KafkaConsumer kafkaConsumer;

    private KafkaConsumerClient(String hosts, String groupName, int maxPullSize) {
        Properties props = new Properties();
        props.put("bootstrap.servers", hosts);
        props.put("max.poll.records", (Object)maxPullSize);
        props.put("key.deserializer", StringDeserializer.class);
        props.put("value.deserializer", StringDeserializer.class);
        props.put("group.id", groupName);
        this.kafkaConsumer = new KafkaConsumer(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KafkaConsumerClient getInstance(String hosts, String groupName, int maxPullSize) {
        if (instance != null) return instance;
        Class<KafkaConsumerClient> clazz = KafkaConsumerClient.class;
        synchronized (KafkaConsumerClient.class) {
            if (instance != null) return instance;
            instance = new KafkaConsumerClient(hosts, groupName, maxPullSize);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return instance;
        }
    }

    public KafkaConsumer getKafkaConsumer() {
        return this.kafkaConsumer;
    }
}

