/*
 * Decompiled with CFR 0.152.
 */
package com.plumelog.lite.client;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.plumelog.core.dto.RunLogCompressMessage;
import com.plumelog.core.dto.RunLogMessage;
import com.plumelog.core.dto.TraceLogMessage;
import com.plumelog.core.lucene.LuceneClient;
import com.plumelog.core.util.GfJsonUtil;
import com.plumelog.core.util.LZ4Util;
import com.plumelog.lite.client.IndexUtil;
import com.plumelog.lite.client.InitConfig;
import com.plumelog.lite.client.WebSocketSession;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.websocket.Session;

public class LogSave {
    private static final Cache<String, Boolean> cache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build();
    public static BlockingQueue<RunLogMessage> rundataQueue;
    public static BlockingQueue<TraceLogMessage> tracedataQueue;
    public static int queueSize;
    private static Boolean logOutPut;
    private static AtomicLong lastRunPushTime;
    private static AtomicLong lastTracePushTime;
    private static LuceneClient luceneClient;

    public static void init(int logQueueSize, String logPath) {
        queueSize = logQueueSize;
        if (rundataQueue == null) {
            rundataQueue = new LinkedBlockingQueue<RunLogMessage>(logQueueSize);
        }
        if (tracedataQueue == null) {
            tracedataQueue = new LinkedBlockingQueue<TraceLogMessage>(logQueueSize);
        }
        if (luceneClient == null) {
            luceneClient = new LuceneClient(logPath);
        }
        InitConfig.LITE_MODE_LOG_PATH = logPath;
    }

    public static void pushRundataQueue(RunLogMessage message) {
        if (message != null && rundataQueue.size() < queueSize) {
            rundataQueue.add(message);
        }
    }

    public static void pushTracedataQueue(TraceLogMessage message) {
        if (message != null && tracedataQueue.size() < queueSize) {
            tracedataQueue.add(message);
        }
    }

    private static void push(String key, List<RunLogMessage> baseLogMessage, String logOutPutKey) {
        if (baseLogMessage.size() == 0) {
            return;
        }
        logOutPut = (Boolean)cache.getIfPresent((Object)logOutPutKey);
        if (logOutPut == null || logOutPut.booleanValue()) {
            try {
                if (key.equals("plume_log_list")) {
                    luceneClient.insertListLog(baseLogMessage, LogSave.getRunLogIndex());
                }
                if (WebSocketSession.sessions.size() > 0) {
                    for (RunLogMessage runLogMessage : baseLogMessage) {
                        for (Session session : WebSocketSession.sessions) {
                            session.getBasicRemote().sendText(GfJsonUtil.toJSONString((Object)runLogMessage));
                        }
                    }
                }
                cache.put((Object)logOutPutKey, (Object)true);
            }
            catch (Exception e) {
                cache.put((Object)logOutPutKey, (Object)false);
                e.printStackTrace();
            }
        }
    }

    private static void pushTrace(String key, List<TraceLogMessage> baseLogMessage, String logOutPutKey) {
        if (baseLogMessage.size() == 0) {
            return;
        }
        logOutPut = (Boolean)cache.getIfPresent((Object)logOutPutKey);
        if (logOutPut == null || logOutPut.booleanValue()) {
            try {
                if (key.equals("plume_trace_list")) {
                    luceneClient.insertListTrace(baseLogMessage, LogSave.getTraceLogIndex());
                }
                cache.put((Object)logOutPutKey, (Object)true);
            }
            catch (Exception e) {
                cache.put((Object)logOutPutKey, (Object)false);
                e.printStackTrace();
            }
        }
    }

    private static List<String> compress(List<String> baseLogMessage, boolean compress) {
        if (!compress) {
            return baseLogMessage;
        }
        String text = GfJsonUtil.toJSONString(baseLogMessage);
        byte[] textByte = text.getBytes(StandardCharsets.UTF_8);
        byte[] compressedByte = LZ4Util.compressedByte((byte[])textByte);
        RunLogCompressMessage message = new RunLogCompressMessage();
        message.setBody(compressedByte);
        message.setLength(Integer.valueOf(textByte.length));
        return Lists.newArrayList((Object[])new String[]{GfJsonUtil.toJSONString((Object)message)});
    }

    public static void startRunLog(int maxCount, String key, boolean compress) {
        while (true) {
            try {
                while (true) {
                    LogSave.doStartLog(maxCount, rundataQueue, key, "plume.log.ack", lastRunPushTime);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    public static void startTraceLog(int maxCount, String key, boolean compress) {
        while (true) {
            try {
                while (true) {
                    LogSave.doStartLogTrace(maxCount, tracedataQueue, key, "plume.log.ack", lastTracePushTime);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    private static void doStartLog(int maxCount, BlockingQueue<RunLogMessage> queue, String key, String lock, AtomicLong pushTime) throws InterruptedException {
        ArrayList<RunLogMessage> logs = new ArrayList<RunLogMessage>();
        int size = queue.size();
        long currentTimeMillis = System.currentTimeMillis();
        long time = currentTimeMillis - pushTime.get();
        if (size >= maxCount || time > 500L) {
            queue.drainTo(logs, maxCount);
            LogSave.push(key, logs, lock);
            pushTime.set(currentTimeMillis);
        } else if (size == 0) {
            RunLogMessage log = queue.take();
            logs.add(log);
            LogSave.push(key, logs, lock);
            pushTime.set(currentTimeMillis);
        } else {
            Thread.sleep(100L);
        }
    }

    private static void doStartLogTrace(int maxCount, BlockingQueue<TraceLogMessage> queue, String key, String lock, AtomicLong pushTime) throws InterruptedException {
        ArrayList<TraceLogMessage> logs = new ArrayList<TraceLogMessage>();
        int size = queue.size();
        long currentTimeMillis = System.currentTimeMillis();
        long time = currentTimeMillis - pushTime.get();
        if (size >= maxCount || time > 500L) {
            queue.drainTo(logs, maxCount);
            LogSave.pushTrace(key, logs, lock);
            pushTime.set(currentTimeMillis);
        } else if (size == 0) {
            TraceLogMessage log = queue.take();
            logs.add(log);
            LogSave.pushTrace(key, logs, lock);
            pushTime.set(currentTimeMillis);
        } else {
            Thread.sleep(100L);
        }
    }

    private static String getRunLogIndex() {
        if ("day".equals(InitConfig.ES_INDEX_MODEL)) {
            return IndexUtil.getRunLogIndex(System.currentTimeMillis());
        }
        return IndexUtil.getRunLogIndexWithHour(System.currentTimeMillis());
    }

    private static String getTraceLogIndex() {
        if ("day".equals(InitConfig.ES_INDEX_MODEL)) {
            return IndexUtil.getTraceLogIndex(System.currentTimeMillis());
        }
        return IndexUtil.getTraceLogIndexWithHour(System.currentTimeMillis());
    }

    static {
        queueSize = 10000;
        logOutPut = true;
        lastRunPushTime = new AtomicLong(0L);
        lastTracePushTime = new AtomicLong(0L);
    }
}

