/*
 * Decompiled with CFR 0.152.
 */
package com.plumelog.lite.client;

import com.plumelog.core.util.GfJsonUtil;
import com.plumelog.lite.client.Filter;
import com.plumelog.lite.client.WebSocketSession;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.springframework.stereotype.Component;

@ServerEndpoint(value="/plumelog/websocket")
@Component(value="plumelogWebSocket")
public class WebSocket {
    @OnOpen
    public void onOpen(Session session) {
        WebSocketSession.sessions.add(session);
    }

    @OnClose
    public void onClose(Session session) {
        WebSocketSession.sessions.remove(session);
        WebSocketSession.sessionAppName.remove(session);
    }

    @OnMessage
    public void onMessage(String params, Session session) {
        Filter filter = (Filter)GfJsonUtil.parseObject((String)params, Filter.class);
        WebSocketSession.sessionAppName.put(session, filter);
    }

    @OnError
    public void onError(Session session, Throwable error) {
        WebSocketSession.sessions.remove(session);
        WebSocketSession.sessionAppName.remove(session);
    }
}

