/*
 * Decompiled with CFR 0.152.
 */
package com.plumelog.core.lucene;

import com.plumelog.core.client.AbstractServerClient;
import com.plumelog.core.dto.RunLogMessage;
import com.plumelog.core.dto.TraceLogMessage;
import com.plumelog.core.lucene.QueryRs;
import com.plumelog.core.util.GfJsonUtil;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.cn.smart.SmartChineseAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.GroupingSearch;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.SimpleSpanFragmenter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.NRTCachingDirectory;
import org.apache.lucene.util.BytesRef;

public class LuceneClient
extends AbstractServerClient {
    private String localpath;

    public LuceneClient(String rootPath) {
        this.localpath = rootPath + "/data/";
    }

    public void insertListTrace(List<TraceLogMessage> list, String baseIndex) throws Exception {
        this.create(this.loadTraceDocs(list), baseIndex);
    }

    public void insertListLog(List<RunLogMessage> list, String baseIndex) throws Exception {
        this.create(this.loadDocs(list), baseIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void create(Collection<Document> docs, String index) throws Exception {
        try (IndexWriter indexWriter = null;){
            FSDirectory directory = FSDirectory.open((Path)FileSystems.getDefault().getPath(this.localpath + index, new String[0]));
            NRTCachingDirectory nrtCachingDirectory = new NRTCachingDirectory((Directory)directory, 5.0, 60.0);
            SmartChineseAnalyzer smartChineseAnalyzer = new SmartChineseAnalyzer();
            IndexWriterConfig indexWriterConfig = new IndexWriterConfig((Analyzer)smartChineseAnalyzer);
            indexWriterConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            indexWriter = new IndexWriter((Directory)nrtCachingDirectory, indexWriterConfig);
            indexWriter.addDocuments(docs);
            indexWriter.forceMerge(1);
            indexWriter.commit();
        }
    }

    private Collection<Document> loadDocs(List<RunLogMessage> list) {
        ArrayList<Document> docs = new ArrayList<Document>();
        for (RunLogMessage rm : list) {
            Document document = new Document();
            document.add((IndexableField)new StringField("id", UUID.randomUUID().toString(), Field.Store.YES));
            document.add((IndexableField)new StringField("appName", rm.getAppName() == null ? "" : rm.getAppName(), Field.Store.YES));
            document.add((IndexableField)new SortedDocValuesField("appName", new BytesRef((CharSequence)(rm.getAppName() == null ? "" : rm.getAppName()))));
            document.add((IndexableField)new StringField("env", rm.getEnv() == null ? "" : rm.getEnv(), Field.Store.YES));
            document.add((IndexableField)new StringField("className", rm.getClassName() == null ? "" : rm.getClassName(), Field.Store.YES));
            document.add((IndexableField)new StringField("method", rm.getMethod() == null ? "" : rm.getMethod(), Field.Store.YES));
            document.add((IndexableField)new StringField("serverName", rm.getServerName() == null ? "" : rm.getServerName(), Field.Store.YES));
            document.add((IndexableField)new StringField("logLevel", rm.getLogLevel() == null ? "" : rm.getLogLevel(), Field.Store.YES));
            document.add((IndexableField)new SortedDocValuesField("logLevel", new BytesRef((CharSequence)(rm.getLogLevel() == null ? "" : rm.getLogLevel()))));
            document.add((IndexableField)new TextField("content", rm.getContent() == null ? "" : rm.getContent(), Field.Store.YES));
            document.add((IndexableField)new StringField("dateTime", rm.getDateTime() == null ? "" : rm.getDateTime(), Field.Store.YES));
            document.add((IndexableField)new NumericDocValuesField("dtTime", rm.getDtTime()));
            document.add((IndexableField)new StoredField("dtTime", rm.getDtTime().longValue()));
            document.add((IndexableField)new StringField("logType", rm.getLogType() == null ? "" : rm.getLogType(), Field.Store.YES));
            document.add((IndexableField)new StringField("appNameWithEnv", rm.getAppNameWithEnv() == null ? "" : rm.getAppNameWithEnv(), Field.Store.YES));
            document.add((IndexableField)new SortedDocValuesField("appNameWithEnv", new BytesRef((CharSequence)(rm.getAppNameWithEnv() == null ? "" : rm.getAppNameWithEnv()))));
            document.add((IndexableField)new StringField("traceId", rm.getTraceId() == null ? "" : rm.getTraceId(), Field.Store.YES));
            docs.add(document);
        }
        return docs;
    }

    private Collection<Document> loadTraceDocs(List<TraceLogMessage> list) {
        ArrayList<Document> docs = new ArrayList<Document>();
        for (TraceLogMessage rm : list) {
            Document document = new Document();
            document.add((IndexableField)new StringField("id", UUID.randomUUID().toString(), Field.Store.YES));
            document.add((IndexableField)new StringField("appName", rm.getAppName() == null ? "" : rm.getAppName(), Field.Store.YES));
            document.add((IndexableField)new SortedDocValuesField("appName", new BytesRef((CharSequence)(rm.getAppName() == null ? "" : rm.getAppName()))));
            document.add((IndexableField)new StringField("env", rm.getEnv() == null ? "" : rm.getEnv(), Field.Store.YES));
            document.add((IndexableField)new StringField("position", rm.getPosition() == null ? "" : rm.getPosition(), Field.Store.YES));
            document.add((IndexableField)new StringField("method", rm.getMethod() == null ? "" : rm.getMethod(), Field.Store.YES));
            document.add((IndexableField)new StringField("serverName", rm.getServerName() == null ? "" : rm.getServerName(), Field.Store.YES));
            document.add((IndexableField)new NumericDocValuesField("positionNum", rm.getPositionNum() == null ? 1L : (long)rm.getPositionNum().intValue()));
            document.add((IndexableField)new StoredField("positionNum", rm.getPositionNum() == null ? 1L : (long)rm.getPositionNum().intValue()));
            document.add((IndexableField)new NumericDocValuesField("time", rm.getTime()));
            document.add((IndexableField)new StoredField("time", rm.getTime().longValue()));
            document.add((IndexableField)new StringField("appNameWithEnv", rm.getAppNameWithEnv() == null ? "" : rm.getAppNameWithEnv(), Field.Store.YES));
            document.add((IndexableField)new SortedDocValuesField("appNameWithEnv", new BytesRef((CharSequence)(rm.getAppNameWithEnv() == null ? "" : rm.getAppNameWithEnv()))));
            document.add((IndexableField)new StringField("traceId", rm.getTraceId() == null ? "" : rm.getTraceId(), Field.Store.YES));
            docs.add(document);
        }
        return docs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteIndex(String index) throws IOException {
        try (IndexWriter indexWriter = null;){
            List<String> list = this.getIndex(index);
            for (String in : list) {
                FSDirectory directory = FSDirectory.open((Path)FileSystems.getDefault().getPath(this.localpath + in, new String[0]));
                StandardAnalyzer analyzer = new StandardAnalyzer();
                IndexWriterConfig config = new IndexWriterConfig((Analyzer)analyzer);
                indexWriter = new IndexWriter((Directory)directory, config);
                indexWriter.deleteAll();
            }
        }
        return true;
    }

    public String get(String url, String queryStr) throws Exception {
        return null;
    }

    private List<String> getIndex(String indexStr) {
        ArrayList<String> indexsList = new ArrayList<String>();
        String[] indexs = indexStr.split(",");
        for (int i = 0; i < indexs.length; ++i) {
            if (indexs[i].contains("*")) {
                File[] subs;
                File dir = new File(this.localpath);
                if (!dir.isDirectory()) continue;
                for (File sub : subs = dir.listFiles()) {
                    String name = sub.getName();
                    if (!Pattern.matches(indexs[i].replace("*", ".*"), name)) continue;
                    indexsList.add(name);
                }
                continue;
            }
            indexsList.add(indexs[i]);
        }
        return indexsList;
    }

    private String queryData(String indexStr, String queryStr, String from, String size) throws Exception {
        JSONObject queryJson = JSONObject.fromObject((Object)queryStr);
        if (queryJson.containsKey((Object)"query")) {
            int count;
            int min;
            int max;
            JSONArray query = queryJson.getJSONObject("query").getJSONObject("bool").getJSONArray("must");
            List<String> indexs = this.getIndex(indexStr);
            IndexReader[] indexReaders = new IndexReader[indexs.size()];
            for (int i = 0; i < indexs.size(); ++i) {
                FSDirectory directory = FSDirectory.open((Path)FileSystems.getDefault().getPath(this.localpath + indexs.get(i), new String[0]));
                DirectoryReader reader = DirectoryReader.open((Directory)directory);
                indexReaders[i] = reader;
            }
            MultiReader multiReader = new MultiReader(indexReaders);
            IndexSearcher searcher = new IndexSearcher((IndexReader)multiReader);
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            SmartChineseAnalyzer analyzer = new SmartChineseAnalyzer();
            this.buildQuery(query, builder, analyzer);
            Sort sort = new Sort();
            if (queryJson.containsKey((Object)"sort")) {
                this.buildSort(sort, queryJson);
            }
            if ((max = (min = Integer.parseInt(from)) + (count = Integer.parseInt(size))) == 0) {
                max = 10000;
            }
            TopFieldDocs topDocs = searcher.search((Query)builder.build(), max, sort);
            ScoreDoc[] scoreDocs = topDocs.scoreDocs;
            QueryRs qr = new QueryRs();
            qr.setTotal(topDocs.totalHits);
            ArrayList<Map<String, Object>> hits = new ArrayList<Map<String, Object>>();
            for (int i = min; i < scoreDocs.length; ++i) {
                ScoreDoc scoreDoc = scoreDocs[i];
                int docID = scoreDoc.doc;
                Document doc = multiReader.document(docID);
                HashMap<String, Object> hit = new HashMap<String, Object>();
                hit.put("_id", docID);
                hit.put("_source", this.mapCopy(doc));
                hit.put("highlight", this.highlighterMapCopy(doc, builder.build(), analyzer));
                hits.add(hit);
            }
            qr.setHits(hits);
            HashMap<String, Object> rs = new HashMap<String, Object>();
            rs.put("hits", qr);
            rs.put("timed_out", false);
            return JSONObject.fromObject(rs).toString();
        }
        return null;
    }

    private void buildQuery(JSONArray query, BooleanQuery.Builder builder, SmartChineseAnalyzer analyzer) throws ParseException {
        for (int a = 0; a < query.size(); ++a) {
            TermQuery termQuery;
            String matchValue;
            String matchKey;
            String[] matchSet;
            JSONObject js = query.getJSONObject(a);
            if (js.containsKey((Object)"match_phrase")) {
                matchSet = new String[1];
                js.getJSONObject("match_phrase").keySet().toArray(matchSet);
                matchKey = matchSet[0];
                matchValue = js.getJSONObject("match_phrase").getJSONObject(matchKey).getString("query");
                termQuery = new TermQuery(new Term(matchKey, matchValue));
                builder.add((Query)termQuery, BooleanClause.Occur.MUST);
            }
            if (js.containsKey((Object)"match")) {
                matchSet = new String[1];
                js.getJSONObject("match").keySet().toArray(matchSet);
                matchKey = matchSet[0];
                matchValue = js.getJSONObject("match").getJSONObject(matchKey).getString("query");
                termQuery = new TermQuery(new Term(matchKey, matchValue));
                builder.add((Query)termQuery, BooleanClause.Occur.MUST);
            }
            if (js.containsKey((Object)"query_string")) {
                String qStr = js.getJSONObject("query_string").getString("query");
                QueryParser parser = new QueryParser("content", (Analyzer)analyzer);
                Query content = parser.parse(qStr);
                builder.add(content, BooleanClause.Occur.MUST);
            }
            if (!js.containsKey((Object)"range")) continue;
            Long gte = js.getJSONObject("range").getJSONObject("dtTime").getLong("gte");
            Long lt = js.getJSONObject("range").getJSONObject("dtTime").getLong("lt");
            Query range = NumericDocValuesField.newSlowRangeQuery((String)"dtTime", (long)gte, (long)lt);
            builder.add(range, BooleanClause.Occur.MUST);
        }
        if (builder.build().clauses().isEmpty()) {
            builder.add((Query)new WildcardQuery(new Term("appName", "*")), BooleanClause.Occur.SHOULD);
        }
    }

    private void buildSort(Sort sort, JSONObject queryJson) {
        ArrayList<SortField> sortFieldList = new ArrayList<SortField>();
        JSONArray sortJsons = queryJson.getJSONArray("sort");
        for (int i = 0; i < sortJsons.size(); ++i) {
            JSONObject sortJson = sortJsons.getJSONObject(i);
            String[] keys = new String[sortJson.keySet().size()];
            sortJson.keySet().toArray(keys);
            for (int j = 0; j < keys.length; ++j) {
                String key = keys[j];
                String value = sortJson.getString(key);
                boolean reverse = true;
                if (value.equals("asc")) {
                    reverse = false;
                }
                sortFieldList.add(new SortField(key, SortField.Type.LONG, reverse));
            }
        }
        SortField[] sortFields = new SortField[sortFieldList.size()];
        sortFieldList.toArray(sortFields);
        sort.setSort(sortFields);
    }

    private Map<String, Object> highlighterMapCopy(Document paramsMap, BooleanQuery booleanQuery, SmartChineseAnalyzer analyzer) {
        QueryScorer scorer = new QueryScorer((Query)booleanQuery);
        SimpleSpanFragmenter fragmenter = new SimpleSpanFragmenter(scorer);
        SimpleHTMLFormatter simpleHTMLFormatter = new SimpleHTMLFormatter("<em>", "</em>");
        Highlighter highlighter = new Highlighter((Formatter)simpleHTMLFormatter, (Scorer)scorer);
        highlighter.setTextFragmenter((Fragmenter)fragmenter);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (IndexableField entry : paramsMap) {
            TokenStream tokenStream = analyzer.tokenStream(entry.name(), (Reader)new StringReader(entry.stringValue()));
            try {
                resultMap.put(entry.name(), highlighter.getBestFragments(tokenStream, entry.stringValue(), 10));
            }
            catch (Exception e) {
                resultMap.put(entry.name(), entry.stringValue());
            }
        }
        return resultMap;
    }

    public String get(String indexStr, String queryStr, String from, String size) throws Exception {
        JSONObject queryJson = JSONObject.fromObject((Object)queryStr);
        if (queryJson.containsKey((Object)"query")) {
            return this.queryData(indexStr, queryStr, from, size);
        }
        if (queryJson.containsKey((Object)"aggregations")) {
            return this.queryGroup(indexStr, queryStr);
        }
        return null;
    }

    private String queryGroup(String indexStr, String queryStr) throws Exception {
        JSONObject queryJson = JSONObject.fromObject((Object)queryStr);
        String fieldName = queryJson.getJSONObject("aggregations").getJSONObject("dataCount").getJSONObject("terms").getString("field");
        List<String> indexs = this.getIndex(indexStr);
        IndexReader[] indexReaders = new IndexReader[indexs.size()];
        for (int i = 0; i < indexs.size(); ++i) {
            FSDirectory directory = FSDirectory.open((Path)FileSystems.getDefault().getPath(this.localpath + indexs.get(i), new String[0]));
            DirectoryReader reader = DirectoryReader.open((Directory)directory);
            indexReaders[i] = reader;
        }
        MultiReader multiReader = new MultiReader(indexReaders);
        IndexSearcher searcher = new IndexSearcher((IndexReader)multiReader);
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        if (builder.build().clauses().isEmpty()) {
            builder.add((Query)new WildcardQuery(new Term("appName", "*")), BooleanClause.Occur.SHOULD);
        }
        GroupingSearch groupingSearch = new GroupingSearch(fieldName);
        groupingSearch.setGroupSort(new Sort(SortField.FIELD_SCORE));
        groupingSearch.setFillSortFields(true);
        groupingSearch.setCachingInMB(4.0, true);
        groupingSearch.setAllGroups(true);
        groupingSearch.setGroupDocsLimit(10000);
        TopGroups topDocs = groupingSearch.search(searcher, (Query)builder.build(), 0, 10000);
        ArrayList hits = new ArrayList();
        for (GroupDocs groupDocs : topDocs.groups) {
            String groupName = ((BytesRef)groupDocs.groupValue).utf8ToString();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("key", groupName);
            map.put("doc_count", groupDocs.totalHits);
            hits.add(map);
        }
        HashMap buckets = new HashMap();
        buckets.put("buckets", hits);
        HashMap dataCount = new HashMap();
        dataCount.put("dataCount", buckets);
        HashMap aggregations = new HashMap();
        aggregations.put("aggregations", dataCount);
        return JSONObject.fromObject(aggregations).toString();
    }

    public String group(String indexStr, String queryStr) throws Exception {
        return this.queryGroup(indexStr, queryStr);
    }

    private Map<String, Object> mapCopy(Document paramsMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (IndexableField entry : paramsMap) {
            resultMap.put(entry.name(), entry.stringValue());
        }
        return resultMap;
    }

    public String cat(String indexStr) {
        List<String> indexs = this.getIndex(indexStr);
        ArrayList infos = new ArrayList();
        try {
            for (String index : indexs) {
                long size = FileUtils.sizeOfDirectory((File)new File(this.localpath + index));
                String sizeStr = size + " bytes";
                if (size > 1024L && size <= 0x100000L) {
                    sizeStr = size / 1024L + " kb";
                }
                if (size > 0x100000L && size <= 0x40000000L) {
                    sizeStr = size / 0x100000L + " M";
                }
                if (size > 0x40000000L) {
                    sizeStr = size / 0x40000000L + " G";
                }
                FSDirectory directory = FSDirectory.open((Path)FileSystems.getDefault().getPath(this.localpath + index, new String[0]));
                NRTCachingDirectory nrtCachingDirectory = new NRTCachingDirectory((Directory)directory, 5.0, 60.0);
                DirectoryReader reader = DirectoryReader.open((Directory)nrtCachingDirectory);
                IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
                WildcardQuery query = new WildcardQuery(new Term("appName", "*"));
                TopDocs topDocs = searcher.search((Query)query, 100);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("health", "green");
                map.put("index", index);
                map.put("store.size", sizeStr);
                map.put("pri.store.size", sizeStr);
                map.put("docs.count", topDocs.totalHits);
                infos.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return GfJsonUtil.toJSONString(infos);
    }

    public void insertListLog(List<String> list, String baseIndex, String type) throws Exception {
    }

    public void insertListTrace(List<String> list, String baseIndex, String type) throws Exception {
    }

    public void insertListComm(List<String> list, String baseIndex, String type) throws Exception {
    }

    public boolean creatIndice(String indice, String type) {
        return true;
    }

    public boolean setMapping(String indice, String type) {
        return false;
    }

    public boolean creatIndiceTrace(String indice, String type) {
        return true;
    }

    public boolean existIndice(String indice) {
        return true;
    }

    public String getVersion() {
        return null;
    }

    public boolean creatIndiceNomal(String indice, String type) {
        return true;
    }

    public List<String> getExistIndices(String[] indices) {
        return Arrays.asList((Object[])indices.clone());
    }

    public void close() {
    }

    public boolean addShards(Long shardCount) {
        return false;
    }
}

