/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.processing;

import com.qiniu.processing.Operation;
import com.qiniu.storage.BucketManager;
import com.qiniu.util.StringMap;
import com.qiniu.util.StringUtils;
import com.qiniu.util.UrlSafeBase64;

public final class OperationFactory {
    private OperationFactory() {
    }

    public static Operation normal(String cmd, Object mode, StringMap args) {
        return new Normal(cmd, mode, args);
    }

    public static Operation normal(String cmd) {
        return OperationFactory.normal(cmd, null, null);
    }

    public static Operation saveAs(String bucket, String key) {
        return new Save(bucket, key);
    }

    public static Operation mkzip(StringMap args) {
        return new Mkzip(args);
    }

    private static class Mkzip
    implements Operation {
        private StringMap args;

        private Mkzip(StringMap args) {
            this.args = args;
        }

        public String toString() {
            final StringBuilder b = new StringBuilder("mkzip");
            this.args.iterate(new StringMap.Do(){

                public void deal(String key, Object value) {
                    b.append("/url/");
                    b.append(UrlSafeBase64.encodeToString(key));
                    String val = (String)value;
                    if (!StringUtils.isEmpty((String)val)) {
                        b.append("/alias/");
                        b.append(UrlSafeBase64.encodeToString(val));
                    }
                }
            });
            return b.toString();
        }

        public boolean onlyPersistent() {
            return true;
        }
    }

    private static class Save
    implements Operation {
        private String bucket;
        private String key;

        private Save(String bucket, String key) {
            this.bucket = bucket;
            this.key = key;
        }

        public String toString() {
            return "saveas/" + BucketManager.entry(this.bucket, this.key);
        }

        public boolean onlyPersistent() {
            return false;
        }
    }

    private static class Normal
    implements Operation {
        private String cmd;
        private Object mode;
        private StringMap args;

        private Normal(String cmd, Object mode, StringMap args) {
            this.cmd = cmd;
            this.mode = mode;
            this.args = args;
        }

        public String toString() {
            final StringBuilder b = new StringBuilder(this.cmd);
            if (this.mode != null) {
                b.append("/");
                b.append(this.mode);
            }
            if (this.args != null) {
                this.args.iterate(new StringMap.Do(){

                    public void deal(String key, Object value) {
                        b.append("/");
                        b.append(key);
                        b.append("/");
                        b.append(value);
                    }
                });
            }
            return b.toString();
        }

        public boolean onlyPersistent() {
            return false;
        }
    }
}

