/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.util;

import com.qiniu.util.UrlSafeBase64;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class Etag {
    private Etag() {
    }

    public static String data(byte[] data, int offset, int length) {
        try {
            return Etag.stream(new ByteArrayInputStream(data, offset, length), length);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static String data(byte[] data) {
        return Etag.data(data, 0, data.length);
    }

    public static String file(File file) throws IOException {
        FileInputStream fi = new FileInputStream(file);
        return Etag.stream(fi, file.length());
    }

    public static String file(String filePath) throws IOException {
        File f = new File(filePath);
        return Etag.file(f);
    }

    public static String stream(InputStream in, long len) throws IOException {
        if (len == 0L) {
            return "Fto5o-5ea0sNMlW_75VgGJCv2AcJ";
        }
        byte[] buffer = new byte[65536];
        byte[][] blocks = new byte[(int)(len + 0x400000L - 1L) / 0x400000][];
        for (int i = 0; i < blocks.length; ++i) {
            long left = len - 0x400000L * (long)i;
            long read = left > 0x400000L ? 0x400000L : left;
            blocks[i] = Etag.oneBlock(buffer, in, (int)read);
        }
        return Etag.resultEncode(blocks);
    }

    private static byte[] oneBlock(byte[] buffer, InputStream in, int len) throws IOException {
        MessageDigest sha1;
        try {
            sha1 = MessageDigest.getInstance("sha-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        int buffSize = buffer.length;
        while (len != 0) {
            int next = buffSize > len ? len : buffSize;
            in.read(buffer, 0, next);
            sha1.update(buffer, 0, next);
            len -= next;
        }
        return sha1.digest();
    }

    private static String resultEncode(byte[][] sha1s) {
        int head = 22;
        byte[] finalHash = sha1s[0];
        int len = finalHash.length;
        byte[] ret = new byte[len + 1];
        if (sha1s.length != 1) {
            MessageDigest sha1;
            head = -106;
            try {
                sha1 = MessageDigest.getInstance("sha-1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new AssertionError((Object)e);
            }
            for (byte[] s : sha1s) {
                sha1.update(s);
            }
            finalHash = sha1.digest();
        }
        ret[0] = head;
        System.arraycopy(finalHash, 0, ret, 1, len);
        return UrlSafeBase64.encodeToString(ret);
    }
}

