/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Command;
import com.rabbitmq.client.ConfirmListener;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.FlowListener;
import com.rabbitmq.client.GetResponse;
import com.rabbitmq.client.MessageProperties;
import com.rabbitmq.client.Method;
import com.rabbitmq.client.ReturnListener;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.UnexpectedMethodError;
import com.rabbitmq.client.impl.AMQChannel;
import com.rabbitmq.client.impl.AMQCommand;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.AMQImpl;
import com.rabbitmq.client.impl.ConsumerDispatcher;
import com.rabbitmq.client.impl.ConsumerWorkService;
import com.rabbitmq.utility.Utility;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelN
extends AMQChannel
implements Channel {
    private static final String UNSPECIFIED_OUT_OF_BAND = "";
    private final Map<String, Consumer> _consumers = Collections.synchronizedMap(new HashMap());
    private final Collection<ReturnListener> returnListeners = new CopyOnWriteArrayList<ReturnListener>();
    private final Collection<FlowListener> flowListeners = new CopyOnWriteArrayList<FlowListener>();
    private final Collection<ConfirmListener> confirmListeners = new CopyOnWriteArrayList<ConfirmListener>();
    private long nextPublishSeqNo = 0L;
    private volatile Consumer defaultConsumer = null;
    private final ConsumerDispatcher dispatcher;
    private volatile CountDownLatch finishedShutdownFlag = null;
    private volatile SortedSet<Long> unconfirmedSet = Collections.synchronizedSortedSet(new TreeSet());
    private volatile boolean onlyAcksReceived = true;

    public ChannelN(AMQConnection connection, int channelNumber, ConsumerWorkService workService) {
        super(connection, channelNumber);
        this.dispatcher = new ConsumerDispatcher(connection, this, workService);
    }

    public void open() throws IOException {
        this.exnWrappingRpc(new AMQImpl.Channel.Open(UNSPECIFIED_OUT_OF_BAND));
    }

    @Override
    public void addReturnListener(ReturnListener listener) {
        this.returnListeners.add(listener);
    }

    @Override
    public boolean removeReturnListener(ReturnListener listener) {
        return this.returnListeners.remove(listener);
    }

    @Override
    public void clearReturnListeners() {
        this.returnListeners.clear();
    }

    @Override
    public void addFlowListener(FlowListener listener) {
        this.flowListeners.add(listener);
    }

    @Override
    public boolean removeFlowListener(FlowListener listener) {
        return this.flowListeners.remove(listener);
    }

    @Override
    public void clearFlowListeners() {
        this.flowListeners.clear();
    }

    @Override
    public void addConfirmListener(ConfirmListener listener) {
        this.confirmListeners.add(listener);
    }

    @Override
    public boolean removeConfirmListener(ConfirmListener listener) {
        return this.confirmListeners.remove(listener);
    }

    @Override
    public void clearConfirmListeners() {
        this.confirmListeners.clear();
    }

    @Override
    public boolean waitForConfirms() throws InterruptedException {
        boolean confirms = false;
        try {
            confirms = this.waitForConfirms(0L);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        return confirms;
    }

    @Override
    public boolean waitForConfirms(long timeout) throws InterruptedException, TimeoutException {
        long startTime = System.currentTimeMillis();
        SortedSet<Long> sortedSet = this.unconfirmedSet;
        synchronized (sortedSet) {
            while (true) {
                if (this.getCloseReason() != null) {
                    throw Utility.fixStackTrace(this.getCloseReason());
                }
                if (this.unconfirmedSet.isEmpty()) {
                    boolean aux = this.onlyAcksReceived;
                    this.onlyAcksReceived = true;
                    return aux;
                }
                if (timeout == 0L) {
                    this.unconfirmedSet.wait();
                    continue;
                }
                long elapsed = System.currentTimeMillis() - startTime;
                if (timeout <= elapsed) break;
                this.unconfirmedSet.wait(timeout - elapsed);
            }
            throw new TimeoutException();
        }
    }

    @Override
    public void waitForConfirmsOrDie() throws IOException, InterruptedException {
        try {
            this.waitForConfirmsOrDie(0L);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    @Override
    public void waitForConfirmsOrDie(long timeout) throws IOException, InterruptedException, TimeoutException {
        try {
            if (!this.waitForConfirms(timeout)) {
                this.close(200, "NACKS RECEIVED", true, null, false);
                throw new IOException("nacks received");
            }
        }
        catch (TimeoutException e) {
            this.close(406, "TIMEOUT WAITING FOR ACK");
            throw e;
        }
    }

    @Override
    public Consumer getDefaultConsumer() {
        return this.defaultConsumer;
    }

    @Override
    public void setDefaultConsumer(Consumer consumer) {
        this.defaultConsumer = consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastShutdownSignal(ShutdownSignalException signal) {
        HashMap<String, Consumer> snapshotConsumers;
        Map<String, Consumer> map = this._consumers;
        synchronized (map) {
            snapshotConsumers = new HashMap<String, Consumer>(this._consumers);
        }
        this.finishedShutdownFlag = this.dispatcher.handleShutdownSignal(snapshotConsumers, signal);
    }

    private void startProcessShutdownSignal(ShutdownSignalException signal, boolean ignoreClosed, boolean notifyRpc) {
        super.processShutdownSignal(signal, ignoreClosed, notifyRpc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishProcessShutdownSignal() {
        this.dispatcher.quiesce();
        this.broadcastShutdownSignal(this.getCloseReason());
        SortedSet<Long> sortedSet = this.unconfirmedSet;
        synchronized (sortedSet) {
            this.unconfirmedSet.notifyAll();
        }
    }

    @Override
    public void processShutdownSignal(ShutdownSignalException signal, boolean ignoreClosed, boolean notifyRpc) {
        this.startProcessShutdownSignal(signal, ignoreClosed, notifyRpc);
        this.finishProcessShutdownSignal();
    }

    CountDownLatch getShutdownLatch() {
        return this.finishedShutdownFlag;
    }

    private void releaseChannel() {
        ((AMQConnection)this.getConnection()).disconnectChannel(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processAsync(Command command) throws IOException {
        Method method = command.getMethod();
        if (method instanceof AMQImpl.Channel.Close) {
            this.asyncShutdown(command);
            return true;
        }
        if (this.isOpen()) {
            if (method instanceof AMQImpl.Basic.Deliver) {
                AMQImpl.Basic.Deliver m = (AMQImpl.Basic.Deliver)method;
                Consumer callback = this._consumers.get(m.getConsumerTag());
                if (callback == null) {
                    if (this.defaultConsumer == null) {
                        throw new IllegalStateException("Unsolicited delivery - see Channel.setDefaultConsumer to handle this case.");
                    }
                    callback = this.defaultConsumer;
                }
                Envelope envelope = new Envelope(m.getDeliveryTag(), m.getRedelivered(), m.getExchange(), m.getRoutingKey());
                try {
                    this.dispatcher.handleDelivery(callback, m.getConsumerTag(), envelope, (AMQP.BasicProperties)command.getContentHeader(), command.getContentBody());
                }
                catch (Throwable ex) {
                    ((AMQConnection)this.getConnection()).getExceptionHandler().handleConsumerException(this, ex, callback, m.getConsumerTag(), "handleDelivery");
                }
                return true;
            }
            if (method instanceof AMQImpl.Basic.Return) {
                this.callReturnListeners(command, (AMQImpl.Basic.Return)method);
                return true;
            }
            if (method instanceof AMQImpl.Channel.Flow) {
                AMQImpl.Channel.Flow channelFlow = (AMQImpl.Channel.Flow)method;
                Object callback = this._channelMutex;
                synchronized (callback) {
                    this._blockContent = !channelFlow.getActive();
                    this.transmit(new AMQImpl.Channel.FlowOk(!this._blockContent));
                    this._channelMutex.notifyAll();
                }
                this.callFlowListeners(command, channelFlow);
                return true;
            }
            if (method instanceof AMQImpl.Basic.Ack) {
                AMQImpl.Basic.Ack ack = (AMQImpl.Basic.Ack)method;
                this.callConfirmListeners(command, ack);
                this.handleAckNack(ack.getDeliveryTag(), ack.getMultiple(), false);
                return true;
            }
            if (method instanceof AMQImpl.Basic.Nack) {
                AMQImpl.Basic.Nack nack = (AMQImpl.Basic.Nack)method;
                this.callConfirmListeners(command, nack);
                this.handleAckNack(nack.getDeliveryTag(), nack.getMultiple(), true);
                return true;
            }
            if (method instanceof AMQImpl.Basic.RecoverOk) {
                for (Map.Entry<String, Consumer> entry : this._consumers.entrySet()) {
                    this.dispatcher.handleRecoverOk(entry.getValue(), entry.getKey());
                }
                return false;
            }
            if (method instanceof AMQImpl.Basic.Cancel) {
                AMQImpl.Basic.Cancel m = (AMQImpl.Basic.Cancel)method;
                String consumerTag = m.getConsumerTag();
                Consumer callback = this._consumers.remove(consumerTag);
                if (callback == null) {
                    callback = this.defaultConsumer;
                }
                if (callback != null) {
                    try {
                        callback.handleCancel(consumerTag);
                    }
                    catch (Throwable ex) {
                        ((AMQConnection)this.getConnection()).getExceptionHandler().handleConsumerException(this, ex, callback, consumerTag, "handleCancel");
                    }
                }
                return true;
            }
            return false;
        }
        return !(method instanceof AMQImpl.Channel.CloseOk);
    }

    private void callReturnListeners(Command command, AMQImpl.Basic.Return basicReturn) {
        try {
            for (ReturnListener l : this.returnListeners) {
                l.handleReturn(basicReturn.getReplyCode(), basicReturn.getReplyText(), basicReturn.getExchange(), basicReturn.getRoutingKey(), (AMQP.BasicProperties)command.getContentHeader(), command.getContentBody());
            }
        }
        catch (Throwable ex) {
            ((AMQConnection)this.getConnection()).getExceptionHandler().handleReturnListenerException(this, ex);
        }
    }

    private void callFlowListeners(Command command, AMQImpl.Channel.Flow channelFlow) {
        try {
            for (FlowListener l : this.flowListeners) {
                l.handleFlow(channelFlow.getActive());
            }
        }
        catch (Throwable ex) {
            ((AMQConnection)this.getConnection()).getExceptionHandler().handleFlowListenerException(this, ex);
        }
    }

    private void callConfirmListeners(Command command, AMQImpl.Basic.Ack ack) {
        try {
            for (ConfirmListener l : this.confirmListeners) {
                l.handleAck(ack.getDeliveryTag(), ack.getMultiple());
            }
        }
        catch (Throwable ex) {
            ((AMQConnection)this.getConnection()).getExceptionHandler().handleConfirmListenerException(this, ex);
        }
    }

    private void callConfirmListeners(Command command, AMQImpl.Basic.Nack nack) {
        try {
            for (ConfirmListener l : this.confirmListeners) {
                l.handleNack(nack.getDeliveryTag(), nack.getMultiple());
            }
        }
        catch (Throwable ex) {
            ((AMQConnection)this.getConnection()).getExceptionHandler().handleConfirmListenerException(this, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncShutdown(Command command) throws IOException {
        this.releaseChannel();
        ShutdownSignalException signal = new ShutdownSignalException(false, false, command, this);
        Object object = this._channelMutex;
        synchronized (object) {
            try {
                this.processShutdownSignal(signal, true, false);
                this.quiescingTransmit(new AMQImpl.Channel.CloseOk());
            }
            finally {
                this.notifyOutstandingRpc(signal);
            }
        }
        this.notifyListeners();
    }

    @Override
    public void close() throws IOException {
        this.close(200, "OK");
    }

    @Override
    public void close(int closeCode, String closeMessage) throws IOException {
        this.close(closeCode, closeMessage, true, null, false);
    }

    @Override
    public void abort() throws IOException {
        this.abort(200, "OK");
    }

    @Override
    public void abort(int closeCode, String closeMessage) throws IOException {
        this.close(closeCode, closeMessage, true, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(int closeCode, String closeMessage, boolean initiatedByApplication, Throwable cause, boolean abort) throws IOException {
        AMQImpl.Channel.Close reason = new AMQImpl.Channel.Close(closeCode, closeMessage, 0, 0);
        ShutdownSignalException signal = new ShutdownSignalException(false, initiatedByApplication, reason, this);
        if (cause != null) {
            signal.initCause(cause);
        }
        AMQChannel.BlockingRpcContinuation<AMQCommand> k = new AMQChannel.BlockingRpcContinuation<AMQCommand>(){

            @Override
            public AMQCommand transformReply(AMQCommand command) {
                ChannelN.this.finishProcessShutdownSignal();
                return command;
            }
        };
        boolean notify = false;
        try {
            Object object = this._channelMutex;
            synchronized (object) {
                this.startProcessShutdownSignal(signal, !initiatedByApplication, true);
                this.quiescingRpc(reason, k);
            }
            notify = true;
            k.getReply(-1);
        }
        catch (TimeoutException ise) {
        }
        catch (ShutdownSignalException sse) {
            if (!abort) {
                throw sse;
            }
        }
        catch (IOException ioe) {
            if (!abort) {
                throw ioe;
            }
        }
        finally {
            if (abort || notify) {
                this.releaseChannel();
                this.notifyListeners();
            }
        }
    }

    @Override
    public void basicQos(int prefetchSize, int prefetchCount, boolean global) throws IOException {
        this.exnWrappingRpc(new AMQImpl.Basic.Qos(prefetchSize, prefetchCount, global));
    }

    @Override
    public void basicQos(int prefetchCount) throws IOException {
        this.basicQos(0, prefetchCount, false);
    }

    @Override
    public void basicPublish(String exchange, String routingKey, AMQP.BasicProperties props, byte[] body) throws IOException {
        this.basicPublish(exchange, routingKey, false, props, body);
    }

    @Override
    public void basicPublish(String exchange, String routingKey, boolean mandatory, AMQP.BasicProperties props, byte[] body) throws IOException {
        this.basicPublish(exchange, routingKey, mandatory, false, props, body);
    }

    @Override
    public void basicPublish(String exchange, String routingKey, boolean mandatory, boolean immediate, AMQP.BasicProperties props, byte[] body) throws IOException {
        if (this.nextPublishSeqNo > 0L) {
            this.unconfirmedSet.add(this.getNextPublishSeqNo());
            ++this.nextPublishSeqNo;
        }
        AMQP.BasicProperties useProps = props;
        if (props == null) {
            useProps = MessageProperties.MINIMAL_BASIC;
        }
        this.transmit(new AMQCommand(new AMQP.Basic.Publish.Builder().exchange(exchange).routingKey(routingKey).mandatory(mandatory).immediate(immediate).build(), useProps, body));
    }

    @Override
    public AMQImpl.Exchange.DeclareOk exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, Map<String, Object> arguments) throws IOException {
        return this.exchangeDeclare(exchange, type, durable, autoDelete, false, (Map)arguments);
    }

    @Override
    public AMQImpl.Exchange.DeclareOk exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, boolean internal, Map<String, Object> arguments) throws IOException {
        return (AMQImpl.Exchange.DeclareOk)this.exnWrappingRpc(new AMQP.Exchange.Declare.Builder().exchange(exchange).type(type).durable(durable).autoDelete(autoDelete).internal(internal).arguments(arguments).build()).getMethod();
    }

    @Override
    public AMQImpl.Exchange.DeclareOk exchangeDeclare(String exchange, String type, boolean durable) throws IOException {
        return this.exchangeDeclare(exchange, type, durable, false, (Map)null);
    }

    @Override
    public AMQImpl.Exchange.DeclareOk exchangeDeclare(String exchange, String type) throws IOException {
        return this.exchangeDeclare(exchange, type, false, false, (Map)null);
    }

    @Override
    public AMQImpl.Exchange.DeclareOk exchangeDeclarePassive(String exchange) throws IOException {
        return (AMQImpl.Exchange.DeclareOk)this.exnWrappingRpc(new AMQP.Exchange.Declare.Builder().exchange(exchange).type(UNSPECIFIED_OUT_OF_BAND).passive().build()).getMethod();
    }

    @Override
    public AMQImpl.Exchange.DeleteOk exchangeDelete(String exchange, boolean ifUnused) throws IOException {
        return (AMQImpl.Exchange.DeleteOk)this.exnWrappingRpc(new AMQP.Exchange.Delete.Builder().exchange(exchange).ifUnused(ifUnused).build()).getMethod();
    }

    @Override
    public AMQImpl.Exchange.DeleteOk exchangeDelete(String exchange) throws IOException {
        return this.exchangeDelete(exchange, false);
    }

    @Override
    public AMQImpl.Exchange.BindOk exchangeBind(String destination, String source, String routingKey, Map<String, Object> arguments) throws IOException {
        return (AMQImpl.Exchange.BindOk)this.exnWrappingRpc(new AMQP.Exchange.Bind.Builder().destination(destination).source(source).routingKey(routingKey).arguments(arguments).build()).getMethod();
    }

    @Override
    public AMQImpl.Exchange.BindOk exchangeBind(String destination, String source, String routingKey) throws IOException {
        return this.exchangeBind(destination, source, routingKey, (Map)null);
    }

    @Override
    public AMQImpl.Exchange.UnbindOk exchangeUnbind(String destination, String source, String routingKey, Map<String, Object> arguments) throws IOException {
        return (AMQImpl.Exchange.UnbindOk)this.exnWrappingRpc(new AMQP.Exchange.Unbind.Builder().destination(destination).source(source).routingKey(routingKey).arguments(arguments).build()).getMethod();
    }

    @Override
    public AMQImpl.Exchange.UnbindOk exchangeUnbind(String destination, String source, String routingKey) throws IOException {
        return this.exchangeUnbind(destination, source, routingKey, (Map)null);
    }

    @Override
    public AMQImpl.Queue.DeclareOk queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, Map<String, Object> arguments) throws IOException {
        return (AMQImpl.Queue.DeclareOk)this.exnWrappingRpc(new AMQP.Queue.Declare.Builder().queue(queue).durable(durable).exclusive(exclusive).autoDelete(autoDelete).arguments(arguments).build()).getMethod();
    }

    @Override
    public AMQP.Queue.DeclareOk queueDeclare() throws IOException {
        return this.queueDeclare(UNSPECIFIED_OUT_OF_BAND, false, true, true, (Map)null);
    }

    @Override
    public AMQImpl.Queue.DeclareOk queueDeclarePassive(String queue) throws IOException {
        return (AMQImpl.Queue.DeclareOk)this.exnWrappingRpc(new AMQP.Queue.Declare.Builder().queue(queue).passive().exclusive().autoDelete().build()).getMethod();
    }

    @Override
    public AMQImpl.Queue.DeleteOk queueDelete(String queue, boolean ifUnused, boolean ifEmpty) throws IOException {
        return (AMQImpl.Queue.DeleteOk)this.exnWrappingRpc(new AMQP.Queue.Delete.Builder().queue(queue).ifUnused(ifUnused).ifEmpty(ifEmpty).build()).getMethod();
    }

    @Override
    public AMQImpl.Queue.DeleteOk queueDelete(String queue) throws IOException {
        return this.queueDelete(queue, false, false);
    }

    @Override
    public AMQImpl.Queue.BindOk queueBind(String queue, String exchange, String routingKey, Map<String, Object> arguments) throws IOException {
        return (AMQImpl.Queue.BindOk)this.exnWrappingRpc(new AMQP.Queue.Bind.Builder().queue(queue).exchange(exchange).routingKey(routingKey).arguments(arguments).build()).getMethod();
    }

    @Override
    public AMQImpl.Queue.BindOk queueBind(String queue, String exchange, String routingKey) throws IOException {
        return this.queueBind(queue, exchange, routingKey, (Map)null);
    }

    @Override
    public AMQImpl.Queue.UnbindOk queueUnbind(String queue, String exchange, String routingKey, Map<String, Object> arguments) throws IOException {
        return (AMQImpl.Queue.UnbindOk)this.exnWrappingRpc(new AMQP.Queue.Unbind.Builder().queue(queue).exchange(exchange).routingKey(routingKey).arguments(arguments).build()).getMethod();
    }

    @Override
    public AMQImpl.Queue.PurgeOk queuePurge(String queue) throws IOException {
        return (AMQImpl.Queue.PurgeOk)this.exnWrappingRpc(new AMQP.Queue.Purge.Builder().queue(queue).build()).getMethod();
    }

    @Override
    public AMQImpl.Queue.UnbindOk queueUnbind(String queue, String exchange, String routingKey) throws IOException {
        return this.queueUnbind(queue, exchange, routingKey, (Map)null);
    }

    @Override
    public GetResponse basicGet(String queue, boolean autoAck) throws IOException {
        AMQCommand replyCommand = this.exnWrappingRpc(new AMQP.Basic.Get.Builder().queue(queue).noAck(autoAck).build());
        com.rabbitmq.client.impl.Method method = replyCommand.getMethod();
        if (method instanceof AMQImpl.Basic.GetOk) {
            AMQImpl.Basic.GetOk getOk = (AMQImpl.Basic.GetOk)method;
            Envelope envelope = new Envelope(getOk.getDeliveryTag(), getOk.getRedelivered(), getOk.getExchange(), getOk.getRoutingKey());
            AMQP.BasicProperties props = (AMQP.BasicProperties)replyCommand.getContentHeader();
            byte[] body = replyCommand.getContentBody();
            int messageCount = getOk.getMessageCount();
            return new GetResponse(envelope, props, body, messageCount);
        }
        if (method instanceof AMQImpl.Basic.GetEmpty) {
            return null;
        }
        throw new UnexpectedMethodError(method);
    }

    @Override
    public void basicAck(long deliveryTag, boolean multiple) throws IOException {
        this.transmit(new AMQImpl.Basic.Ack(deliveryTag, multiple));
    }

    @Override
    public void basicNack(long deliveryTag, boolean multiple, boolean requeue) throws IOException {
        this.transmit(new AMQImpl.Basic.Nack(deliveryTag, multiple, requeue));
    }

    @Override
    public void basicReject(long deliveryTag, boolean requeue) throws IOException {
        this.transmit(new AMQImpl.Basic.Reject(deliveryTag, requeue));
    }

    @Override
    public String basicConsume(String queue, Consumer callback) throws IOException {
        return this.basicConsume(queue, false, callback);
    }

    @Override
    public String basicConsume(String queue, boolean autoAck, Consumer callback) throws IOException {
        return this.basicConsume(queue, autoAck, UNSPECIFIED_OUT_OF_BAND, callback);
    }

    @Override
    public String basicConsume(String queue, boolean autoAck, String consumerTag, Consumer callback) throws IOException {
        return this.basicConsume(queue, autoAck, consumerTag, false, false, null, callback);
    }

    @Override
    public String basicConsume(String queue, boolean autoAck, String consumerTag, boolean noLocal, boolean exclusive, Map<String, Object> arguments, final Consumer callback) throws IOException {
        AMQChannel.BlockingRpcContinuation<String> k = new AMQChannel.BlockingRpcContinuation<String>(){

            @Override
            public String transformReply(AMQCommand replyCommand) {
                String actualConsumerTag = ((AMQImpl.Basic.ConsumeOk)replyCommand.getMethod()).getConsumerTag();
                ChannelN.this._consumers.put(actualConsumerTag, callback);
                ChannelN.this.dispatcher.handleConsumeOk(callback, actualConsumerTag);
                return actualConsumerTag;
            }
        };
        this.rpc(new AMQP.Basic.Consume.Builder().queue(queue).consumerTag(consumerTag).noLocal(noLocal).noAck(autoAck).exclusive(exclusive).arguments(arguments).build(), k);
        try {
            return (String)k.getReply();
        }
        catch (ShutdownSignalException ex) {
            throw ChannelN.wrap(ex);
        }
    }

    @Override
    public void basicCancel(final String consumerTag) throws IOException {
        final Consumer originalConsumer = this._consumers.get(consumerTag);
        if (originalConsumer == null) {
            throw new IOException("Unknown consumerTag");
        }
        AMQChannel.BlockingRpcContinuation<Consumer> k = new AMQChannel.BlockingRpcContinuation<Consumer>(){

            @Override
            public Consumer transformReply(AMQCommand replyCommand) {
                replyCommand.getMethod();
                ChannelN.this._consumers.remove(consumerTag);
                ChannelN.this.dispatcher.handleCancelOk(originalConsumer, consumerTag);
                return originalConsumer;
            }
        };
        this.rpc(new AMQImpl.Basic.Cancel(consumerTag, false), k);
        try {
            k.getReply();
        }
        catch (ShutdownSignalException ex) {
            throw ChannelN.wrap(ex);
        }
    }

    @Override
    public AMQImpl.Basic.RecoverOk basicRecover() throws IOException {
        return this.basicRecover(true);
    }

    @Override
    public AMQImpl.Basic.RecoverOk basicRecover(boolean requeue) throws IOException {
        return (AMQImpl.Basic.RecoverOk)this.exnWrappingRpc(new AMQImpl.Basic.Recover(requeue)).getMethod();
    }

    @Override
    public void basicRecoverAsync(boolean requeue) throws IOException {
        this.transmit(new AMQImpl.Basic.RecoverAsync(requeue));
    }

    @Override
    public AMQImpl.Tx.SelectOk txSelect() throws IOException {
        return (AMQImpl.Tx.SelectOk)this.exnWrappingRpc(new AMQImpl.Tx.Select()).getMethod();
    }

    @Override
    public AMQImpl.Tx.CommitOk txCommit() throws IOException {
        return (AMQImpl.Tx.CommitOk)this.exnWrappingRpc(new AMQImpl.Tx.Commit()).getMethod();
    }

    @Override
    public AMQImpl.Tx.RollbackOk txRollback() throws IOException {
        return (AMQImpl.Tx.RollbackOk)this.exnWrappingRpc(new AMQImpl.Tx.Rollback()).getMethod();
    }

    @Override
    public AMQImpl.Confirm.SelectOk confirmSelect() throws IOException {
        if (this.nextPublishSeqNo == 0L) {
            this.nextPublishSeqNo = 1L;
        }
        return (AMQImpl.Confirm.SelectOk)this.exnWrappingRpc(new AMQImpl.Confirm.Select(false)).getMethod();
    }

    @Override
    public AMQImpl.Channel.FlowOk flow(boolean a) throws IOException {
        return (AMQImpl.Channel.FlowOk)this.exnWrappingRpc(new AMQImpl.Channel.Flow(a)).getMethod();
    }

    @Override
    public AMQImpl.Channel.FlowOk getFlow() {
        return new AMQImpl.Channel.FlowOk(!this._blockContent);
    }

    @Override
    public long getNextPublishSeqNo() {
        return this.nextPublishSeqNo;
    }

    @Override
    public void asyncRpc(Method method) throws IOException {
        this.transmit(method);
    }

    @Override
    public AMQCommand rpc(Method method) throws IOException {
        return this.exnWrappingRpc(method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAckNack(long seqNo, boolean multiple, boolean nack) {
        if (multiple) {
            this.unconfirmedSet.headSet(seqNo + 1L).clear();
        } else {
            this.unconfirmedSet.remove(seqNo);
        }
        SortedSet<Long> sortedSet = this.unconfirmedSet;
        synchronized (sortedSet) {
            boolean bl = this.onlyAcksReceived = this.onlyAcksReceived && !nack;
            if (this.unconfirmedSet.isEmpty()) {
                this.unconfirmedSet.notifyAll();
            }
        }
    }
}

