/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.RpcServer;
import com.rabbitmq.client.impl.MethodArgumentReader;
import com.rabbitmq.client.impl.MethodArgumentWriter;
import com.rabbitmq.client.impl.ValueReader;
import com.rabbitmq.client.impl.ValueWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapRpcServer
extends RpcServer {
    public MapRpcServer(Channel channel) throws IOException {
        super(channel);
    }

    public MapRpcServer(Channel channel, String queueName) throws IOException {
        super(channel, queueName);
    }

    @Override
    public byte[] handleCall(byte[] requestBody, AMQP.BasicProperties replyProperties) {
        try {
            return MapRpcServer.encode(this.handleMapCall(MapRpcServer.decode(requestBody), replyProperties));
        }
        catch (IOException ioe) {
            return new byte[0];
        }
    }

    public static Map<String, Object> decode(byte[] requestBody) throws IOException {
        MethodArgumentReader reader = new MethodArgumentReader(new ValueReader(new DataInputStream(new ByteArrayInputStream(requestBody))));
        Map<String, Object> request = reader.readTable();
        return request;
    }

    public static byte[] encode(Map<String, Object> reply) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        MethodArgumentWriter writer = new MethodArgumentWriter(new ValueWriter(new DataOutputStream(buffer)));
        writer.writeTable(reply);
        writer.flush();
        return buffer.toByteArray();
    }

    public Map<String, Object> handleMapCall(Map<String, Object> request, AMQP.BasicProperties replyProperties) {
        return this.handleMapCall(request);
    }

    public Map<String, Object> handleMapCall(Map<String, Object> request) {
        return new HashMap<String, Object>();
    }

    @Override
    public void handleCast(byte[] requestBody) {
        try {
            this.handleMapCast(MapRpcServer.decode(requestBody));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void handleMapCast(Map<String, Object> requestBody) {
    }
}

