/*
 * Decompiled with CFR 0.152.
 */
package io.rebloom.client.cf;

import java.util.ArrayList;
import java.util.List;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.util.SafeEncoder;

public class CFReserveOptions {
    private long capacity;
    private long bucketSize = -1L;
    private long maxIterations = -1L;
    private long expansion = -1L;

    protected CFReserveOptions() {
    }

    public long getCapacity() {
        return this.capacity;
    }

    public void setCapacity(long capacity) {
        this.capacity = capacity;
    }

    public long getBucketSize() {
        return this.bucketSize;
    }

    public void setBucketSize(long bucketSize) {
        this.bucketSize = bucketSize;
    }

    public long getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(long maxIterations) {
        this.maxIterations = maxIterations;
    }

    public long getExpansion() {
        return this.expansion;
    }

    public void setExpansion(long expansion) {
        this.expansion = expansion;
    }

    public List<byte[]> asListOfByteArrays() {
        ArrayList<byte[]> options = new ArrayList<byte[]>();
        options.add(Protocol.toByteArray((long)this.capacity));
        if (this.bucketSize != -1L) {
            options.add(SafeEncoder.encode((String)"BUCKETSIZE"));
            options.add(Protocol.toByteArray((long)this.bucketSize));
        }
        if (this.maxIterations != -1L) {
            options.add(SafeEncoder.encode((String)"MAXITERATIONS"));
            options.add(Protocol.toByteArray((long)this.maxIterations));
        }
        if (this.expansion != -1L) {
            options.add(SafeEncoder.encode((String)"EXPANSION"));
            options.add(Protocol.toByteArray((long)this.expansion));
        }
        return options;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private CFReserveOptions options = new CFReserveOptions();

        public Builder withCapacity(long capacity) {
            this.options.setCapacity(capacity);
            return this;
        }

        public Builder withBucketSize(long bucketSize) {
            this.options.setBucketSize(bucketSize);
            return this;
        }

        public Builder withMaxIterations(long maxIterations) {
            this.options.setMaxIterations(maxIterations);
            return this;
        }

        public Builder withExpansion(long expansion) {
            this.options.setExpansion(expansion);
            return this;
        }

        public CFReserveOptions build() {
            return this.options;
        }
    }
}

