/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.modules.rejson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.redislabs.modules.rejson.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.Pool;
import redis.clients.jedis.util.SafeEncoder;

public class JReJSON {
    private GsonBuilder gsonBuilder = new GsonBuilder();
    private Gson gson = this.gsonBuilder.create();
    private Pool<Jedis> client;
    private Jedis jedis;
    private static final Gson staticGson = new Gson();

    public void setGsonBuilder(GsonBuilder gsonBuilder) {
        this.gsonBuilder = gsonBuilder;
        this.gson = gsonBuilder.create();
    }

    public JReJSON() {
        this("localhost", 6379);
    }

    public JReJSON(String host, int port) {
        this((Pool<Jedis>)new JedisPool(host, port));
    }

    public JReJSON(Pool<Jedis> jedis) {
        this.client = jedis;
    }

    public JReJSON(Jedis jedis) {
        this.jedis = jedis;
    }

    private static void assertReplyOK(String str) {
        if (str == null) {
            throw new NullPointerException("Null response received.");
        }
    }

    private static Path getSingleOptionalPath(Path ... path) {
        if (1 > path.length) {
            return Path.ROOT_PATH;
        }
        if (1 == path.length) {
            return path[0];
        }
        throw new RuntimeException("Only a single optional path is allowed");
    }

    public Long del(String key) {
        return this.del(key, Path.ROOT_PATH);
    }

    public Long del(String key, Path path) {
        byte[][] args = new byte[][]{SafeEncoder.encode((String)key), SafeEncoder.encode((String)path.toString())};
        try (Jedis conn = this.getConnection();){
            conn.getClient().sendCommand((ProtocolCommand)Command.DEL, (byte[][])args);
            Long l = conn.getClient().getIntegerReply();
            return l;
        }
    }

    public long clear(String key, Path path) {
        try (Jedis jedis = this.getConnection();){
            jedis.getClient().sendCommand((ProtocolCommand)Command.CLEAR, new String[]{key, path.toString()});
            long l = jedis.getClient().getIntegerReply();
            return l;
        }
    }

    public <T> T get(String key) {
        return this.get(key, Path.ROOT_PATH);
    }

    @Deprecated
    public <T> T get(String key, Path ... paths) {
        return (T)this.get(key, Object.class, paths);
    }

    public <T> T get(String key, Class<T> clazz, Path ... paths) {
        String rep;
        byte[][] args = new byte[1 + paths.length][];
        int i = 0;
        args[i] = SafeEncoder.encode((String)key);
        for (Path p : paths) {
            args[++i] = SafeEncoder.encode((String)p.toString());
        }
        try (Jedis conn = this.getConnection();){
            conn.getClient().sendCommand((ProtocolCommand)Command.GET, (byte[][])args);
            rep = conn.getClient().getBulkReply();
        }
        return (T)this.gson.fromJson(rep, clazz);
    }

    public <T> List<T> mget(Class<T> clazz, String ... keys) {
        return this.mget(Path.ROOT_PATH, clazz, keys);
    }

    public <T> List<T> mget(Path path, Class<T> clazz, String ... keys) {
        List rep;
        String[] args = (String[])Stream.of(keys, {path.toString()}).flatMap(Stream::of).toArray(String[]::new);
        try (Jedis conn = this.getConnection();){
            conn.getClient().sendCommand((ProtocolCommand)Command.MGET, args);
            rep = conn.getClient().getMultiBulkReply();
        }
        return rep.stream().map(r -> this.gson.fromJson(r, clazz)).collect(Collectors.toList());
    }

    public void set(String key, Object object, ExistenceModifier flag) {
        this.set(key, object, flag, Path.ROOT_PATH);
    }

    public void set(String key, Object object) {
        this.set(key, object, ExistenceModifier.DEFAULT, Path.ROOT_PATH);
    }

    public void set(String key, Object object, Path path) {
        this.set(key, object, ExistenceModifier.DEFAULT, path);
    }

    public void set(String key, Object object, ExistenceModifier flag, Path path) {
        String status;
        ArrayList<byte[]> args = new ArrayList<byte[]>(4);
        args.add(SafeEncoder.encode((String)key));
        args.add(SafeEncoder.encode((String)path.toString()));
        args.add(SafeEncoder.encode((String)this.gson.toJson(object)));
        if (ExistenceModifier.DEFAULT != flag) {
            args.add(flag.getRaw());
        }
        try (Jedis conn = this.getConnection();){
            conn.getClient().sendCommand((ProtocolCommand)Command.SET, (byte[][])args.toArray((T[])new byte[args.size()][]));
            status = conn.getClient().getStatusCodeReply();
        }
        JReJSON.assertReplyOK(status);
    }

    public void toggle(String key, Path path) {
        try (Jedis jedis = this.getConnection();){
            jedis.getClient().sendCommand((ProtocolCommand)Command.TOGGLE, new String[]{key, path.toString()});
            JReJSON.assertReplyOK(jedis.getClient().getStatusCodeReply());
        }
    }

    public Class<?> type(String key) {
        return this.type(key, Path.ROOT_PATH);
    }

    public Class<?> type(String key, Path path) {
        String rep;
        ArrayList<byte[]> args = new ArrayList<byte[]>(2);
        args.add(SafeEncoder.encode((String)key));
        args.add(SafeEncoder.encode((String)path.toString()));
        try (Jedis conn = this.getConnection();){
            conn.getClient().sendCommand((ProtocolCommand)Command.TYPE, (byte[][])args.toArray((T[])new byte[args.size()][]));
            rep = conn.getClient().getBulkReply();
        }
        switch (rep) {
            case "null": {
                return null;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "integer": {
                return Integer.TYPE;
            }
            case "number": {
                return Float.TYPE;
            }
            case "string": {
                return String.class;
            }
            case "object": {
                return Object.class;
            }
            case "array": {
                return List.class;
            }
        }
        throw new RuntimeException(rep);
    }

    @Deprecated
    public static Long del(Jedis conn, String key, Path ... path) {
        ArrayList<byte[]> args = new ArrayList<byte[]>(2);
        args.add(SafeEncoder.encode((String)key));
        args.add(SafeEncoder.encode((String)JReJSON.getSingleOptionalPath(path).toString()));
        conn.getClient().sendCommand((ProtocolCommand)Command.DEL, (byte[][])args.toArray((T[])new byte[args.size()][]));
        Long rep = conn.getClient().getIntegerReply();
        conn.close();
        return rep;
    }

    @Deprecated
    public static Object get(Jedis conn, String key, Path ... paths) {
        ArrayList<byte[]> args = new ArrayList<byte[]>(2);
        args.add(SafeEncoder.encode((String)key));
        for (Path p : paths) {
            args.add(SafeEncoder.encode((String)p.toString()));
        }
        conn.getClient().sendCommand((ProtocolCommand)Command.GET, (byte[][])args.toArray((T[])new byte[args.size()][]));
        String rep = conn.getClient().getBulkReply();
        conn.close();
        return staticGson.fromJson(rep, Object.class);
    }

    @Deprecated
    public static void set(Jedis conn, String key, Object object, ExistenceModifier flag, Path ... path) {
        ArrayList<byte[]> args = new ArrayList<byte[]>(4);
        args.add(SafeEncoder.encode((String)key));
        args.add(SafeEncoder.encode((String)JReJSON.getSingleOptionalPath(path).toString()));
        args.add(SafeEncoder.encode((String)staticGson.toJson(object)));
        if (ExistenceModifier.DEFAULT != flag) {
            args.add(flag.getRaw());
        }
        conn.getClient().sendCommand((ProtocolCommand)Command.SET, (byte[][])args.toArray((T[])new byte[args.size()][]));
        String status = conn.getClient().getStatusCodeReply();
        conn.close();
        JReJSON.assertReplyOK(status);
    }

    @Deprecated
    public static void set(Jedis conn, String key, Object object, Path ... path) {
        JReJSON.set(conn, key, object, ExistenceModifier.DEFAULT, path);
    }

    @Deprecated
    public static Class<?> type(Jedis conn, String key, Path ... path) {
        ArrayList<byte[]> args = new ArrayList<byte[]>(2);
        args.add(SafeEncoder.encode((String)key));
        args.add(SafeEncoder.encode((String)JReJSON.getSingleOptionalPath(path).toString()));
        conn.getClient().sendCommand((ProtocolCommand)Command.TYPE, (byte[][])args.toArray((T[])new byte[args.size()][]));
        String rep = conn.getClient().getBulkReply();
        conn.close();
        switch (rep) {
            case "null": {
                return null;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "integer": {
                return Integer.TYPE;
            }
            case "number": {
                return Float.TYPE;
            }
            case "string": {
                return String.class;
            }
            case "object": {
                return Object.class;
            }
            case "array": {
                return List.class;
            }
        }
        throw new RuntimeException(rep);
    }

    private Jedis getConnection() {
        return this.jedis != null ? this.jedis : (Jedis)this.client.getResource();
    }

    public Long strAppend(String key, Path path, Object ... objects) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(SafeEncoder.encode((String)key));
        args.add(SafeEncoder.encode((String)path.toString()));
        args.addAll(Arrays.stream(objects).map(object -> SafeEncoder.encode((String)this.gson.toJson(object))).collect(Collectors.toList()));
        try (Jedis conn = this.getConnection();){
            conn.getClient().sendCommand((ProtocolCommand)Command.STRAPPEND, (byte[][])args.toArray((T[])new byte[args.size()][]));
            Long l = conn.getClient().getIntegerReply();
            return l;
        }
    }

    public Long strLen(String key, Path path) {
        byte[][] args = new byte[][]{SafeEncoder.encode((String)key), SafeEncoder.encode((String)path.toString())};
        try (Jedis conn = this.getConnection();){
            conn.getClient().sendCommand((ProtocolCommand)Command.STRLEN, (byte[][])args);
            Long l = conn.getClient().getIntegerReply();
            return l;
        }
    }

    public Long arrAppend(String key, Path path, Object ... objects) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(SafeEncoder.encode((String)key));
        args.add(SafeEncoder.encode((String)JReJSON.getSingleOptionalPath(path).toString()));
        args.addAll(Arrays.stream(objects).map(object -> SafeEncoder.encode((String)this.gson.toJson(object))).collect(Collectors.toList()));
        try (Jedis conn = this.getConnection();){
            conn.getClient().sendCommand((ProtocolCommand)Command.ARRAPPEND, (byte[][])args.toArray((T[])new byte[args.size()][]));
            Long l = conn.getClient().getIntegerReply();
            return l;
        }
    }

    public Long arrIndex(String key, Path path, Object scalar) {
        byte[][] args = new byte[][]{SafeEncoder.encode((String)key), SafeEncoder.encode((String)path.toString()), SafeEncoder.encode((String)this.gson.toJson(scalar))};
        try (Jedis conn = this.getConnection();){
            conn.getClient().sendCommand((ProtocolCommand)Command.ARRINDEX, (byte[][])args);
            Long l = conn.getClient().getIntegerReply();
            return l;
        }
    }

    public Long arrInsert(String key, Path path, Long index, Object ... objects) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(SafeEncoder.encode((String)key));
        args.add(SafeEncoder.encode((String)JReJSON.getSingleOptionalPath(path).toString()));
        args.add(Protocol.toByteArray((long)index));
        args.addAll(Arrays.stream(objects).map(object -> SafeEncoder.encode((String)this.gson.toJson(object))).collect(Collectors.toList()));
        try (Jedis conn = this.getConnection();){
            conn.getClient().sendCommand((ProtocolCommand)Command.ARRINSERT, (byte[][])args.toArray((T[])new byte[args.size()][]));
            Long l = conn.getClient().getIntegerReply();
            return l;
        }
    }

    public Long arrLen(String key, Path path) {
        byte[][] args = new byte[][]{SafeEncoder.encode((String)key), SafeEncoder.encode((String)path.toString())};
        try (Jedis conn = this.getConnection();){
            conn.getClient().sendCommand((ProtocolCommand)Command.ARRLEN, (byte[][])args);
            Long l = conn.getClient().getIntegerReply();
            return l;
        }
    }

    public <T> T arrPop(String key, Class<T> clazz, Path path, Long index) {
        String rep;
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(SafeEncoder.encode((String)key));
        args.add(SafeEncoder.encode((String)(path != null ? path.toString() : Path.ROOT_PATH.toString())));
        args.add(Protocol.toByteArray((long)(index != null ? index : -1L)));
        try (Jedis conn = this.getConnection();){
            conn.getClient().sendCommand((ProtocolCommand)Command.ARRPOP, (byte[][])args.toArray((T[])new byte[args.size()][]));
            rep = conn.getClient().getBulkReply();
        }
        return (T)this.gson.fromJson(rep, clazz);
    }

    public <T> T arrPop(String key, Class<T> clazz, Path path) {
        return this.arrPop(key, clazz, path, null);
    }

    public <T> T arrPop(String key, Class<T> clazz) {
        return this.arrPop(key, clazz, null, null);
    }

    public Long arrTrim(String key, Path path, Long start, Long stop) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(SafeEncoder.encode((String)key));
        args.add(SafeEncoder.encode((String)JReJSON.getSingleOptionalPath(path).toString()));
        args.add(Protocol.toByteArray((long)start));
        args.add(Protocol.toByteArray((long)stop));
        try (Jedis conn = this.getConnection();){
            conn.getClient().sendCommand((ProtocolCommand)Command.ARRTRIM, (byte[][])args.toArray((T[])new byte[args.size()][]));
            Long l = conn.getClient().getIntegerReply();
            return l;
        }
    }

    public static enum ExistenceModifier implements ProtocolCommand
    {
        DEFAULT(""),
        NOT_EXISTS("NX"),
        MUST_EXIST("XX");

        private final byte[] raw;

        private ExistenceModifier(String alt) {
            this.raw = SafeEncoder.encode((String)alt);
        }

        public byte[] getRaw() {
            return this.raw;
        }
    }

    private static enum Command implements ProtocolCommand
    {
        DEL("JSON.DEL"),
        GET("JSON.GET"),
        MGET("JSON.MGET"),
        SET("JSON.SET"),
        TYPE("JSON.TYPE"),
        STRAPPEND("JSON.STRAPPEND"),
        STRLEN("JSON.STRLEN"),
        ARRAPPEND("JSON.ARRAPPEND"),
        ARRINDEX("JSON.ARRINDEX"),
        ARRINSERT("JSON.ARRINSERT"),
        ARRLEN("JSON.ARRLEN"),
        ARRPOP("JSON.ARRPOP"),
        ARRTRIM("JSON.ARRTRIM"),
        CLEAR("JSON.CLEAR"),
        TOGGLE("JSON.TOGGLE");

        private final byte[] raw;

        private Command(String alt) {
            this.raw = SafeEncoder.encode((String)alt);
        }

        public byte[] getRaw() {
            return this.raw;
        }
    }
}

