/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Date;
import org.apache.log4j.Logger;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.SimpleFSDirectory;
import proj.zoie.api.DirectoryManager;
import proj.zoie.api.impl.util.ChannelUtil;
import proj.zoie.api.impl.util.FileUtil;
import proj.zoie.impl.indexing.internal.IndexSignature;

public class DefaultDirectoryManager
implements DirectoryManager {
    public static final Logger log = Logger.getLogger(DefaultDirectoryManager.class);
    private File _location;
    private final DirectoryManager.DIRECTORY_MODE _mode;

    public DefaultDirectoryManager(File location) {
        if (location == null) {
            throw new IllegalArgumentException("null index directory.");
        }
        this._location = location;
        this._mode = DirectoryManager.DIRECTORY_MODE.SIMPLE;
    }

    public DefaultDirectoryManager(File location, DirectoryManager.DIRECTORY_MODE mode) {
        if (location == null) {
            throw new IllegalArgumentException("null index directory.");
        }
        this._location = location;
        this._mode = mode;
    }

    public File getLocation() {
        return this._location;
    }

    @Override
    public Directory getDirectory() throws IOException {
        return this.getDirectory(false);
    }

    @Override
    public Directory getDirectory(boolean create) throws IOException {
        if (!this._location.exists() && create) {
            this._location.mkdirs();
        }
        if (create) {
            IndexSignature sig = null;
            if (this._location.exists()) {
                sig = this.getCurrentIndexSignature();
            }
            if (sig == null) {
                File directoryFile = new File(this._location, "index.directory");
                sig = new IndexSignature(null);
                DefaultDirectoryManager.saveSignature(sig, directoryFile);
            }
        }
        SimpleFSDirectory dir = null;
        switch (this._mode) {
            case SIMPLE: {
                dir = new SimpleFSDirectory(this._location);
                break;
            }
            case NIO: {
                dir = new NIOFSDirectory(this._location);
                break;
            }
            case MMAP: {
                dir = new MMapDirectory(this._location);
            }
        }
        log.info((Object)("created Directory: " + dir));
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IndexSignature readSignature(File file) {
        if (file.exists()) {
            FileInputStream fin = null;
            try {
                fin = new FileInputStream(file);
                IndexSignature indexSignature = IndexSignature.read(fin);
                return indexSignature;
            }
            catch (IOException ioe) {
                log.error((Object)"Problem reading index directory file.", (Throwable)ioe);
                IndexSignature indexSignature = null;
                return indexSignature;
            }
            finally {
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (IOException e) {
                        log.warn((Object)("Problem closing index directory file: " + e.getMessage()));
                    }
                }
            }
        }
        log.info((Object)("Starting with empty search index: version information not found at " + file.getAbsolutePath()));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveSignature(IndexSignature sig, File file) throws IOException {
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            sig.save(fout);
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException e) {
                    log.warn((Object)("Problem closing index directory file: " + e.getMessage()));
                }
            }
        }
    }

    public IndexSignature getCurrentIndexSignature() {
        return DefaultDirectoryManager.getCurrentIndexSignature(this._location);
    }

    public static IndexSignature getCurrentIndexSignature(File idxDir) {
        File directoryFile = new File(idxDir, "index.directory");
        IndexSignature sig = DefaultDirectoryManager.readSignature(directoryFile);
        return sig;
    }

    @Override
    public String getVersion() throws IOException {
        IndexSignature sig = this.getCurrentIndexSignature();
        return sig == null ? null : sig.getVersion();
    }

    @Override
    public void setVersion(String version) throws IOException {
        File directoryFile = new File(this._location, "index.directory");
        IndexSignature sig = DefaultDirectoryManager.readSignature(directoryFile);
        sig.updateVersion(version);
        File tmpFile = new File(this._location, "index.directory.new");
        DefaultDirectoryManager.saveSignature(sig, tmpFile);
        File tmpFile2 = new File(this._location, "index.directory.tmp");
        directoryFile.renameTo(tmpFile2);
        tmpFile.renameTo(directoryFile);
        tmpFile2.delete();
    }

    @Override
    public Date getLastIndexModifiedTime() {
        File directoryFile = new File(this._location, "index.directory");
        return new Date(directoryFile.lastModified());
    }

    @Override
    public String getPath() {
        return this._location.getAbsolutePath();
    }

    @Override
    public void purge() {
        FileUtil.rmDir(this._location);
    }

    @Override
    public boolean exists() {
        return this._location.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean transferFromChannelToFile(ReadableByteChannel channel, String fileName) throws IOException {
        long dataLen;
        if (!this._location.exists()) {
            this._location.mkdirs();
        }
        if ((dataLen = ChannelUtil.readLong(channel)) < 0L) {
            return false;
        }
        File file = new File(this._location, fileName);
        RandomAccessFile raf = null;
        AbstractInterruptibleChannel fc = null;
        try {
            log.info((Object)("transferFromChannelToFile for " + fileName + " with " + dataLen + " bytes"));
            raf = new RandomAccessFile(file, "rw");
            fc = raf.getChannel();
            long position = 0L;
            while ((position += ((FileChannel)fc).transferFrom(channel, position, dataLen - position)) < dataLen) {
            }
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                if (fc != null) {
                    fc.close();
                }
            }
            finally {
                if (raf != null) {
                    raf.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferFromFileToChannel(String fileName, WritableByteChannel channel) throws IOException {
        long position;
        long amount = 0L;
        File file = new File(this._location, fileName);
        RandomAccessFile raf = null;
        AbstractInterruptibleChannel fc = null;
        try {
            raf = new RandomAccessFile(file, "r");
            fc = raf.getChannel();
            long dataLen = ((FileChannel)fc).size();
            log.info((Object)("transferFromFileToChannel for " + fileName + " of " + dataLen + " bytes"));
            amount += ChannelUtil.writeLong(channel, dataLen);
            position = 0L;
            while ((position += ((FileChannel)fc).transferTo(position, dataLen - position, channel)) < dataLen) {
            }
        }
        finally {
            try {
                if (fc != null) {
                    fc.close();
                }
            }
            finally {
                if (raf != null) {
                    raf.close();
                }
            }
        }
        return amount += position;
    }
}

