/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.api;

import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import proj.zoie.api.DocIDMapper;

public class UIDDocIdSet
extends DocIdSet {
    private final int[] _sorted;

    public UIDDocIdSet(long[] uidArray, DocIDMapper<?> mapper) {
        if (uidArray == null) {
            throw new IllegalArgumentException("input uid array is null");
        }
        this._sorted = UIDDocIdSet.mapUID(uidArray, mapper);
    }

    public UIDDocIdSet(int[] docids) {
        this._sorted = docids;
    }

    public static int[] mapUID(long[] uidArray, DocIDMapper<?> mapper) {
        IntRBTreeSet idSet = new IntRBTreeSet();
        for (long uid : uidArray) {
            int docid;
            if (uid == Long.MIN_VALUE || (docid = mapper.getDocID(uid)) == -1) continue;
            idSet.add(docid);
        }
        return idSet.toIntArray();
    }

    public DocIdSetIterator iterator() {
        return new DocIdSetIterator(){
            int doc = -1;
            int current = -1;

            public int docID() {
                return this.doc;
            }

            public int nextDoc() throws IOException {
                if (this.current < UIDDocIdSet.this._sorted.length - 1) {
                    ++this.current;
                    this.doc = UIDDocIdSet.this._sorted[this.current];
                    return this.doc;
                }
                return Integer.MAX_VALUE;
            }

            public int advance(int target) throws IOException {
                int idx = Arrays.binarySearch(UIDDocIdSet.this._sorted, target);
                if (idx < 0 && (idx = -(idx + 1)) >= UIDDocIdSet.this._sorted.length) {
                    return Integer.MAX_VALUE;
                }
                this.current = idx;
                this.doc = UIDDocIdSet.this._sorted[this.current];
                return this.doc;
            }
        };
    }
}

