/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.api;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import proj.zoie.api.UIDDocIdSet;
import proj.zoie.api.ZoieIndexReader;

public class UIDFilter
extends Filter {
    private static final long serialVersionUID = 1L;
    private final long[] _filteredIDs;

    public UIDFilter(long[] filteredIDs) {
        this._filteredIDs = filteredIDs;
    }

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        if (reader instanceof ZoieIndexReader) {
            return new UIDDocIdSet(this._filteredIDs, ((ZoieIndexReader)reader).getDocIDMaper());
        }
        throw new IllegalArgumentException("UIDFilter may only load from ZoieIndexReader instances");
    }

    public static Query getUIDQuery(long[] uids) {
        return new ConstantScoreQuery((Filter)new UIDFilter(uids));
    }
}

