/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.api;

import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.ReaderUtil;
import proj.zoie.api.DocIDMapper;
import proj.zoie.api.IndexReaderMerger;
import proj.zoie.api.ZoieMultiReader;
import proj.zoie.api.impl.DefaultIndexReaderMerger;
import proj.zoie.api.indexing.IndexReaderDecorator;

public abstract class ZoieIndexReader<R extends IndexReader>
extends FilterIndexReader {
    private static final Logger log = Logger.getLogger(ZoieIndexReader.class);
    public static final long DELETED_UID = Long.MIN_VALUE;
    private AtomicLong zoieRefCounter = new AtomicLong(1L);
    protected int[] _delDocIds;
    protected long _minUID;
    protected long _maxUID;
    protected boolean _noDedup = false;
    protected final IndexReaderDecorator<R> _decorator;
    protected DocIDMapper<?> _docIDMapper;

    public void incZoieRef() {
        this.zoieRefCounter.incrementAndGet();
    }

    public void decZoieRef() {
        long refCount = this.zoieRefCounter.decrementAndGet();
        if (refCount < 0L) {
            log.warn((Object)"refCount should never be lower than 0");
        }
        if (refCount == 0L) {
            try {
                this.in.decRef();
            }
            catch (IOException e) {
                log.error((Object)"decZoieRef", (Throwable)e);
            }
        }
    }

    public static <R extends IndexReader> List<R> extractDecoratedReaders(List<ZoieIndexReader<R>> readerList) throws IOException {
        LinkedList<R> retList = new LinkedList<R>();
        for (ZoieIndexReader<R> reader : readerList) {
            retList.addAll(reader.getDecoratedReaders());
        }
        return retList;
    }

    public static <R extends IndexReader> SubReaderAccessor<R> getSubReaderAccessor(List<R> readerList) {
        int size = readerList.size();
        final IndexReader[] subR = new IndexReader[size];
        final int[] starts = new int[size + 1];
        int maxDoc = 0;
        int i = 0;
        for (IndexReader r : readerList) {
            starts[i] = maxDoc;
            subR[i] = r;
            maxDoc += r.maxDoc();
            ++i;
        }
        starts[size] = maxDoc;
        return new SubReaderAccessor<R>(){

            @Override
            public SubReaderInfo<R> getSubReaderInfo(int docid) {
                int subIdx = ReaderUtil.subIndex((int)docid, (int[])starts);
                int subdocid = docid - starts[subIdx];
                IndexReader subreader = subR[subIdx];
                return new SubReaderInfo<IndexReader>(subreader, subdocid);
            }
        };
    }

    public static <R extends IndexReader> SubZoieReaderAccessor<R> getSubZoieReaderAccessor(List<ZoieIndexReader<R>> readerList) {
        int size = readerList.size();
        final ZoieIndexReader[] subR = new ZoieIndexReader[size];
        final int[] starts = new int[size + 1];
        int maxDoc = 0;
        int i = 0;
        for (ZoieIndexReader<R> r : readerList) {
            starts[i] = maxDoc;
            subR[i] = r;
            maxDoc += r.maxDoc();
            ++i;
        }
        starts[size] = maxDoc;
        return new SubZoieReaderAccessor<R>(){

            @Override
            public SubReaderInfo<ZoieIndexReader<R>> getSubReaderInfo(int docid) {
                int subIdx = ReaderUtil.subIndex((int)docid, (int[])starts);
                int subdocid = docid - starts[subIdx];
                return new SubReaderInfo(subR[subIdx], subdocid);
            }

            @Override
            public SubReaderInfo<ZoieIndexReader<R>> geSubReaderInfoFromUID(long uid) {
                SubReaderInfo<ZoieIndexReader> info = null;
                for (int i = 0; i < subR.length; ++i) {
                    ZoieIndexReader subReader = subR[i];
                    DocIDMapper<?> mapper = subReader.getDocIDMaper();
                    int docid = mapper.getDocID(uid);
                    if (docid == -1) continue;
                    info = new SubReaderInfo<ZoieIndexReader>(subReader, docid);
                    break;
                }
                return info;
            }
        };
    }

    public static <R extends IndexReader> ZoieIndexReader<R> open(IndexReader r) throws IOException {
        return ZoieIndexReader.open(r, null);
    }

    public static <R extends IndexReader> ZoieIndexReader<R> open(IndexReader r, IndexReaderDecorator<R> decorator) throws IOException {
        return new ZoieMultiReader<R>(r, decorator);
    }

    public static <R extends IndexReader> ZoieIndexReader<R> open(Directory dir, IndexReaderDecorator<R> decorator) throws IOException {
        IndexReader r = IndexReader.open((Directory)dir, (boolean)true);
        try {
            return ZoieIndexReader.open(r, decorator);
        }
        catch (IOException ioe) {
            if (r != null) {
                r.close();
            }
            throw ioe;
        }
    }

    public static <R extends IndexReader, T extends IndexReader> R mergeIndexReaders(List<ZoieIndexReader<T>> readerList, IndexReaderMerger<R, T> merger) {
        return merger.mergeIndexReaders(readerList);
    }

    public static <T extends IndexReader> MultiReader mergeIndexReaders(List<ZoieIndexReader<T>> readerList) {
        return (MultiReader)ZoieIndexReader.mergeIndexReaders(readerList, new DefaultIndexReaderMerger());
    }

    protected ZoieIndexReader(IndexReader in, IndexReaderDecorator<R> decorator) throws IOException {
        super(in);
        this._decorator = decorator;
        this._delDocIds = null;
        this._minUID = Long.MAX_VALUE;
        this._maxUID = Long.MIN_VALUE;
    }

    public abstract List<R> getDecoratedReaders() throws IOException;

    public abstract void setDelDocIds();

    public abstract void markDeletes(LongSet var1, LongSet var2);

    public abstract void commitDeletes();

    public IndexReader getInnerReader() {
        return this.in;
    }

    public boolean hasDeletions() {
        int[] delSet;
        if (!this._noDedup && (delSet = this._delDocIds) != null && delSet.length > 0) {
            return true;
        }
        return this.in.hasDeletions();
    }

    protected abstract boolean hasIndexDeletions();

    public boolean hasDuplicates() {
        int[] delSet = this._delDocIds;
        return delSet != null && delSet.length > 0;
    }

    public abstract boolean isDeleted(int var1);

    public abstract byte[] getStoredValue(long var1) throws IOException;

    public boolean isDuplicate(int docid) {
        int[] delSet = this._delDocIds;
        return delSet != null && Arrays.binarySearch(delSet, docid) >= 0;
    }

    public boolean isDuplicateUID(long uid) {
        int docid = this._docIDMapper.getDocID(uid);
        return this.isDuplicate(docid);
    }

    public int[] getDelDocIds() {
        return this._delDocIds;
    }

    public long getMinUID() {
        return this._minUID;
    }

    public long getMaxUID() {
        return this._maxUID;
    }

    public abstract long getUID(int var1);

    public DocIDMapper<?> getDocIDMaper() {
        return this._docIDMapper;
    }

    public void setDocIDMapper(DocIDMapper<?> docIDMapper) {
        this._docIDMapper = docIDMapper;
    }

    public void setNoDedup(boolean noDedup) {
        this._noDedup = noDedup;
    }

    public abstract ZoieIndexReader<R>[] getSequentialSubReaders();

    public abstract TermDocs termDocs() throws IOException;

    public abstract TermPositions termPositions() throws IOException;

    public abstract ZoieIndexReader<R> copy() throws IOException;

    public static interface SubZoieReaderAccessor<R extends IndexReader> {
        public SubReaderInfo<ZoieIndexReader<R>> getSubReaderInfo(int var1);

        public SubReaderInfo<ZoieIndexReader<R>> geSubReaderInfoFromUID(long var1);
    }

    public static interface SubReaderAccessor<R extends IndexReader> {
        public SubReaderInfo<R> getSubReaderInfo(int var1);
    }

    public static class SubReaderInfo<R extends IndexReader> {
        public final R subreader;
        public final int subdocid;

        SubReaderInfo(R subreader, int subdocid) {
            this.subreader = subreader;
            this.subdocid = subdocid;
        }
    }
}

