/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.api;

import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiZoieTermDocs;
import org.apache.lucene.index.MultiZoieTermPositions;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermPositions;
import proj.zoie.api.ZoieIndexReader;
import proj.zoie.api.ZoieSegmentReader;
import proj.zoie.api.indexing.IndexReaderDecorator;

public class ZoieMultiReader<R extends IndexReader>
extends ZoieIndexReader<R> {
    private static final Logger log = Logger.getLogger((String)ZoieMultiReader.class.getName());
    private Map<String, ZoieSegmentReader<R>> _readerMap = new HashMap<String, ZoieSegmentReader<R>>();
    private ArrayList<ZoieSegmentReader<R>> _subZoieReaders;
    private int[] _starts;
    private List<R> _decoratedReaders = null;

    public ZoieMultiReader(IndexReader in, IndexReaderDecorator<R> decorator) throws IOException {
        super(in, decorator);
        IndexReader[] subReaders = in.getSequentialSubReaders();
        this.init(subReaders);
    }

    public ZoieMultiReader(IndexReader in, IndexReader[] subReaders, IndexReaderDecorator<R> decorator) throws IOException {
        super(in, decorator);
        this.init(subReaders);
    }

    public int[] getStarts() {
        return this._starts;
    }

    @Override
    public byte[] getStoredValue(long uid) throws IOException {
        int docid = this.getDocIDMaper().getDocID(uid);
        if (docid < 0) {
            return null;
        }
        int idx = this.readerIndex(docid);
        if (idx < 0) {
            return null;
        }
        ZoieIndexReader subReader = this._subZoieReaders.get(idx);
        return subReader.getStoredValue(uid);
    }

    private void init(IndexReader[] subReaders) throws IOException {
        this._subZoieReaders = new ArrayList(subReaders.length);
        this._starts = new int[subReaders.length + 1];
        int i = 0;
        int startCount = 0;
        for (IndexReader subReader : subReaders) {
            ZoieSegmentReader zr = null;
            if (subReader instanceof ZoieSegmentReader) {
                zr = (ZoieSegmentReader)subReader;
            } else if (subReader instanceof SegmentReader) {
                SegmentReader sr = (SegmentReader)subReader;
                zr = new ZoieSegmentReader((IndexReader)sr, this._decorator);
            }
            if (zr != null) {
                String segmentName = zr.getSegmentName();
                this._readerMap.put(segmentName, zr);
                this._subZoieReaders.add(zr);
                this._starts[i] = startCount;
                ++i;
                startCount += zr.maxDoc();
                continue;
            }
            throw new IllegalStateException("subreader not instance of " + SegmentReader.class);
        }
        this._starts[subReaders.length] = this.in.maxDoc();
        ArrayList<R> decoratedList = new ArrayList<R>(this._subZoieReaders.size());
        for (ZoieSegmentReader<R> subReader : this._subZoieReaders) {
            R decoratedReader = subReader.getDecoratedReader();
            decoratedList.add(decoratedReader);
            subReader.incSegmentRef();
        }
        this._decoratedReaders = decoratedList;
    }

    @Override
    public long getUID(int docid) {
        int idx = this.readerIndex(docid);
        ZoieIndexReader subReader = this._subZoieReaders.get(idx);
        return subReader.getUID(docid - this._starts[idx]);
    }

    @Override
    public long getMinUID() {
        long uid = Long.MAX_VALUE;
        for (ZoieSegmentReader<R> reader : this._subZoieReaders) {
            uid = uid > reader.getMinUID() ? reader.getMinUID() : uid;
        }
        return uid;
    }

    @Override
    public long getMaxUID() {
        long uid = Long.MIN_VALUE;
        for (ZoieSegmentReader<R> reader : this._subZoieReaders) {
            uid = uid < reader.getMaxUID() ? reader.getMaxUID() : uid;
        }
        return uid;
    }

    @Override
    public ZoieIndexReader<R>[] getSequentialSubReaders() {
        return this._subZoieReaders.toArray(new ZoieSegmentReader[this._subZoieReaders.size()]);
    }

    @Override
    public void markDeletes(LongSet delDocs, LongSet deletedUIDs) {
        ZoieIndexReader<R>[] subReaders = this.getSequentialSubReaders();
        if (subReaders != null && subReaders.length > 0) {
            for (int i = 0; i < subReaders.length; ++i) {
                ZoieSegmentReader subReader = (ZoieSegmentReader)subReaders[i];
                subReader.markDeletes(delDocs, deletedUIDs);
            }
        }
    }

    @Override
    public void commitDeletes() {
        ZoieIndexReader<R>[] subReaders = this.getSequentialSubReaders();
        if (subReaders != null && subReaders.length > 0) {
            for (int i = 0; i < subReaders.length; ++i) {
                ZoieSegmentReader subReader = (ZoieSegmentReader)subReaders[i];
                subReader.commitDeletes();
            }
        }
    }

    @Override
    public void setDelDocIds() {
        ZoieIndexReader<R>[] subReaders;
        for (ZoieIndexReader<R> subReader : subReaders = this.getSequentialSubReaders()) {
            subReader.setDelDocIds();
        }
    }

    @Override
    public List<R> getDecoratedReaders() throws IOException {
        return this._decoratedReaders;
    }

    @Override
    protected boolean hasIndexDeletions() {
        for (ZoieSegmentReader<R> subReader : this._subZoieReaders) {
            if (!subReader.hasIndexDeletions()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDeleted(int docid) {
        int idx = this.readerIndex(docid);
        ZoieIndexReader subReader = this._subZoieReaders.get(idx);
        return subReader.isDeleted(docid - this._starts[idx]);
    }

    private int readerIndex(int n) {
        return ZoieMultiReader.readerIndex(n, this._starts, this._starts.length);
    }

    static final int readerIndex(int n, int[] starts, int numSubReaders) {
        int lo = 0;
        int hi = numSubReaders - 1;
        while (hi >= lo) {
            int mid = lo + hi >>> 1;
            int midValue = starts[mid];
            if (n < midValue) {
                hi = mid - 1;
                continue;
            }
            if (n > midValue) {
                if (n < starts[mid + 1]) {
                    return mid;
                }
                lo = mid + 1;
                continue;
            }
            while (mid + 1 < numSubReaders && starts[mid + 1] == midValue) {
                ++mid;
            }
            return mid;
        }
        return hi;
    }

    @Override
    public TermDocs termDocs() throws IOException {
        return new MultiZoieTermDocs(this, this._subZoieReaders.toArray(new ZoieIndexReader[this._subZoieReaders.size()]), this._starts);
    }

    @Override
    public TermPositions termPositions() throws IOException {
        return new MultiZoieTermPositions(this, this._subZoieReaders.toArray(new ZoieIndexReader[this._subZoieReaders.size()]), this._starts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose() throws IOException {
        try {
            super.doClose();
        }
        finally {
            for (ZoieSegmentReader<R> r : this._subZoieReaders) {
                r.decSegmentRef();
            }
        }
    }

    public synchronized void incRef() {
        super.incRef();
    }

    public synchronized void decRef() throws IOException {
        super.decRef();
    }

    public ZoieIndexReader<R> reopen(boolean openReadOnly) throws CorruptIndexException, IOException {
        long t0 = System.currentTimeMillis();
        long version = this.in.getVersion();
        IndexReader inner = this.in.reopen(openReadOnly);
        if (inner == this.in && inner.getVersion() == version) {
            t0 = System.currentTimeMillis() - t0;
            if (t0 > 1000L) {
                log.info((Object)("reopen returns in " + t0 + "ms without change"));
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("reopen returns in " + t0 + "ms without change"));
            }
            return this;
        }
        IndexReader[] subReaders = inner.getSequentialSubReaders();
        ArrayList<ZoieSegmentReader<R>> subReaderList = new ArrayList<ZoieSegmentReader<R>>(subReaders.length);
        for (IndexReader subReader : subReaders) {
            ZoieSegmentReader<R> zoieSegmentReader;
            if (subReader instanceof SegmentReader) {
                SegmentReader sr = (SegmentReader)subReader;
                String segmentName = sr.getSegmentName();
                zoieSegmentReader = this._readerMap.get(segmentName);
                if (zoieSegmentReader != null) {
                    int numDocs = sr.numDocs();
                    int maxDocs = sr.maxDoc();
                    boolean hasDeletes = false;
                    if (zoieSegmentReader.numDocs() != numDocs || zoieSegmentReader.maxDoc() != maxDocs) {
                        hasDeletes = true;
                    }
                    zoieSegmentReader = new ZoieSegmentReader<R>(zoieSegmentReader, (IndexReader)sr, hasDeletes);
                } else {
                    zoieSegmentReader = new ZoieSegmentReader((IndexReader)sr, this._decorator);
                }
            } else {
                throw new IllegalStateException("reader not insance of " + SegmentReader.class);
            }
            subReaderList.add(zoieSegmentReader);
        }
        ZoieMultiReader<R> ret = this.newInstance(inner, subReaderList.toArray(new IndexReader[subReaderList.size()]));
        t0 = System.currentTimeMillis() - t0;
        if (t0 > 1000L) {
            log.info((Object)("reopen returns in " + t0 + "ms with change"));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("reopen returns in " + t0 + "ms with change"));
        }
        return ret;
    }

    protected ZoieMultiReader<R> newInstance(IndexReader inner, IndexReader[] subReaders) throws IOException {
        return new ZoieMultiReader<R>(inner, subReaders, this._decorator);
    }

    @Override
    public ZoieMultiReader<R> copy() throws IOException {
        ArrayList<ZoieSegmentReader<R>> sourceZoieSubReaders = this._subZoieReaders;
        ArrayList<ZoieIndexReader> zoieSubReaders = new ArrayList<ZoieIndexReader>(this._subZoieReaders.size());
        for (ZoieSegmentReader<R> r : sourceZoieSubReaders) {
            zoieSubReaders.add(r.copy());
        }
        this.in.incRef();
        ZoieMultiReader<R> ret = this.newInstance(this.in, zoieSubReaders.toArray(new IndexReader[zoieSubReaders.size()]));
        ret._docIDMapper = this._docIDMapper;
        ret._minUID = this._minUID;
        ret._maxUID = this._maxUID;
        ret._noDedup = this._noDedup;
        return ret;
    }
}

