/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.api;

import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Payload;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.DocIdSet;
import proj.zoie.api.DocIDMapper;
import proj.zoie.api.ZoieIndexReader;
import proj.zoie.api.impl.util.ArrayDocIdSet;
import proj.zoie.api.indexing.IndexReaderDecorator;
import proj.zoie.impl.indexing.internal.ZoieSegmentTermDocs;
import proj.zoie.impl.indexing.internal.ZoieSegmentTermPositions;

public class ZoieSegmentReader<R extends IndexReader>
extends ZoieIndexReader<R> {
    public static final String termVal = "_UID";
    public static final Term UID_TERM = new Term("_ID", "_UID");
    private R _decoratedReader;
    private long[] _uidArray;
    private IntRBTreeSet _delDocIdSet = new IntRBTreeSet();
    private int[] _currentDelDocIds;
    private AtomicLong zoieRefSegmentCounter = new AtomicLong(1L);

    public static void fillDocumentID(Document doc, long id) {
        Field uidField = new Field(UID_TERM.field(), (TokenStream)new UIDTokenStream(id));
        uidField.setOmitNorms(true);
        doc.add((Fieldable)uidField);
    }

    public ZoieSegmentReader(IndexReader in, IndexReaderDecorator<R> decorator) throws IOException {
        super(in, decorator);
        if (!(in instanceof SegmentReader)) {
            throw new IllegalStateException("ZoieSegmentReader can only be constucted from " + SegmentReader.class);
        }
        this.init(in);
        this._decoratedReader = decorator == null ? null : decorator.decorate(this);
    }

    ZoieSegmentReader(ZoieSegmentReader<R> copyFrom, IndexReader innerReader, boolean withDeletes) throws IOException {
        super(innerReader, copyFrom._decorator);
        this._uidArray = copyFrom._uidArray;
        this._maxUID = copyFrom._maxUID;
        this._minUID = copyFrom._minUID;
        this._noDedup = copyFrom._noDedup;
        this._docIDMapper = copyFrom._docIDMapper;
        this._delDocIdSet = copyFrom._delDocIdSet;
        this._decoratedReader = copyFrom._decorator == null ? null : copyFrom._decorator.redecorate(copyFrom._decoratedReader, this, withDeletes);
    }

    ZoieSegmentReader(ZoieSegmentReader<R> copyFrom, IndexReader innerReader) throws IOException {
        super(innerReader, copyFrom._decorator);
        this._uidArray = copyFrom._uidArray;
        this._maxUID = copyFrom._maxUID;
        this._minUID = copyFrom._minUID;
        this._noDedup = copyFrom._noDedup;
        this._docIDMapper = copyFrom._docIDMapper;
        this._delDocIdSet = copyFrom._delDocIdSet;
        this._currentDelDocIds = copyFrom._currentDelDocIds;
        this._decoratedReader = copyFrom._decorator == null ? null : copyFrom._decorator.redecorate(copyFrom._decoratedReader, this, this.getDelDocIds() != null && this.getDelDocIds().length > 0);
    }

    @Override
    public void markDeletes(LongSet delDocs, LongSet deletedUIDs) {
        DocIDMapper<?> idMapper = this.getDocIDMaper();
        LongIterator iter = delDocs.iterator();
        IntRBTreeSet delDocIdSet = this._delDocIdSet;
        while (iter.hasNext()) {
            int docid;
            long uid = iter.nextLong();
            if (Long.MIN_VALUE == uid || (docid = idMapper.getDocID(uid)) == -1) continue;
            delDocIdSet.add(docid);
            deletedUIDs.add(uid);
        }
    }

    @Override
    public void commitDeletes() {
        this._currentDelDocIds = this._delDocIdSet.toIntArray();
    }

    @Override
    public void setDelDocIds() {
        this._delDocIds = this._currentDelDocIds;
        if (this._decorator != null && this._decoratedReader != null) {
            this._decorator.setDeleteSet(this._decoratedReader, new ArrayDocIdSet(this._currentDelDocIds));
        }
    }

    public R getDecoratedReader() {
        return this._decoratedReader;
    }

    @Override
    public List<R> getDecoratedReaders() {
        ArrayList<R> list = new ArrayList<R>(1);
        if (this._decoratedReader != null) {
            list.add(this._decoratedReader);
        }
        return list;
    }

    @Override
    public byte[] getStoredValue(long uid) throws IOException {
        Document doc;
        int docid = this.getDocIDMaper().getDocID(uid);
        if (docid < 0) {
            return null;
        }
        if (docid >= 0 && (doc = this.document(docid)) != null) {
            return doc.getBinaryValue("_STORE");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(IndexReader reader) throws IOException {
        int maxDoc = reader.maxDoc();
        this._uidArray = new long[maxDoc];
        TermPositions tp = null;
        byte[] payloadBuffer = new byte[8];
        try {
            tp = reader.termPositions(UID_TERM);
            int idx = 0;
            while (tp.next()) {
                int doc = tp.doc();
                assert (doc < maxDoc);
                while (idx < doc) {
                    this._uidArray[idx++] = Long.MIN_VALUE;
                }
                tp.nextPosition();
                tp.getPayload(payloadBuffer, 0);
                long uid = ZoieSegmentReader.bytesToLong(payloadBuffer);
                if (uid < this._minUID) {
                    this._minUID = uid;
                }
                if (uid > this._maxUID) {
                    this._maxUID = uid;
                }
                this._uidArray[idx++] = uid;
            }
            while (idx < maxDoc) {
                this._uidArray[idx++] = Long.MIN_VALUE;
            }
        }
        finally {
            if (tp != null) {
                tp.close();
            }
        }
    }

    public static long bytesToLong(byte[] bytes) {
        return (long)(bytes[7] & 0xFF) << 56 | (long)(bytes[6] & 0xFF) << 48 | (long)(bytes[5] & 0xFF) << 40 | (long)(bytes[4] & 0xFF) << 32 | (long)(bytes[3] & 0xFF) << 24 | (long)(bytes[2] & 0xFF) << 16 | (long)(bytes[1] & 0xFF) << 8 | (long)(bytes[0] & 0xFF);
    }

    @Override
    public long getUID(int docid) {
        return this._uidArray[docid];
    }

    public long[] getUIDArray() {
        return this._uidArray;
    }

    @Override
    protected boolean hasIndexDeletions() {
        return this.in.hasDeletions();
    }

    @Override
    public boolean isDeleted(int docid) {
        int[] delSet;
        if (!this._noDedup && (delSet = this._delDocIds) != null && Arrays.binarySearch(delSet, docid) >= 0) {
            return true;
        }
        return this.in.isDeleted(docid);
    }

    public TermDocs termDocs(Term term) throws IOException {
        this.ensureOpen();
        TermDocs td = this.in.termDocs(term);
        if (this._noDedup) {
            return td;
        }
        int[] delDocIds = this._delDocIds;
        if (td == null || delDocIds == null || delDocIds.length == 0) {
            return td;
        }
        return new ZoieSegmentTermDocs(td, new ArrayDocIdSet(delDocIds));
    }

    @Override
    public TermDocs termDocs() throws IOException {
        this.ensureOpen();
        TermDocs td = this.in.termDocs();
        if (this._noDedup) {
            return td;
        }
        int[] delDocIds = this._delDocIds;
        if (td == null || delDocIds == null || delDocIds.length == 0) {
            return td;
        }
        return new ZoieSegmentTermDocs(td, new ArrayDocIdSet(delDocIds));
    }

    public TermPositions termPositions(Term term) throws IOException {
        this.ensureOpen();
        TermPositions tp = this.in.termPositions(term);
        if (this._noDedup) {
            return tp;
        }
        int[] delDocIds = this._delDocIds;
        if (tp == null || delDocIds == null || delDocIds.length == 0) {
            return tp;
        }
        return new ZoieSegmentTermPositions(tp, (DocIdSet)new ArrayDocIdSet(delDocIds));
    }

    @Override
    public TermPositions termPositions() throws IOException {
        this.ensureOpen();
        TermPositions tp = this.in.termPositions();
        if (this._noDedup) {
            return tp;
        }
        int[] delDocIds = this._delDocIds;
        if (tp == null || delDocIds == null || delDocIds.length == 0) {
            return tp;
        }
        return new ZoieSegmentTermPositions(tp, (DocIdSet)new ArrayDocIdSet(delDocIds));
    }

    @Override
    public ZoieIndexReader<R>[] getSequentialSubReaders() {
        return null;
    }

    public String getSegmentName() {
        return ((SegmentReader)this.in).getSegmentName();
    }

    protected synchronized void doClose() throws IOException {
        this._decoratedReader.close();
    }

    public void decRef() throws IOException {
    }

    public int numDocs() {
        if (this._currentDelDocIds != null) {
            return super.maxDoc() - this._currentDelDocIds.length;
        }
        return super.numDocs();
    }

    @Override
    public ZoieSegmentReader<R> copy() throws IOException {
        return new ZoieSegmentReader<R>(this, this.in);
    }

    public void incSegmentRef() {
        this.zoieRefSegmentCounter.incrementAndGet();
    }

    public void decSegmentRef() {
        long refCount = this.zoieRefSegmentCounter.decrementAndGet();
        if (refCount < 0L) {
            throw new IllegalStateException("The segment ref count shouldn't be less than zero");
        }
        if (refCount == 0L) {
            try {
                this.doClose();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class UIDTokenStream
    extends TokenStream {
        private boolean returnToken = false;
        private PayloadAttribute payloadAttr;
        private CharTermAttribute termAttr;

        UIDTokenStream(long uid) {
            byte[] buffer = new byte[]{(byte)uid, (byte)(uid >> 8), (byte)(uid >> 16), (byte)(uid >> 24), (byte)(uid >> 32), (byte)(uid >> 40), (byte)(uid >> 48), (byte)(uid >> 56)};
            this.payloadAttr = (PayloadAttribute)this.addAttribute(PayloadAttribute.class);
            this.payloadAttr.setPayload(new Payload(buffer));
            this.termAttr = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
            this.termAttr.append(ZoieSegmentReader.termVal);
            this.returnToken = true;
        }

        public final boolean incrementToken() throws IOException {
            if (this.returnToken) {
                this.returnToken = false;
                return true;
            }
            return false;
        }
    }
}

