/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.api;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import proj.zoie.api.impl.ZoieContext;

public class ZoieThreadPoolExecutor
extends ThreadPoolExecutor {
    public ZoieThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    public ZoieThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
    }

    public ZoieThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    public ZoieThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        ZoieContext.getContext().clear();
        super.afterExecute(((ZoieRunnable)r).innerRunnable, t);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        if (!(r instanceof ZoieRunnable)) {
            throw new RuntimeException("Not a properly submitted zoie job");
        }
        ZoieContext.setContext(((ZoieRunnable)r).ctx);
        super.beforeExecute(t, ((ZoieRunnable)r).innerRunnable);
    }

    @Override
    public void execute(Runnable command) {
        super.execute(new ZoieRunnable(command));
    }

    protected static class ZoieRunnable
    implements Runnable {
        private final Runnable innerRunnable;
        private final ZoieContext ctx;

        public ZoieRunnable(Runnable runnable) {
            this.innerRunnable = runnable;
            this.ctx = ZoieContext.getContext();
        }

        public ZoieContext getContext() {
            return this.ctx;
        }

        @Override
        public void run() {
            this.innerRunnable.run();
        }
    }
}

