/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.api.impl;

import proj.zoie.api.DocIDMapper;
import proj.zoie.api.DocIDMapperFactory;
import proj.zoie.api.ZoieIndexReader;
import proj.zoie.api.ZoieMultiReader;
import proj.zoie.api.ZoieSegmentReader;
import proj.zoie.api.impl.DocIDMapperImpl;

public class DefaultDocIDMapperFactory
implements DocIDMapperFactory {
    @Override
    public DocIDMapper<?> getDocIDMapper(ZoieMultiReader<?> multireader) {
        ZoieSegmentReader[] subreaders = (ZoieSegmentReader[])multireader.getSequentialSubReaders();
        int[] starts = multireader.getStarts();
        for (int i = 0; i < subreaders.length; ++i) {
            ZoieSegmentReader subReader = subreaders[i];
            DocIDMapperImpl mapper = subReader.getDocIDMaper();
            if (mapper == null) {
                mapper = new DocIDMapperImpl(subReader.getUIDArray());
            }
            subReader.setDocIDMapper(mapper);
        }
        DocIDMapper[] mappers = new DocIDMapper[subreaders.length];
        for (int i = 0; i < subreaders.length; ++i) {
            mappers[i] = subreaders[i].getDocIDMaper();
        }
        int bound = subreaders.length - 1;
        return new DefaultDocIDMapper(bound, mappers, starts);
    }

    public static final class DefaultDocIDMapper
    implements DocIDMapper<DocIDMapper.DocIDArray> {
        private final int bound;
        private final DocIDMapper[] mappers;
        private final int[] starts;

        public DefaultDocIDMapper(int bound, DocIDMapper[] mappers, int[] starts) {
            this.bound = bound;
            this.mappers = mappers;
            this.starts = starts;
        }

        @Override
        public int getDocID(long uid) {
            for (int i = this.bound; i >= 0; --i) {
                int docid = this.mappers[i].getDocID(uid);
                if (docid == -1) continue;
                return docid + this.starts[i];
            }
            return -1;
        }

        @Override
        public DocIDMapper.DocIDArray getDocIDArray(long[] uids) {
            DocIDMapper.DocIDArray ret = DocIDMapper.DocIDArray.newInstance(uids.length);
            int[] docids = ret.docids;
            block0: for (int j = 0; j < uids.length; ++j) {
                for (int i = this.bound; i >= 0; --i) {
                    int docid = this.mappers[i].quickGetDocID(uids[j]);
                    if (docid == -1) continue;
                    docids[j] = docid + this.starts[i];
                    continue block0;
                }
            }
            return ret;
        }

        @Override
        public DocIDMapper.DocIDArray getDocIDArray(int[] uids) {
            DocIDMapper.DocIDArray ret = DocIDMapper.DocIDArray.newInstance(uids.length);
            int[] docids = ret.docids;
            block0: for (int j = 0; j < uids.length; ++j) {
                for (int i = this.bound; i >= 0; --i) {
                    int docid = this.mappers[i].quickGetDocID(uids[j]);
                    if (docid == -1) continue;
                    docids[j] = docid + this.starts[i];
                    continue block0;
                }
            }
            return ret;
        }

        @Override
        public int quickGetDocID(long uid) {
            for (int i = this.bound; i >= 0; --i) {
                int docid = this.mappers[i].quickGetDocID(uid);
                if (docid == -1) continue;
                return docid + this.starts[i];
            }
            return -1;
        }

        @Override
        public int getReaderIndex(long uid) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int[] getStarts() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ZoieIndexReader<?>[] getSubReaders() {
            throw new UnsupportedOperationException();
        }
    }
}

