/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.api.impl;

import java.util.Arrays;
import proj.zoie.api.DocIDMapper;
import proj.zoie.api.ZoieIndexReader;

public class DocIDMapperImpl
implements DocIDMapper<DocIDMapper.DocIDArray> {
    private final int[] _docArray;
    private final long[] _uidArray;
    private final int[] _start;
    private final long[] _filter;
    private final int _mask;
    private static final int MIXER = 2147482951;

    public DocIDMapperImpl(long[] uidArray) {
        int len = uidArray.length;
        int mask = len / 4;
        mask |= mask >> 1;
        mask |= mask >> 2;
        mask |= mask >> 4;
        mask |= mask >> 8;
        mask |= mask >> 16;
        this._mask = mask;
        this._filter = new long[mask + 1];
        for (long uid : uidArray) {
            if (uid == Long.MIN_VALUE) continue;
            int h = (int)(uid >>> 32 ^ uid) * 2147482951;
            long bits = this._filter[h & this._mask];
            bits |= 1L << (h >>> 26);
            this._filter[h & this._mask] = bits |= 1L << (h >> 20 & 0x3F);
        }
        this._start = new int[this._mask + 1 + 1];
        len = 0;
        for (long uid : uidArray) {
            if (uid == Long.MIN_VALUE) continue;
            int n = (int)(uid >>> 32 ^ uid) * 2147482951 & this._mask;
            this._start[n] = this._start[n] + 1;
            ++len;
        }
        int val = 0;
        for (int i = 0; i < this._start.length; ++i) {
            this._start[i] = val += this._start[i];
        }
        this._start[this._mask] = len;
        long[] partitionedUidArray = new long[len];
        int[] docArray = new int[len];
        for (long uid : uidArray) {
            if (uid == Long.MIN_VALUE) continue;
            int n = (int)(uid >>> 32 ^ uid) * 2147482951 & this._mask;
            int n2 = this._start[n] - 1;
            this._start[n] = n2;
            int i = n2;
            partitionedUidArray[i] = uid;
        }
        int s = this._start[0];
        for (int i = 1; i < this._start.length; ++i) {
            int e = this._start[i];
            if (s < e) {
                Arrays.sort(partitionedUidArray, s, e);
            }
            s = e;
        }
        for (int docid = 0; docid < uidArray.length; ++docid) {
            int p;
            int idx;
            long uid = uidArray[docid];
            if (uid == Long.MIN_VALUE || (idx = DocIDMapperImpl.findIndex(partitionedUidArray, uid, this._start[p = (int)(uid >>> 32 ^ uid) * 2147482951 & this._mask], this._start[p + 1])) < 0) continue;
            docArray[idx] = docid;
        }
        this._uidArray = partitionedUidArray;
        this._docArray = docArray;
    }

    @Override
    public int getDocID(long uid) {
        int h = (int)(uid >>> 32 ^ uid) * 2147482951;
        int p = h & this._mask;
        long bits = this._filter[p];
        if ((bits & 1L << (h >>> 26)) == 0L || (bits & 1L << (h >> 20 & 0x3F)) == 0L) {
            return -1;
        }
        int begin = this._start[p];
        int end = this._start[p + 1] - 1;
        int mid;
        long midval;
        while ((midval = this._uidArray[mid = begin + end >>> 1]) != uid) {
            if (mid == end) {
                return -1;
            }
            if (midval < uid) {
                begin = mid + 1;
                continue;
            }
            end = mid;
        }
        return this._docArray[mid];
    }

    private static final int findIndex(long[] arr, long uid, int begin, int end) {
        if (begin >= end) {
            return -1;
        }
        --end;
        int mid;
        long midval;
        while ((midval = arr[mid = begin + end >>> 1]) != uid) {
            if (mid == end) {
                return -1;
            }
            if (midval < uid) {
                begin = mid + 1;
                continue;
            }
            end = mid;
        }
        return mid;
    }

    @Override
    public DocIDMapper.DocIDArray getDocIDArray(long[] uids) {
        DocIDMapper.DocIDArray ret = DocIDMapper.DocIDArray.newInstance(uids.length);
        int[] docids = ret.docids;
        for (int i = 0; i < uids.length; ++i) {
            docids[i] = this.getDocID(uids[i]);
        }
        return ret;
    }

    @Override
    public DocIDMapper.DocIDArray getDocIDArray(int[] uids) {
        DocIDMapper.DocIDArray ret = DocIDMapper.DocIDArray.newInstance(uids.length);
        int[] docids = ret.docids;
        for (int i = 0; i < uids.length; ++i) {
            docids[i] = this.getDocID(uids[i]);
        }
        return ret;
    }

    @Override
    public int quickGetDocID(long uid) {
        int h = (int)(uid >>> 32 ^ uid) * 2147482951;
        int p = h & this._mask;
        long bits = this._filter[p];
        if ((bits & 1L << (h >>> 26)) == 0L || (bits & 1L << (h >> 20 & 0x3F)) == 0L) {
            return -1;
        }
        int begin = this._start[p];
        int end = this._start[p + 1] - 1;
        int mid;
        long midval;
        while ((midval = this._uidArray[mid = begin + end >>> 1]) != uid) {
            if (mid == end) {
                return -1;
            }
            if (midval < uid) {
                begin = mid + 1;
                continue;
            }
            end = mid;
        }
        return this._docArray[mid];
    }

    public int[] getDocArray() {
        return this._docArray;
    }

    @Override
    public int getReaderIndex(long uid) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] getStarts() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ZoieIndexReader<?>[] getSubReaders() {
        throw new UnsupportedOperationException();
    }
}

