/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.api.impl;

import java.util.Arrays;
import org.apache.log4j.Logger;
import proj.zoie.api.DocIDMapper;
import proj.zoie.api.DocIDMapperFactory;
import proj.zoie.api.ZoieIndexReader;
import proj.zoie.api.ZoieMultiReader;
import proj.zoie.api.ZoieSegmentReader;
import proj.zoie.api.impl.DocIDMapperImpl;

public class InRangeDocIDMapperFactory
implements DocIDMapperFactory {
    private static final Logger log = Logger.getLogger(InRangeDocIDMapperFactory.class);
    private final long _partStart;
    private final int _count;
    private static final int DEFAULT_RAM_COUNT_THRESHOLD = 100000;
    private final int RAM_COUNT_THRESHOLD;

    public InRangeDocIDMapperFactory(long start, int count) {
        if (start < 0L || count < 0) {
            throw new IllegalArgumentException("invalid range: [" + start + "," + count + "]");
        }
        this._partStart = start;
        this._count = count;
        this.RAM_COUNT_THRESHOLD = 100000;
    }

    public InRangeDocIDMapperFactory(long start, int count, int ram_count_threshold) {
        if (start < 0L || count < 0) {
            throw new IllegalArgumentException("invalid range: [" + start + "," + count + "]");
        }
        this._partStart = start;
        this._count = count;
        this.RAM_COUNT_THRESHOLD = ram_count_threshold;
    }

    public DocIDMapper<DocIDMapper.DocIDArray> getDocIDMapper(ZoieMultiReader<?> reader) {
        int docCount = reader.maxDoc();
        ZoieSegmentReader[] subreaders = (ZoieSegmentReader[])reader.getSequentialSubReaders();
        int[] starts = reader.getStarts();
        if (docCount > this.RAM_COUNT_THRESHOLD) {
            int[] docidArray = new int[this._count];
            int[] subReaderIndex = new int[this._count];
            Arrays.fill(docidArray, -1);
            Arrays.fill(subReaderIndex, -1);
            for (int i = 0; i < subreaders.length; ++i) {
                long[] subuidarray = subreaders[i].getUIDArray();
                int start = starts[i];
                ZoieSegmentReader subreader = subreaders[i];
                for (int k = 0; k < subuidarray.length; ++k) {
                    long subid = subuidarray[k];
                    if (subid == Long.MIN_VALUE) continue;
                    int local_uid = (int)(subid - this._partStart);
                    if (local_uid < 0 || local_uid >= docidArray.length) {
                        log.error((Object)("Local UID outof range for localUID: " + local_uid + " _start: " + this._partStart + " _count: " + this._count + " " + subid));
                    }
                    docidArray[local_uid] = k + start;
                    subReaderIndex[local_uid] = i;
                }
                subreader.setDocIDMapper(new DocIDMapperSub(i, subreader, this._partStart, docidArray, start));
            }
            return new DocIDMapperGlobal(this._partStart, docidArray, subreaders, starts, subReaderIndex);
        }
        for (int i = 0; i < subreaders.length; ++i) {
            ZoieSegmentReader subReader = subreaders[i];
            DocIDMapperImpl mapper = subReader.getDocIDMaper();
            if (mapper == null) {
                mapper = new DocIDMapperImpl(subReader.getUIDArray());
            }
            subReader.setDocIDMapper(mapper);
        }
        return new DocIDMapperSmall(subreaders, starts);
    }

    public static final class DocIDMapperSmall
    implements DocIDMapper<DocIDMapper.DocIDArray> {
        final ZoieSegmentReader<?>[] subreaders;
        final int[] starts;
        final DocIDMapper<?>[] mappers;
        final int bound;

        public DocIDMapperSmall(ZoieSegmentReader<?>[] subreaders, int[] starts) {
            this.subreaders = subreaders;
            this.starts = starts;
            this.mappers = new DocIDMapper[subreaders.length];
            for (int i = subreaders.length - 1; i >= 0; --i) {
                ZoieSegmentReader<?> subReader = subreaders[i];
                this.mappers[i] = subReader.getDocIDMaper();
            }
            this.bound = subreaders.length - 1;
        }

        @Override
        public final int getDocID(long uid) {
            for (int i = this.bound; i >= 0; --i) {
                int docid = this.mappers[i].getDocID(uid);
                if (docid == -1) continue;
                return docid + this.starts[i];
            }
            return -1;
        }

        @Override
        public DocIDMapper.DocIDArray getDocIDArray(long[] uids) {
            DocIDMapper.DocIDArray ret = DocIDMapper.DocIDArray.newInstance(uids.length);
            int[] docids = ret.docids;
            block0: for (int j = 0; j < uids.length; ++j) {
                for (int i = this.bound; i >= 0; --i) {
                    int docid = this.mappers[i].quickGetDocID(uids[j]);
                    if (docid == -1) continue;
                    docids[j] = docid + this.starts[i];
                    continue block0;
                }
            }
            return ret;
        }

        @Override
        public DocIDMapper.DocIDArray getDocIDArray(int[] uids) {
            DocIDMapper.DocIDArray ret = DocIDMapper.DocIDArray.newInstance(uids.length);
            int[] docids = ret.docids;
            block0: for (int j = 0; j < uids.length; ++j) {
                for (int i = this.bound; i >= 0; --i) {
                    int docid = this.mappers[i].quickGetDocID(uids[j]);
                    if (docid == -1) continue;
                    docids[j] = docid + this.starts[i];
                    continue block0;
                }
            }
            return ret;
        }

        @Override
        public int quickGetDocID(long uid) {
            for (int i = this.bound; i >= 0; --i) {
                int docid = this.mappers[i].quickGetDocID(uid);
                if (docid == -1) continue;
                return docid + this.starts[i];
            }
            return -1;
        }

        @Override
        public int getReaderIndex(long uid) {
            for (int i = this.bound; i >= 0; --i) {
                int docid = this.mappers[i].getDocID(uid);
                if (docid == -1) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int[] getStarts() {
            return (int[])this.starts.clone();
        }

        @Override
        public ZoieIndexReader<?>[] getSubReaders() {
            return this.subreaders;
        }
    }

    public static final class DocIDMapperGlobal
    implements DocIDMapper<DocIDMapper.DocIDArray> {
        final long _partiStart;
        final int[] uidArray;
        final int[] subreaderindex;
        final ZoieSegmentReader<?>[] subreaders;
        final int[] starts;

        public DocIDMapperGlobal(long partiStart, int[] uidArray, ZoieSegmentReader<?>[] subreaders, int[] starts, int[] subreaderindex) {
            this._partiStart = partiStart;
            this.uidArray = uidArray;
            this.subreaderindex = subreaderindex;
            this.subreaders = subreaders;
            this.starts = starts;
        }

        @Override
        public final int getDocID(long uid) {
            if ((long)((int)uid) < this._partiStart) {
                return -1;
            }
            int idx = (int)(uid - this._partiStart);
            if (idx < this.uidArray.length) {
                return this.uidArray[idx];
            }
            return -1;
        }

        @Override
        public DocIDMapper.DocIDArray getDocIDArray(long[] uids) {
            DocIDMapper.DocIDArray ret = DocIDMapper.DocIDArray.newInstance(uids.length);
            int[] docids = ret.docids;
            for (int j = 0; j < uids.length; ++j) {
                int idx = (int)(uids[j] - this._partiStart);
                if (idx >= this.uidArray.length) continue;
                docids[j] = this.uidArray[idx];
            }
            return ret;
        }

        @Override
        public DocIDMapper.DocIDArray getDocIDArray(int[] uids) {
            DocIDMapper.DocIDArray ret = DocIDMapper.DocIDArray.newInstance(uids.length);
            int[] docids = ret.docids;
            for (int j = 0; j < uids.length; ++j) {
                int idx = (int)((long)uids[j] - this._partiStart);
                if (idx >= this.uidArray.length) continue;
                docids[j] = this.uidArray[idx];
            }
            return ret;
        }

        @Override
        public int quickGetDocID(long uid) {
            int idx = (int)(uid - this._partiStart);
            if (idx < this.uidArray.length) {
                return this.uidArray[idx];
            }
            return -1;
        }

        @Override
        public int getReaderIndex(long uid) {
            if ((long)((int)uid) < this._partiStart) {
                return -1;
            }
            int idx = (int)(uid - this._partiStart);
            if (idx < this.uidArray.length) {
                return this.subreaderindex[idx];
            }
            return -1;
        }

        @Override
        public int[] getStarts() {
            return this.starts;
        }

        @Override
        public ZoieIndexReader<?>[] getSubReaders() {
            return this.subreaders;
        }
    }

    public static final class DocIDMapperSub
    implements DocIDMapper<DocIDMapper.DocIDArray> {
        final int max;
        final int[] uidArray;
        final int uidArrayLength;
        final long maxbdd;
        final int start;
        final long _partiStart;
        final int id;
        final ZoieSegmentReader<?> subReader;

        public DocIDMapperSub(int id, ZoieSegmentReader<?> subreader, long _partStart, int[] uidArray, int start) {
            this.subReader = subreader;
            this.max = subreader.maxDoc() + start;
            this._partiStart = _partStart;
            this.uidArray = uidArray;
            this.uidArrayLength = uidArray.length;
            this.maxbdd = (long)this.uidArrayLength + _partStart;
            this.start = start;
            this.id = id;
        }

        @Override
        public final int getDocID(long uid) {
            if (uid < this._partiStart || uid >= this.maxbdd) {
                return -1;
            }
            int mapped = this.uidArray[(int)(uid - this._partiStart)];
            if (mapped != -1) {
                if (mapped >= this.max) {
                    return -1;
                }
                return mapped - this.start;
            }
            return mapped;
        }

        @Override
        public DocIDMapper.DocIDArray getDocIDArray(long[] uids) {
            DocIDMapper.DocIDArray ret = DocIDMapper.DocIDArray.newInstance(uids.length);
            int[] docids = ret.docids;
            for (int j = 0; j < uids.length; ++j) {
                int mapped = this.uidArray[(int)(uids[j] - this._partiStart)];
                if (mapped == -1 || mapped >= this.max) continue;
                docids[j] = mapped - this.start;
            }
            return ret;
        }

        @Override
        public DocIDMapper.DocIDArray getDocIDArray(int[] uids) {
            DocIDMapper.DocIDArray ret = DocIDMapper.DocIDArray.newInstance(uids.length);
            int[] docids = ret.docids;
            for (int j = 0; j < uids.length; ++j) {
                int mapped = this.uidArray[(int)((long)uids[j] - this._partiStart)];
                if (mapped == -1 || mapped >= this.max) continue;
                docids[j] = mapped - this.start;
            }
            return ret;
        }

        @Override
        public int quickGetDocID(long uid) {
            int mapped = this.uidArray[(int)(uid - this._partiStart)];
            if (mapped != -1) {
                if (mapped >= this.max) {
                    return -1;
                }
                return mapped - this.start;
            }
            return mapped;
        }

        @Override
        public int getReaderIndex(long uid) {
            return 0;
        }

        @Override
        public int[] getStarts() {
            return new int[]{0};
        }

        @Override
        public ZoieIndexReader<?>[] getSubReaders() {
            return new ZoieIndexReader[]{this.subReader};
        }
    }
}

