/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.api.impl;

import java.util.Map;
import java.util.WeakHashMap;
import proj.zoie.api.ZoieIndexReader;
import proj.zoie.api.impl.ZoieReaderContext;

public class ZoieContext {
    private static InheritableThreadLocal<ZoieContext> _context = new InheritableThreadLocal<ZoieContext>(){

        @Override
        protected ZoieContext childValue(ZoieContext parentValue) {
            return parentValue.clone();
        }

        @Override
        protected ZoieContext initialValue() {
            return new ZoieContext();
        }
    };
    protected WeakHashMap<ZoieIndexReader<?>, ZoieReaderContext> _zoieContextMap = new WeakHashMap();

    public static ZoieContext getContext() {
        return (ZoieContext)_context.get();
    }

    public static void setContext(ZoieContext context) {
        _context.set(context.clone());
    }

    public synchronized ZoieReaderContext getReaderContext(ZoieIndexReader<?> reader) {
        ZoieReaderContext ctx = this._zoieContextMap.get(reader);
        if (ctx == null) {
            ctx = new ZoieReaderContext();
            this._zoieContextMap.put(reader, ctx);
        }
        return ctx;
    }

    protected ZoieContext clone() {
        ZoieContext ctx = new ZoieContext();
        for (Map.Entry<ZoieIndexReader<?>, ZoieReaderContext> pair : this._zoieContextMap.entrySet()) {
            ctx._zoieContextMap.put(pair.getKey(), pair.getValue().clone());
        }
        return ctx;
    }

    public synchronized void clear() {
        this._zoieContextMap.clear();
    }
}

