/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.api.impl;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;

public class ZoieMergePolicy
extends LogByteSizeMergePolicy {
    public static final Logger log = Logger.getLogger((String)ZoieMergePolicy.class.getName());
    public static final int DEFAULT_NUM_LARGE_SEGMENTS = 6;
    public static final int DEFAULT_NUM_SMALL_SEGMENTS = 7;
    public static final int DEFAULT_MERGE_FACTOR = 6;
    private boolean _partialExpunge = false;
    private int _numLargeSegments = 6;
    private int _maxSmallSegments = 7;
    private int _maxSegments = this._numLargeSegments + this._maxSmallSegments;

    public ZoieMergePolicy() {
        super.setMergeFactor(6);
    }

    public void setMergePolicyParams(MergePolicyParams params) {
        if (params != null) {
            this.setPartialExpunge(params._doPartialExpunge);
            this.setNumLargeSegments(params._numLargeSegments);
            this.setMergeFactor(params._mergeFactor);
            this.setMaxSmallSegments(params._maxSmallSegments);
            this.setUseCompoundFile(params._useCompoundFile);
            this.setMaxMergeDocs(params._maxMergeDocs);
        }
    }

    protected long size(SegmentInfo info) throws IOException {
        long byteSize = info.sizeInBytes(false);
        float delRatio = info.docCount <= 0 ? 0.0f : (float)info.getDelCount() / (float)info.docCount;
        return info.docCount <= 0 ? byteSize : (long)((float)byteSize * (1.0f - delRatio));
    }

    public void setPartialExpunge(boolean doPartialExpunge) {
        this._partialExpunge = doPartialExpunge;
    }

    public boolean getPartialExpunge() {
        return this._partialExpunge;
    }

    public void setNumLargeSegments(int numLargeSegments) {
        if (numLargeSegments < 2) {
            log.warn((Object)("numLargeSegments cannot be less than 2, while " + numLargeSegments + " is requested. Override with 2."));
            numLargeSegments = 2;
        }
        this._numLargeSegments = numLargeSegments;
        this._maxSegments = this._numLargeSegments + 2 * this.getMergeFactor();
    }

    public int getNumLargeSegments() {
        return this._numLargeSegments;
    }

    public void setMaxSmallSegments(int maxSmallSegments) {
        if (maxSmallSegments < this.getMergeFactor() + 1) {
            log.warn((Object)("MergeFactor is " + this.getMergeFactor() + ". maxSmallSegments is requested to be: " + maxSmallSegments + ". Override with mergeFactor + 1, since maxSmallSegments has to be greater than mergeFactor."));
            maxSmallSegments = this.getMergeFactor() + 1;
        }
        this._maxSmallSegments = maxSmallSegments;
        this._maxSegments = this._numLargeSegments + this._maxSmallSegments;
    }

    public int getMaxSmallSegments() {
        return this._maxSmallSegments;
    }

    public void setMergeFactor(int mergeFactor) {
        if (mergeFactor < 2) {
            log.warn((Object)("mergeFactor has to be at least 2. Override " + mergeFactor + " with 2"));
            mergeFactor = 2;
        }
        super.setMergeFactor(mergeFactor);
        if (this._maxSmallSegments < this.getMergeFactor()) {
            log.warn((Object)("maxSmallSegments has to be greater than mergeFactor. Override maxSmallSegments to: " + (mergeFactor + 1)));
            this._maxSmallSegments = this.getMergeFactor() + 1;
            this._maxSegments = this._numLargeSegments + this._maxSmallSegments;
        }
    }

    protected boolean isMerged(SegmentInfos infos, int maxNumSegments, Map<SegmentInfo, Boolean> segmentsToOptimize) throws IOException {
        int numSegments = infos.size();
        int numToOptimize = 0;
        SegmentInfo optimizeInfo = null;
        for (int i = 0; i < numSegments && numToOptimize <= maxNumSegments; ++i) {
            SegmentInfo info = infos.info(i);
            if (!segmentsToOptimize.get(info).booleanValue()) continue;
            ++numToOptimize;
            optimizeInfo = info;
        }
        return numToOptimize <= maxNumSegments && (numToOptimize != 1 || this.isMerged(optimizeInfo));
    }

    protected boolean isMerged(SegmentInfo info) throws IOException {
        IndexWriter w = (IndexWriter)this.writer.get();
        return !info.hasDeletions() && !info.hasSeparateNorms() && info.dir == w.getDirectory() && info.getUseCompoundFile() == this.getUseCompoundFile();
    }

    public MergePolicy.MergeSpecification findForcedMerges(SegmentInfos infos, int maxNumSegments, Map<SegmentInfo, Boolean> segmentsToOptimize) throws IOException {
        assert (maxNumSegments > 0);
        MergePolicy.MergeSpecification spec = null;
        if (!this.isMerged(infos, maxNumSegments, segmentsToOptimize)) {
            int last = infos.size();
            while (last > 0) {
                SegmentInfo info;
                if (!segmentsToOptimize.get(info = infos.info(--last)).booleanValue()) continue;
                ++last;
                break;
            }
            if (last > 0) {
                if (maxNumSegments == 1) {
                    if (last > 1 || !this.isMerged(infos.info(0))) {
                        spec = new MergePolicy.MergeSpecification();
                        spec.add(new MergePolicy.OneMerge(infos.asList().subList(0, last)));
                    }
                } else if (last > maxNumSegments) {
                    spec = this.findBalancedMerges(infos, last, maxNumSegments, this._partialExpunge);
                }
            }
        }
        return spec;
    }

    private MergePolicy.MergeSpecification findBalancedMerges(SegmentInfos infos, int infoLen, int maxNumSegments, boolean partialExpunge) throws IOException {
        int i;
        if (infoLen <= maxNumSegments) {
            return null;
        }
        MergePolicy.MergeSpecification spec = new MergePolicy.MergeSpecification();
        double[][] variance = this.createVarianceTable(infos, infoLen, maxNumSegments);
        int maxMergeSegments = infoLen - maxNumSegments + 1;
        double[] sumVariance = new double[maxMergeSegments];
        int[][] backLink = new int[maxNumSegments][maxMergeSegments];
        for (i = maxMergeSegments - 1; i >= 0; --i) {
            sumVariance[i] = variance[0][i];
            backLink[0][i] = 0;
        }
        for (i = 1; i < maxNumSegments; ++i) {
            for (int j = maxMergeSegments - 1; j >= 0; --j) {
                double minV = Double.MAX_VALUE;
                int minK = 0;
                for (int k = j; k >= 0; --k) {
                    double v = sumVariance[k] + variance[i + k][j - k];
                    if (!(v < minV)) continue;
                    minV = v;
                    minK = k;
                }
                sumVariance[j] = minV;
                backLink[i][j] = minK;
            }
        }
        int mergeEnd = infoLen;
        int prev = maxMergeSegments - 1;
        int expungeCandidate = -1;
        int maxDelCount = 0;
        for (int i2 = maxNumSegments - 1; i2 >= 0; --i2) {
            SegmentInfo info;
            int delCount;
            int mergeStart = i2 + (prev = backLink[i2][prev]);
            if (mergeEnd - mergeStart > 1) {
                spec.add(new MergePolicy.OneMerge(infos.asList().subList(mergeStart, mergeEnd)));
            } else if (partialExpunge && (delCount = (info = infos.info(mergeStart)).getDelCount()) > maxDelCount) {
                expungeCandidate = mergeStart;
                maxDelCount = delCount;
            }
            mergeEnd = mergeStart;
        }
        if (partialExpunge && maxDelCount > 0) {
            spec.add(new MergePolicy.OneMerge(infos.asList().subList(expungeCandidate, expungeCandidate + 1)));
        }
        return spec;
    }

    private double[][] createVarianceTable(SegmentInfos infos, int last, int maxNumSegments) throws IOException {
        int i;
        int maxMergeSegments = last - maxNumSegments + 1;
        double[][] variance = new double[last][maxMergeSegments];
        long optSize = 0L;
        long[] sizeArr = new long[last];
        for (i = 0; i < sizeArr.length; ++i) {
            sizeArr[i] = this.size(infos.info(i));
            optSize += sizeArr[i];
        }
        optSize /= (long)maxNumSegments;
        for (i = 0; i < last; ++i) {
            long size = 0L;
            for (int j = 0; j < maxMergeSegments; ++j) {
                if (i + j < last) {
                    double residual = (double)(size += sizeArr[i + j]) / (double)optSize - 1.0;
                    variance[i][j] = residual * residual;
                    continue;
                }
                variance[i][j] = Double.NaN;
            }
        }
        return variance;
    }

    public MergePolicy.MergeSpecification findForcedDeletesMerges(SegmentInfos infos) throws CorruptIndexException, IOException {
        int numSegs = infos.size();
        int numLargeSegs = numSegs < this._numLargeSegments ? numSegs : this._numLargeSegments;
        MergePolicy.MergeSpecification spec = null;
        if (numLargeSegs < numSegs) {
            List smallSegmentList = infos.asList().subList(numLargeSegs, numSegs);
            SegmentInfos smallSegments = new SegmentInfos();
            smallSegments.addAll(smallSegmentList);
            spec = super.findForcedDeletesMerges(smallSegments);
        }
        if (spec == null) {
            spec = new MergePolicy.MergeSpecification();
        }
        for (int i = 0; i < numLargeSegs; ++i) {
            SegmentInfo info = infos.info(i);
            if (!info.hasDeletions()) continue;
            spec.add(new MergePolicy.OneMerge(infos.asList().subList(i, i + 1)));
        }
        return spec;
    }

    public MergePolicy.MergeSpecification findMerges(SegmentInfos infos) throws IOException {
        MergePolicy.OneMerge expunge;
        SegmentInfo info;
        int i;
        int numLargeSegs;
        int numSegs = infos.size();
        if (numSegs <= (numLargeSegs = this._numLargeSegments)) {
            return null;
        }
        long totalLargeSegSize = 0L;
        long totalSmallSegSize = 0L;
        for (i = 0; i < numLargeSegs; ++i) {
            info = infos.info(i);
            totalLargeSegSize += this.size(info);
        }
        for (i = numLargeSegs; i < numSegs; ++i) {
            info = infos.info(i);
            totalSmallSegSize += this.size(info);
        }
        long targetSegSize = totalLargeSegSize / (long)(numLargeSegs - 1);
        if (targetSegSize <= totalSmallSegSize) {
            if (totalSmallSegSize < targetSegSize * 2L) {
                MergePolicy.MergeSpecification spec = this.findBalancedMerges(infos, numLargeSegs, numLargeSegs - 1, this._partialExpunge);
                if (spec == null) {
                    spec = new MergePolicy.MergeSpecification();
                }
                spec.add(new MergePolicy.OneMerge(infos.asList().subList(numLargeSegs, numSegs)));
                return spec;
            }
            return this.findBalancedMerges(infos, numSegs, numLargeSegs, this._partialExpunge);
        }
        if (this._maxSegments < numSegs) {
            int startSeg;
            MergePolicy.MergeSpecification spec = new MergePolicy.MergeSpecification();
            long sizeThreshold = targetSegSize / 4L;
            for (startSeg = numLargeSegs; startSeg < numSegs && this.size(info = infos.info(startSeg)) >= sizeThreshold; ++startSeg) {
            }
            spec.add(new MergePolicy.OneMerge(infos.asList().subList(startSeg, numSegs)));
            return spec;
        }
        List smallSegmentList = infos.asList().subList(numLargeSegs, numSegs);
        SegmentInfos smallSegments = new SegmentInfos();
        smallSegments.addAll(smallSegmentList);
        MergePolicy.MergeSpecification spec = super.findMerges(smallSegments);
        if (this._partialExpunge && (expunge = this.findOneSegmentToExpunge(infos, numLargeSegs)) != null) {
            if (spec == null) {
                spec = new MergePolicy.MergeSpecification();
            }
            spec.add(expunge);
        }
        return spec;
    }

    private MergePolicy.OneMerge findOneSegmentToExpunge(SegmentInfos infos, int maxNumSegments) throws IOException {
        int expungeCandidate = -1;
        int maxDelCount = 0;
        for (int i = maxNumSegments - 1; i >= 0; --i) {
            SegmentInfo info = infos.info(i);
            int delCount = info.getDelCount();
            if (delCount <= maxDelCount) continue;
            expungeCandidate = i;
            maxDelCount = delCount;
        }
        if (maxDelCount > 0) {
            return new MergePolicy.OneMerge(infos.asList().subList(expungeCandidate, expungeCandidate + 1));
        }
        return null;
    }

    public static class MergePolicyParams {
        public static final Logger log = Logger.getLogger((String)MergePolicyParams.class.getName());
        private int _numLargeSegments = 6;
        private int _maxSmallSegments = 7;
        private boolean _doPartialExpunge = false;
        private int _mergeFactor = 6;
        private boolean _useCompoundFile = false;
        private int _maxMergeDocs = Integer.MAX_VALUE;

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("useCompoundFile: ").append(this._useCompoundFile);
            sb.append(", doPartialExpunge: ").append(this._doPartialExpunge);
            sb.append(", numLargeSegments: ").append(this._numLargeSegments);
            sb.append(", maxSmallSegments: ").append(this._maxSmallSegments);
            sb.append(", mergeFactor: ").append(this._mergeFactor);
            sb.append(", maxMergeDocs: ").append(this._maxMergeDocs);
            return sb.toString();
        }

        public synchronized void setNumLargeSegments(int numLargeSegments) {
            if (numLargeSegments < 2) {
                log.warn((Object)("numLargeSegments cannot be less than 2, while " + numLargeSegments + " is requested. Override with 2."));
                numLargeSegments = 2;
            }
            this._numLargeSegments = numLargeSegments;
            log.info((Object)this.toString());
        }

        public synchronized int getNumLargeSegments() {
            return this._numLargeSegments;
        }

        public synchronized void setMaxSmallSegments(int maxSmallSegments) {
            if (maxSmallSegments < this.getMergeFactor() + 1) {
                log.warn((Object)("MergeFactor is " + this.getMergeFactor() + ". maxSmallSegments is requested to be: " + maxSmallSegments + ". Override with mergeFactor + 1, since maxSmallSegments has to be greater than mergeFactor."));
                maxSmallSegments = this.getMergeFactor() + 1;
            }
            this._maxSmallSegments = maxSmallSegments;
            log.info((Object)this.toString());
        }

        public synchronized int getMaxSmallSegments() {
            return this._maxSmallSegments;
        }

        public synchronized void setPartialExpunge(boolean doPartialExpunge) {
            this._doPartialExpunge = doPartialExpunge;
            log.info((Object)this.toString());
        }

        public synchronized boolean getPartialExpunge() {
            return this._doPartialExpunge;
        }

        public synchronized void setMergeFactor(int mergeFactor) {
            if (mergeFactor < 2) {
                log.warn((Object)("mergeFactor has to be at least 2. Override " + mergeFactor + " with 2"));
                mergeFactor = 2;
            }
            this._mergeFactor = mergeFactor;
            if (this._maxSmallSegments < this.getMergeFactor()) {
                log.warn((Object)("maxSmallSegments has to be greater than mergeFactor. Override maxSmallSegments to: " + (mergeFactor + 1)));
                this._maxSmallSegments = this.getMergeFactor() + 1;
            }
            log.info((Object)this.toString());
        }

        public synchronized int getMergeFactor() {
            return this._mergeFactor;
        }

        public synchronized void setMaxMergeDocs(int maxMergeDocs) {
            this._maxMergeDocs = maxMergeDocs;
            log.info((Object)this.toString());
        }

        public synchronized int getMaxMergeDocs() {
            return this._maxMergeDocs;
        }

        public synchronized void setUseCompoundFile(boolean useCompoundFile) {
            this._useCompoundFile = useCompoundFile;
            log.info((Object)this.toString());
        }

        public synchronized boolean isUseCompoundFile() {
            return this._useCompoundFile;
        }
    }
}

