/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.api.impl.util;

import java.io.IOException;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;

public class ArrayDocIdSet
extends DocIdSet {
    private final int[] _docids;
    private final int _lengthminusone;

    public ArrayDocIdSet(int[] docids) {
        this._docids = docids;
        this._lengthminusone = docids != null ? docids.length - 1 : -1;
    }

    private static final int binarySearch(int[] a, int key) {
        return ArrayDocIdSet.binarySearch(a, key, 0, a.length - 1);
    }

    private static final int binarySearch(int[] a, int key, int low, int high) {
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = a[mid];
            int cmp = midVal - key;
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public DocIdSetIterator iterator() {
        return new DocIdSetIterator(){
            int doc = -1;
            int current = -1;
            int largest = ArrayDocIdSet.access$000(ArrayDocIdSet.this);

            public int docID() {
                return this.doc;
            }

            public int nextDoc() throws IOException {
                if (this.current < ArrayDocIdSet.this._lengthminusone) {
                    ++this.current;
                    this.doc = ArrayDocIdSet.this._docids[this.current];
                    return this.doc;
                }
                return Integer.MAX_VALUE;
            }

            public int advance(int target) throws IOException {
                int idx;
                int n = idx = this.current < 0 ? ArrayDocIdSet.binarySearch(ArrayDocIdSet.this._docids, target) : ArrayDocIdSet.binarySearch(ArrayDocIdSet.this._docids, target, this.current, this.largest);
                if (idx < 0 && (idx = -(idx + 1)) >= ArrayDocIdSet.this._docids.length) {
                    return Integer.MAX_VALUE;
                }
                this.current = idx;
                this.doc = ArrayDocIdSet.this._docids[this.current];
                return this.doc;
            }
        };
    }
}

