/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.api.impl.util;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.Iterator;

public class IntSetAccelerator
implements IntSet {
    private final long[] _filter;
    private final int _mask;
    private final IntSet _set;
    private static final int MIXER = 2147482951;

    public IntSetAccelerator(IntSet set) {
        this._set = set;
        int mask = set.size() / 4;
        mask |= mask >> 1;
        mask |= mask >> 2;
        mask |= mask >> 4;
        mask |= mask >> 8;
        mask |= mask >> 16;
        this._mask = mask;
        this._filter = new long[mask + 1];
        IntIterator iter = set.iterator();
        while (iter.hasNext()) {
            int h = iter.nextInt() * 2147482951;
            long bits = this._filter[h & this._mask];
            bits |= 1L << (h >>> 26);
            this._filter[h & this._mask] = bits |= 1L << (h >> 20 & 0x3F);
        }
    }

    public boolean contains(int val) {
        int h = val * 2147482951;
        long bits = this._filter[h & this._mask];
        return (bits & 1L << (h >>> 26)) != 0L && (bits & 1L << (h >> 20 & 0x3F)) != 0L && this._set.contains(val);
    }

    public boolean contains(Object o) {
        return this.contains((Integer)o);
    }

    public boolean containsAll(Collection<?> c) {
        Iterator<?> i = c.iterator();
        int n = c.size();
        while (n-- != 0) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(IntCollection c) {
        IntIterator i = c.iterator();
        int n = c.size();
        while (n-- != 0) {
            if (this.contains(i.nextInt())) continue;
            return false;
        }
        return true;
    }

    public boolean add(int key) {
        throw new UnsupportedOperationException();
    }

    public boolean add(Integer o) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection<? extends Integer> c) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(IntCollection c) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        return this._set.equals(o);
    }

    public int hashCode() {
        return this._set.hashCode();
    }

    public IntIterator intIterator() {
        return this._set.iterator();
    }

    public boolean isEmpty() {
        return this._set.isEmpty();
    }

    public IntIterator iterator() {
        return this._set.iterator();
    }

    public boolean rem(int key) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(int key) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(IntCollection c) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(IntCollection c) {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return this._set.size();
    }

    public Object[] toArray() {
        return this._set.toArray();
    }

    public int[] toArray(int[] a) {
        return this._set.toArray(a);
    }

    public <T> T[] toArray(T[] a) {
        return this._set.toArray((Object[])a);
    }

    public int[] toIntArray() {
        return this._set.toIntArray();
    }

    public int[] toIntArray(int[] a) {
        return this._set.toIntArray(a);
    }
}

