/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.api.impl.util;

import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Collection;
import java.util.Iterator;

public class LongSetAccelerator
implements LongSet {
    private final long[] _filter;
    private final int _mask;
    private final LongSet _set;
    private static final int MIXER = 2147482951;

    public LongSetAccelerator(LongSet set) {
        this._set = set;
        int mask = set.size() / 4;
        mask |= mask >> 1;
        mask |= mask >> 2;
        mask |= mask >> 4;
        mask |= mask >> 8;
        mask |= mask >> 16;
        this._mask = mask;
        this._filter = new long[mask + 1];
        LongIterator iter = set.iterator();
        while (iter.hasNext()) {
            long l = iter.nextLong();
            int h = (int)(l >>> 32 ^ l) * 2147482951;
            long bits = this._filter[h & this._mask];
            bits |= 1L << (h >>> 26);
            this._filter[h & this._mask] = bits |= 1L << (h >> 20 & 0x3F);
        }
    }

    public boolean contains(long val) {
        int h = (int)(val >>> 32 ^ val) * 2147482951;
        long bits = this._filter[h & this._mask];
        return (bits & 1L << (h >>> 26)) != 0L && (bits & 1L << (h >> 20 & 0x3F)) != 0L && this._set.contains(val);
    }

    public boolean contains(Object o) {
        return this.contains((Long)o);
    }

    public boolean containsAll(Collection<?> c) {
        Iterator<?> i = c.iterator();
        int n = c.size();
        while (n-- != 0) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(LongCollection c) {
        LongIterator i = c.iterator();
        int n = c.size();
        while (n-- != 0) {
            if (this.contains(i.nextLong())) continue;
            return false;
        }
        return true;
    }

    public boolean add(long key) {
        throw new UnsupportedOperationException();
    }

    public boolean add(Long o) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection<? extends Long> c) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(LongCollection c) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        return this._set.equals(o);
    }

    public int hashCode() {
        return this._set.hashCode();
    }

    public LongIterator longIterator() {
        return this._set.iterator();
    }

    public boolean isEmpty() {
        return this._set.isEmpty();
    }

    public LongIterator iterator() {
        return this._set.iterator();
    }

    public boolean rem(long key) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(long key) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(LongCollection c) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(LongCollection c) {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return this._set.size();
    }

    public Object[] toArray() {
        return this._set.toArray();
    }

    public long[] toArray(long[] a) {
        return this._set.toArray(a);
    }

    public <T> T[] toArray(T[] a) {
        return this._set.toArray((Object[])a);
    }

    public long[] toLongArray() {
        return this._set.toLongArray();
    }

    public long[] toLongArray(long[] a) {
        return this._set.toLongArray(a);
    }
}

