/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.api.impl.util;

import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class MemoryManager<T> {
    private static final Logger log = Logger.getLogger((String)MemoryManager.class.getName());
    private final ConcurrentHashMap<Integer, ConcurrentLinkedQueue<WeakReference<T>>> _sizeMap = new ConcurrentHashMap();
    private final ConcurrentLinkedQueue<T> _releaseQueue = new ConcurrentLinkedQueue();
    private final AtomicInteger _releaseQueueSize = new AtomicInteger(0);
    private Initializer<T> _initializer;
    private final Thread _cleanThread;

    public MemoryManager(Initializer<T> initializer) {
        this._initializer = initializer;
        this._cleanThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object buf = null;
                while (true) {
                    MemoryManager memoryManager = MemoryManager.this;
                    synchronized (memoryManager) {
                        try {
                            MemoryManager.this.wait(200L);
                        }
                        catch (InterruptedException e) {
                            log.error((Object)e);
                        }
                    }
                    while (true) {
                        Object e = MemoryManager.this._releaseQueue.poll();
                        buf = e;
                        if (e == null) break;
                        ConcurrentLinkedQueue queue = (ConcurrentLinkedQueue)MemoryManager.this._sizeMap.get(MemoryManager.this._initializer.size(buf));
                        MemoryManager.this._initializer.init(buf);
                        queue.offer(new WeakReference<Object>(buf));
                        MemoryManager.this._releaseQueueSize.decrementAndGet();
                    }
                    buf = null;
                }
            }
        });
        this._cleanThread.setDaemon(true);
        this._cleanThread.start();
    }

    public T get(int size) {
        WeakReference<T> ref;
        ConcurrentLinkedQueue<WeakReference<Object>> queue = this._sizeMap.get(size = Integer.highestOneBit(2 * size));
        if (queue == null) {
            queue = new ConcurrentLinkedQueue();
            this._sizeMap.putIfAbsent(size, queue);
        }
        while ((ref = queue.poll()) != null) {
            Object buf = ref.get();
            if (buf == null) continue;
            return buf;
        }
        return this._initializer.newInstance(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(T buf) {
        if (this._releaseQueueSize.get() > 1000) {
            log.info((Object)"release queue full");
            return;
        }
        if (buf != null) {
            this._releaseQueue.offer(buf);
            this._releaseQueueSize.incrementAndGet();
            MemoryManager memoryManager = this;
            synchronized (memoryManager) {
                this.notifyAll();
            }
        }
    }

    public static interface Initializer<E> {
        public E newInstance(int var1);

        public int size(E var1);

        public void init(E var1);
    }
}

