/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.api.impl.util;

import java.util.AbstractQueue;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PriorityQueue<T>
extends AbstractQueue<T> {
    private final int _capacity;
    private final T[] _items;
    private int _size = 0;
    private Comparator<? super T> _comp;

    public PriorityQueue(int capacity, Comparator<? super T> comparator) {
        this._capacity = capacity;
        this._comp = comparator;
        this._items = new Object[capacity];
    }

    @Override
    public T element() throws NoSuchElementException {
        if (this._size == 0) {
            throw new NoSuchElementException("empty queue");
        }
        return this._items[0];
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < PriorityQueue.this._size;
            }

            @Override
            public T next() throws NoSuchElementException {
                if (this.i >= PriorityQueue.this._size) {
                    throw new NoSuchElementException("last element reached in queue");
                }
                return PriorityQueue.this._items[this.i++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("not supported");
            }
        };
    }

    @Override
    public boolean offer(T item) {
        if (this._size == this._capacity) {
            return false;
        }
        if (item == null) {
            throw new NullPointerException();
        }
        this._items[this._size] = item;
        this.percolateUp(this._size);
        ++this._size;
        return true;
    }

    @Override
    public T peek() {
        if (this._size == 0) {
            return null;
        }
        return this._items[0];
    }

    @Override
    public T poll() {
        if (this._size == 0) {
            return null;
        }
        T ret = this._items[0];
        --this._size;
        this._items[0] = this._items[this._size];
        this._items[this._size] = null;
        if (this._size > 1) {
            this.percolateDown();
        }
        return ret;
    }

    @Override
    public int size() {
        return this._size;
    }

    private void percolateDown() {
        block4: {
            T temp = this._items[0];
            int index = 0;
            while (true) {
                int left;
                int right;
                if ((right = (left = (index << 1) + 1) + 1) < this._size) {
                    left = this._comp.compare(this._items[left], this._items[right]) < 0 ? left : right;
                } else if (left >= this._size) {
                    this._items[index] = temp;
                    break block4;
                }
                if (this._comp.compare(this._items[left], temp) >= 0) break;
                this._items[index] = this._items[left];
                index = left;
            }
            this._items[index] = temp;
        }
    }

    private void percolateUp(int index) {
        int i;
        T temp = this._items[index];
        while ((i = index - 1 >> 1) >= 0 && this._comp.compare(temp, this._items[i]) < 0) {
            this._items[index] = this._items[i];
            index = i;
        }
        this._items[index] = temp;
    }
}

