/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.api.indexing;

import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import proj.zoie.api.indexing.OptimizeScheduler;
import proj.zoie.mbean.ZoieSystemAdminMBean;

public class DefaultOptimizeScheduler
extends OptimizeScheduler {
    private static long DAY_IN_MILLIS = 86400000L;
    private static Logger logger = Logger.getLogger(DefaultOptimizeScheduler.class);
    private long _optimizeDuration = DAY_IN_MILLIS;
    private volatile boolean _optimizeScheduled = false;
    private OptimizeScheduler.OptimizeType _optimizeType;
    private Timer _optimizeTimer;
    private TimerTask _currentOptimizationTimerTask;
    private Date _dateToStartOptimize = DefaultOptimizeScheduler.calculateNextDay();
    private final ZoieSystemAdminMBean _zoieAdmin;

    private static Date calculateNextDay() {
        Calendar cal = Calendar.getInstance();
        int curHour = cal.get(11);
        cal.set(11, 1);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        if (curHour > 1) {
            cal.set(6, cal.get(6) + 1);
        }
        return cal.getTime();
    }

    public DefaultOptimizeScheduler(ZoieSystemAdminMBean zoieAdmin) {
        this._currentOptimizationTimerTask = new OptimizeTimerTask();
        this._optimizeTimer = new Timer("index optimization timer", true);
        this._optimizeTimer.scheduleAtFixedRate(this._currentOptimizationTimerTask, this._dateToStartOptimize, this._optimizeDuration);
        this._optimizeType = OptimizeScheduler.OptimizeType.PARTIAL;
        this._zoieAdmin = zoieAdmin;
    }

    public long getOptimizeDuration() {
        return this._optimizeDuration;
    }

    public synchronized void setOptimizeDuration(long optimizeDuration) {
        if (this._optimizeDuration != optimizeDuration) {
            this._currentOptimizationTimerTask.cancel();
            this._optimizeTimer.purge();
            this._currentOptimizationTimerTask = new OptimizeTimerTask();
            this._optimizeTimer.scheduleAtFixedRate(this._currentOptimizationTimerTask, this._dateToStartOptimize, optimizeDuration);
            this._optimizeDuration = optimizeDuration;
        }
    }

    public synchronized void setDateToStartOptimize(Date optimizeStartDate) {
        if (!this._dateToStartOptimize.equals(optimizeStartDate)) {
            this._currentOptimizationTimerTask.cancel();
            this._optimizeTimer.purge();
            this._currentOptimizationTimerTask = new OptimizeTimerTask();
            this._optimizeTimer.scheduleAtFixedRate(this._currentOptimizationTimerTask, optimizeStartDate, this._optimizeDuration);
            this._dateToStartOptimize = optimizeStartDate;
        }
    }

    public Date getDateToStartOptimize() {
        return this._dateToStartOptimize;
    }

    public OptimizeScheduler.OptimizeType getOptimizeType() {
        return this._optimizeType;
    }

    @Override
    public OptimizeScheduler.OptimizeType getScheduledOptimizeType() {
        return this._optimizeScheduled ? this._optimizeType : OptimizeScheduler.OptimizeType.NONE;
    }

    @Override
    public void finished() {
        this._optimizeScheduled = false;
    }

    @Override
    public void shutdown() {
        this._optimizeTimer.cancel();
        this._optimizeTimer.purge();
    }

    private class OptimizeTimerTask
    extends TimerTask {
        private OptimizeTimerTask() {
        }

        @Override
        public void run() {
            DefaultOptimizeScheduler.this._optimizeScheduled = true;
        }
    }
}

