/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.api.indexing;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;

public interface ZoieIndexable {
    public static final String DOCUMENT_ID_FIELD = "id";

    public long getUID();

    public boolean isDeleted();

    public boolean isSkip();

    public IndexingReq[] buildIndexingReqs();

    public boolean isStorable();

    public byte[] getStoreValue();

    public static final class IndexingReq {
        private final Document _doc;
        private final Analyzer _analyzer;

        public IndexingReq(Document doc) {
            this(doc, null);
        }

        public IndexingReq(Document doc, Analyzer analyzer) {
            this._doc = doc;
            this._analyzer = analyzer;
        }

        public Document getDocument() {
            return this._doc;
        }

        public Analyzer getAnalyzer() {
            return this._analyzer;
        }
    }
}

