/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.dataprovider.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Comparator;
import org.apache.log4j.Logger;
import proj.zoie.api.DataConsumer;
import proj.zoie.dataprovider.jdbc.JDBCConnectionFactory;
import proj.zoie.dataprovider.jdbc.PreparedStatementBuilder;
import proj.zoie.impl.indexing.StreamDataProvider;

public class JDBCStreamDataProvider<T>
extends StreamDataProvider<T> {
    private static final Logger log = Logger.getLogger(JDBCStreamDataProvider.class);
    private static final long DEFAULT_PULL_TIME = 1000L;
    private final JDBCConnectionFactory _connFactory;
    private final PreparedStatementBuilder<T> _stmtBuilder;
    private String _version;
    private Connection _conn;
    private PreparedStatement _stmt;
    private ResultSet _res;
    private long _pullTime;

    public JDBCStreamDataProvider(JDBCConnectionFactory connFactory, PreparedStatementBuilder<T> stmtBuilder, Comparator<String> versionComparator) {
        super(versionComparator);
        this._connFactory = connFactory;
        this._stmtBuilder = stmtBuilder;
        this._version = null;
        this._conn = null;
        this._stmt = null;
        this._res = null;
        this._pullTime = 1000L;
    }

    public void setPullTime(long pullTime) {
        this._pullTime = pullTime;
    }

    public long getPullTime() {
        return this._pullTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataConsumer.DataEvent<T> next() {
        DataConsumer.DataEvent<T> event;
        block9: {
            event = null;
            try {
                if (!this._res.next()) {
                    try {
                        this._res.close();
                    }
                    finally {
                        this._stmt.close();
                    }
                    try {
                        Thread.sleep(this._pullTime);
                    }
                    catch (InterruptedException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                    this._stmt = this._stmtBuilder.buildStatment(this._conn, this._version);
                    this._res = this._stmt.executeQuery();
                    break block9;
                }
                event = this._stmtBuilder.buildDataEvent(this._res);
                this._version = event.getVersion();
            }
            catch (SQLException sqle) {
                log.error((Object)sqle.getMessage(), (Throwable)sqle);
            }
        }
        return event;
    }

    @Override
    public void setStartingOffset(String version) {
        this._version = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        DataConsumer dc;
        if (this._res != null) {
            try {
                this._res.close();
            }
            catch (SQLException sqle) {
                log.error((Object)sqle.getMessage(), (Throwable)sqle);
                this._res = null;
            }
            finally {
                try {
                    this._stmt.close();
                }
                catch (SQLException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        if ((dc = this.getDataConsumer()) == null) {
            this._version = null;
            log.warn((Object)"problem opening index, maynot exist, defaulting version to null");
        } else {
            this._version = dc.getVersion();
        }
        if (this._conn == null) {
            try {
                this._conn = this._connFactory.getConnection();
                this._stmt = this._stmtBuilder.buildStatment(this._conn, this._version);
                this._res = this._stmt.executeQuery();
            }
            catch (SQLException sqle) {
                log.fatal((Object)sqle.getMessage(), (Throwable)sqle);
                this._res = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void stop() {
        try {
            super.stop();
            return;
        }
        finally {
            try {
                if (this._res != null) {
                    this._res.close();
                }
            }
            catch (SQLException sqle) {
                log.error((Object)sqle.getMessage(), (Throwable)sqle);
            }
            finally {
                try {
                    if (this._stmt != null) {
                        this._stmt.close();
                    }
                }
                catch (SQLException sqle) {
                    log.error((Object)sqle.getMessage(), (Throwable)sqle);
                }
            }
        }
    }
}

