/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.dataprovider.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import proj.zoie.dataprovider.jdbc.JDBCConnectionFactory;

public class MysqlJDBCConnectionFactory
implements JDBCConnectionFactory {
    private static final String MYSQL_JDBC_URL_PREFIX = "jdbc:mysql://";
    private static final String MYSQL_DRIVER_NAME = "com.mysql.jdbc.Driver";
    private final String _username;
    private final String _pw;
    private final String _url;
    private Connection _conn = null;

    public MysqlJDBCConnectionFactory(String url, String username, String password) {
        this._url = MYSQL_JDBC_URL_PREFIX + url;
        this._username = username;
        this._pw = password;
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        if (this._conn == null) {
            try {
                Class.forName(MYSQL_DRIVER_NAME).newInstance();
            }
            catch (Exception e) {
                throw new SQLException("unable to load driver: " + e.getMessage());
            }
            this._conn = DriverManager.getConnection(this._url, this._username, this._pw);
        }
        return this._conn;
    }

    @Override
    public synchronized void showndown() throws SQLException {
        if (this._conn != null) {
            this._conn.close();
        }
    }
}

