/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.dataprovider.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import proj.zoie.dataprovider.jdbc.JDBCConnectionFactory;

public class OracleJDBCConnectionFactory
implements JDBCConnectionFactory {
    private static final String ORACLE_JDBC_URL_PREFIX = "jdbc:oracle:thin:@";
    private static final String ORACLE_DRIVER_NAME = "oracle.jdbc.OracleDriver";
    private final String _username;
    private final String _password;
    private final String _url;
    private Connection _conn = null;

    public OracleJDBCConnectionFactory(String hostname, int port, String SID, String username, String password) {
        this(hostname + ":" + port + ":" + SID, username, password);
    }

    public OracleJDBCConnectionFactory(String database, String username, String password) {
        this._url = ORACLE_JDBC_URL_PREFIX + database;
        this._username = username;
        this._password = password;
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        if (this._conn == null) {
            try {
                Class.forName(ORACLE_DRIVER_NAME);
            }
            catch (Exception e) {
                throw new SQLException("unable to load driver: " + e.getMessage());
            }
            this._conn = DriverManager.getConnection(this._url, this._username, this._password);
        }
        return this._conn;
    }

    @Override
    public synchronized void showndown() throws SQLException {
        if (this._conn != null) {
            this._conn.close();
        }
    }
}

