/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.hourglass.impl;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import proj.zoie.api.ZoieException;
import proj.zoie.api.ZoieIndexReader;
import proj.zoie.api.indexing.IndexReaderDecorator;
import proj.zoie.impl.indexing.ZoieSystem;

public class Box<R extends IndexReader, D> {
    public static final Logger log = Logger.getLogger((String)Box.class.getName());
    List<ZoieIndexReader<R>> _archives;
    List<ZoieSystem<R, D>> _archiveZoies;
    List<ZoieSystem<R, D>> _retiree;
    List<ZoieSystem<R, D>> _actives;
    IndexReaderDecorator<R> _decorator;

    public Box(List<ZoieIndexReader<R>> archives, List<ZoieSystem<R, D>> archiveZoies, List<ZoieSystem<R, D>> retiree, List<ZoieSystem<R, D>> actives, IndexReaderDecorator<R> decorator) {
        this._archives = new LinkedList<ZoieIndexReader<R>>(archives);
        this._archiveZoies = new LinkedList<ZoieSystem<R, D>>(archiveZoies);
        this._retiree = new LinkedList<ZoieSystem<R, D>>(retiree);
        this._actives = new LinkedList<ZoieSystem<R, D>>(actives);
        this._decorator = decorator;
        if (log.isDebugEnabled()) {
            for (ZoieIndexReader<R> r : this._archives) {
                log.debug((Object)("archive " + r.directory() + " refCount: " + r.getRefCount()));
            }
        }
    }

    public void shutdown() {
        for (ZoieIndexReader<R> zoieIndexReader : this._archives) {
            zoieIndexReader.decZoieRef();
            log.info((Object)("refCount at shutdown: " + zoieIndexReader.getRefCount() + " " + zoieIndexReader.directory()));
        }
        for (ZoieSystem zoieSystem : this._archiveZoies) {
            zoieSystem.shutdown();
        }
        for (ZoieSystem zoieSystem : this._retiree) {
            zoieSystem.shutdown();
        }
        for (ZoieSystem zoieSystem : this._actives) {
            while (true) {
                long flushwait = 200000L;
                try {
                    zoieSystem.flushEvents(flushwait);
                    zoieSystem.getAdminMBean().setUseCompoundFile(true);
                    zoieSystem.getAdminMBean().optimize(1);
                }
                catch (IOException e) {
                    log.error((Object)("pre-shutdown optimization " + zoieSystem.getAdminMBean().getIndexDir() + " Should investigate. But move on now."), (Throwable)e);
                }
                catch (ZoieException e) {
                    if (e.getMessage().indexOf("timed out") < 0) break;
                    log.info((Object)("pre-shutdown optimization " + zoieSystem.getAdminMBean().getIndexDir() + " flushing processing " + flushwait + "ms elapsed"));
                    continue;
                }
                break;
            }
            zoieSystem.shutdown();
        }
    }
}

