/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.hourglass.impl;

import java.util.List;
import proj.zoie.api.Zoie;
import proj.zoie.api.ZoieIndexReader;
import proj.zoie.hourglass.impl.HourglassListener;

public class CompositeHourglassListener
implements HourglassListener {
    private final List<HourglassListener> listeners;

    public CompositeHourglassListener(List<HourglassListener> listeners) {
        this.listeners = listeners;
    }

    public void onNewZoie(Zoie zoie) {
        for (HourglassListener listener : this.listeners) {
            if (zoie == null) continue;
            listener.onNewZoie(zoie);
        }
    }

    public void onRetiredZoie(Zoie zoie) {
        for (HourglassListener listener : this.listeners) {
            if (zoie == null) continue;
            listener.onRetiredZoie(zoie);
        }
    }

    public void onIndexReaderCleanUp(ZoieIndexReader indexReader) {
        for (HourglassListener listener : this.listeners) {
            if (indexReader == null) continue;
            listener.onIndexReaderCleanUp(indexReader);
        }
    }
}

