/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.hourglass.impl;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Random;
import org.apache.log4j.Logger;

public class HourGlassScheduler {
    public static final Logger log = Logger.getLogger((String)HourGlassScheduler.class.getName());
    private String _schedule;
    private final FREQUENCY _freq;
    private int[] _params = new int[6];
    private int _trimThreshold = Integer.MAX_VALUE;
    private boolean _appendOnly = true;
    private static ThreadLocal<SimpleDateFormat> dateFormatter = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        }
    };

    public HourGlassScheduler(FREQUENCY freq, String schedule) {
        this._schedule = schedule;
        this._freq = freq;
        String[] param = this._schedule.split(" ");
        for (int i = 0; i < Math.min(this._params.length, param.length); ++i) {
            this._params[i] = this.parseParam(param[i]);
        }
        int size = this._params.length / 2;
        if (param.length <= size) {
            for (int i = 0; i < size; ++i) {
                this._params[size + i] = this._params[i];
            }
        }
        log.info((Object)("schedule: " + Arrays.toString(this._params) + " frequenty: " + (Object)((Object)this._freq)));
        if (param.length > size) {
            int end = this._params[3] + this._params[4] * 60 + this._params[5] * 3600;
            int start = this._params[0] + this._params[1] * 60 + this._params[2] * 3600;
            int gap = end - start;
            if (gap < 0) {
                gap += 86400;
            }
            if (gap != 0) {
                start += new Random().nextInt(gap);
                this._params[0] = (start %= 86400) % 60;
                this._params[1] = start % 3600 / 60;
                this._params[2] = start / 3600;
            }
        }
        log.info((Object)("schedule final: " + Arrays.toString(this._params) + " frequenty: " + (Object)((Object)this._freq)));
    }

    public HourGlassScheduler(FREQUENCY freq, String schedule, int trimThreshold) {
        this(freq, schedule);
        this._trimThreshold = trimThreshold;
        log.info((Object)("schedule: " + Arrays.toString(this._params) + " frequenty: " + (Object)((Object)this._freq) + " trimThreshold: keep last " + this._trimThreshold + " rolling periods"));
    }

    public HourGlassScheduler(FREQUENCY freq, String schedule, boolean appendOnly) {
        this(freq, schedule);
        this._appendOnly = appendOnly;
    }

    public HourGlassScheduler(FREQUENCY freq, String schedule, boolean appendOnly, int trimThreshold) {
        this(freq, schedule, appendOnly);
        this._trimThreshold = trimThreshold;
        log.info((Object)("schedule: " + Arrays.toString(this._params) + " frequenty: " + (Object)((Object)this._freq) + " trimThreshold: keep last " + this._trimThreshold + " rolling periods"));
    }

    private int parseParam(String param) {
        if (param.indexOf(42) >= 0) {
            return 0;
        }
        int ret = 0;
        try {
            ret = Integer.parseInt(param.trim());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to instantiate HourGlassScheduler", e);
        }
        return ret;
    }

    public FREQUENCY getFreq() {
        return this._freq;
    }

    public int getTrimThreshold() {
        return this._trimThreshold;
    }

    public boolean isAppendOnly() {
        return this._appendOnly;
    }

    protected Calendar getNextRoll() {
        long timenow = System.currentTimeMillis();
        Calendar next = Calendar.getInstance();
        next.setTimeInMillis(timenow);
        Calendar now = Calendar.getInstance();
        now.setTimeInMillis(timenow);
        switch (this._freq) {
            case MINUTELY: {
                next.set(13, this._params[0]);
                if (next.after(now)) break;
                next.add(12, 1);
                break;
            }
            case HOURLY: {
                next.set(13, this._params[0]);
                next.set(12, this._params[1]);
                if (next.after(now)) break;
                next.add(11, 1);
                break;
            }
            case DAILY: {
                next.set(13, this._params[0]);
                next.set(12, this._params[1]);
                next.set(11, this._params[2]);
                if (next.after(now)) break;
                next.add(5, 1);
            }
        }
        return next;
    }

    Calendar getCurrentRoll() {
        Calendar current = this.getNextRoll();
        switch (this._freq) {
            case MINUTELY: {
                current.add(12, -1);
                break;
            }
            case HOURLY: {
                current.add(11, -1);
                break;
            }
            case DAILY: {
                current.add(5, -1);
            }
        }
        return current;
    }

    public Calendar getTrimTime(Calendar now) {
        Calendar threshold = (Calendar)now.clone();
        int trimUnit = 86400;
        switch (this.getFreq()) {
            case MINUTELY: {
                trimUnit = 60;
                break;
            }
            case HOURLY: {
                trimUnit = 3600;
                break;
            }
            case DAILY: {
                trimUnit = 86400;
            }
        }
        threshold.add(13, -trimUnit * this._trimThreshold);
        return threshold;
    }

    public String getFolderName(Calendar cal) {
        return dateFormatter.get().format(cal.getTime());
    }

    public String toString() {
        return "HourGlassScheduler:" + (Object)((Object)this._freq) + "  " + this._schedule;
    }

    public static enum FREQUENCY {
        MINUTELY,
        HOURLY,
        DAILY;

    }
}

