/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.hourglass.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import proj.zoie.api.DataConsumer;
import proj.zoie.api.DefaultDirectoryManager;
import proj.zoie.api.DirectoryManager;
import proj.zoie.api.DocIDMapper;
import proj.zoie.api.Zoie;
import proj.zoie.api.ZoieException;
import proj.zoie.api.ZoieIndexReader;
import proj.zoie.api.ZoieMultiReader;
import proj.zoie.api.indexing.IndexReaderDecorator;
import proj.zoie.api.indexing.ZoieIndexableInterpreter;
import proj.zoie.hourglass.impl.HourGlassScheduler;
import proj.zoie.hourglass.impl.HourglassDirectoryManagerFactory;
import proj.zoie.hourglass.impl.HourglassListener;
import proj.zoie.hourglass.impl.HourglassReaderManager;
import proj.zoie.hourglass.mbean.HourglassAdmin;
import proj.zoie.hourglass.mbean.HourglassAdminMBean;
import proj.zoie.impl.indexing.ZoieConfig;
import proj.zoie.impl.indexing.ZoieSystem;

public class Hourglass<R extends IndexReader, D>
implements Zoie<R, D> {
    public static final Logger log = Logger.getLogger(Hourglass.class);
    private final HourglassDirectoryManagerFactory _dirMgrFactory;
    private final ZoieIndexableInterpreter<D> _interpreter;
    private final IndexReaderDecorator<R> _decorator;
    private final ZoieConfig _zConfig;
    private volatile ZoieSystem<R, D> _currentZoie;
    private volatile boolean _isShutdown = false;
    final ReentrantReadWriteLock _shutdownLock = new ReentrantReadWriteLock();
    private final ReentrantLock _consumeLock = new ReentrantLock();
    private final HourglassReaderManager<R, D> _readerMgr;
    private volatile String _currentVersion = null;
    private long _freshness = 1000L;
    final HourGlassScheduler _scheduler;
    public volatile long SLA = 4L;
    private List<HourglassListener> _hourglassListeners;
    private volatile long lastupdate = 0L;
    private volatile List<ZoieIndexReader<R>> list = new ArrayList<ZoieIndexReader<R>>();
    private final ReentrantLock cacheLock = new ReentrantLock();
    public static String HOURGLASSADMIN = "hourglass-admin";

    public Hourglass(HourglassDirectoryManagerFactory dirMgrFactory, ZoieIndexableInterpreter<D> interpreter, IndexReaderDecorator<R> readerDecorator, ZoieConfig zoieConfig, List<HourglassListener> hourglassListeners) {
        List<ZoieSystem<R, D>> archiveZoies;
        List<ZoieIndexReader<R>> archives;
        this._zConfig = zoieConfig;
        this._dirMgrFactory = dirMgrFactory;
        hourglassListeners = hourglassListeners == null ? Collections.EMPTY_LIST : new CopyOnWriteArrayList<HourglassListener>(hourglassListeners);
        this._hourglassListeners = hourglassListeners;
        this._scheduler = this._dirMgrFactory.getScheduler();
        this._dirMgrFactory.clearRecentlyChanged();
        this._interpreter = interpreter;
        this._decorator = readerDecorator;
        if (this._dirMgrFactory.getScheduler().isAppendOnly()) {
            archives = this.loadArchives();
            archiveZoies = Collections.EMPTY_LIST;
        } else {
            archives = Collections.EMPTY_LIST;
            archiveZoies = this.loadArchiveZoies();
        }
        this._readerMgr = new HourglassReaderManager<R, D>(this, this._dirMgrFactory, this._decorator, archives, archiveZoies, hourglassListeners);
        this._currentVersion = this._dirMgrFactory.getArchivedVersion();
        this._currentZoie = this._readerMgr.retireAndNew(null);
        this._currentZoie.start();
        this._freshness = zoieConfig.getFreshness();
        log.info((Object)("start Hourglass at version: " + this._currentVersion));
    }

    public Hourglass(HourglassDirectoryManagerFactory dirMgrFactory, ZoieIndexableInterpreter<D> interpreter, IndexReaderDecorator<R> readerDecorator, ZoieConfig zoieConfig) {
        this(dirMgrFactory, interpreter, readerDecorator, zoieConfig, Collections.EMPTY_LIST);
    }

    public Hourglass(HourglassDirectoryManagerFactory dirMgrFactory, ZoieIndexableInterpreter<D> interpreter, IndexReaderDecorator<R> readerDecorator, ZoieConfig zoieConfig, HourglassListener hourglassListener) {
        this(dirMgrFactory, interpreter, readerDecorator, zoieConfig, Arrays.asList(hourglassListener));
    }

    protected List<ZoieSystem<R, D>> loadArchiveZoies() {
        ArrayList<ZoieSystem<R, D>> archives = new ArrayList<ZoieSystem<R, D>>();
        long t0 = System.currentTimeMillis();
        List<File> dirs = this._dirMgrFactory.getAllArchivedDirs();
        for (File dir : dirs) {
            try {
                DefaultDirectoryManager dirMgr = new DefaultDirectoryManager(dir, this._dirMgrFactory.getMode());
                ZoieSystem<R, D> zoie = new ZoieSystem<R, D>(dirMgr, this._interpreter, this._decorator, this._zConfig);
                zoie.start();
                archives.add(zoie);
            }
            catch (Exception e) {
                log.error((Object)("Load index: " + dir + " failed."), (Throwable)e);
            }
        }
        log.info((Object)("load " + dirs.size() + " archived indices of " + this.getSizeBytes() + " bytes in " + (System.currentTimeMillis() - t0) + "ms"));
        return archives;
    }

    protected List<ZoieIndexReader<R>> loadArchives() {
        ArrayList<ZoieIndexReader<R>> archives = new ArrayList<ZoieIndexReader<R>>();
        long t0 = System.currentTimeMillis();
        List<Directory> dirs = this._dirMgrFactory.getAllArchivedDirectories();
        for (Directory dir : dirs) {
            try {
                IndexReader reader = IndexReader.open((Directory)dir, (boolean)true);
                ZoieMultiReader<R> zoiereader = new ZoieMultiReader<R>(reader, this._decorator);
                DocIDMapper<?> mapper = this._zConfig.getDocidMapperFactory().getDocIDMapper(zoiereader);
                zoiereader.setDocIDMapper(mapper);
                archives.add(zoiereader);
            }
            catch (CorruptIndexException e) {
                log.error((Object)"corruptedIndex", (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)"IOException", (Throwable)e);
            }
        }
        log.info((Object)("load " + dirs.size() + " archived indices of " + this.getSizeBytes() + " bytes in " + (System.currentTimeMillis() - t0) + "ms"));
        return archives;
    }

    ZoieSystem<R, D> createZoie(DirectoryManager dirmgr) {
        return new ZoieSystem<R, D>(dirmgr, this._interpreter, this._decorator, this._zConfig);
    }

    public ZoieConfig getzConfig() {
        return this._zConfig;
    }

    public ZoieSystem<R, D> getCurrentZoie() {
        return this._currentZoie;
    }

    public HourglassDirectoryManagerFactory getDirMgrFactory() {
        return this._dirMgrFactory;
    }

    @Override
    public Analyzer getAnalyzer() {
        return this._zConfig.getAnalyzer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ZoieIndexReader<R>> getIndexReaders() throws IOException {
        long t0 = System.currentTimeMillis();
        try {
            this._shutdownLock.readLock().lock();
            if (this._isShutdown) {
                ArrayList<ZoieIndexReader<R>> list;
                log.warn((Object)"System already shut down. No search request allowed.");
                ArrayList<ZoieIndexReader<R>> arrayList = list = new ArrayList<ZoieIndexReader<R>>();
                return arrayList;
            }
            try {
                this.cacheLock.lock();
                if (System.currentTimeMillis() - this.lastupdate > this._freshness) {
                    this.updateCachedReaders();
                }
                List<ZoieIndexReader<R>> rlist = this.list;
                for (ZoieIndexReader<R> r : rlist) {
                    r.incZoieRef();
                }
                t0 = System.currentTimeMillis() - t0;
                if (t0 > this.SLA) {
                    log.warn((Object)("getIndexReaders returned in " + t0 + "ms more than " + this.SLA + "ms"));
                }
                List<ZoieIndexReader<R>> list = rlist;
                this.cacheLock.unlock();
                return list;
            }
            catch (Throwable throwable) {
                this.cacheLock.unlock();
                throw throwable;
            }
        }
        finally {
            this._shutdownLock.readLock().unlock();
        }
    }

    private void updateCachedReaders() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updating reader cache");
        }
        List<ZoieIndexReader<R>> olist = this.list;
        this.returnIndexReaders(olist);
        if (log.isDebugEnabled()) {
            log.debug((Object)"getting new reader from reader cache");
        }
        this.list = this._readerMgr.getIndexReaders();
        if (log.isDebugEnabled()) {
            log.debug((Object)("reader updated with size: " + this.list.size()));
        }
        this.lastupdate = System.currentTimeMillis();
    }

    private void clearCachedReaders() {
        List<ZoieIndexReader<R>> olist = this.list;
        this.returnIndexReaders(olist);
        this.list = null;
        this.lastupdate = 0L;
    }

    @Override
    public void returnIndexReaders(List<ZoieIndexReader<R>> readers) {
        long t0 = System.currentTimeMillis();
        this._currentZoie.returnIndexReaders(readers);
        t0 = System.currentTimeMillis() - t0;
        if (t0 > this.SLA) {
            log.warn((Object)("returnIndexReaders returned in " + t0 + "ms more than " + this.SLA + "ms"));
        }
    }

    private void clearFromArchives(Collection<DataConsumer.DataEvent<D>> data) throws ZoieException {
        if (this._dirMgrFactory.getScheduler().isAppendOnly()) {
            return;
        }
        if (data != null && data.size() > 0) {
            ArrayList deletes = new ArrayList(data.size());
            for (DataConsumer.DataEvent<D> dataEvent : data) {
                if (dataEvent instanceof DataConsumer.MarkerDataEvent) continue;
                deletes.add(new DataConsumer.DataEvent<D>(dataEvent.getData(), dataEvent.getVersion(), true));
            }
            for (ZoieSystem zoieSystem : this._readerMgr.getArchiveZoies()) {
                zoieSystem.consume(deletes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void consume(Collection<DataConsumer.DataEvent<D>> data) throws ZoieException {
        try {
            this._consumeLock.lock();
            try {
                this._shutdownLock.readLock().lock();
                if (data == null) return;
                if (data.size() == 0) {
                    return;
                }
                if (this._isShutdown) {
                    log.warn((Object)"System already shut down. Rejects indexing request.");
                    return;
                }
                if (!this._dirMgrFactory.updateDirectoryManager()) {
                    this.clearFromArchives(data);
                    this._currentZoie.consume(data);
                    return;
                }
                this._currentZoie = this._readerMgr.retireAndNew(this._currentZoie);
                this._currentZoie.start();
                this.clearFromArchives(data);
                this._currentZoie.consume(data);
                return;
            }
            finally {
                this._shutdownLock.readLock().unlock();
            }
        }
        finally {
            this._consumeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        try {
            this._shutdownLock.writeLock().lock();
            if (this._isShutdown) {
                log.info((Object)"system already shut down");
                return;
            }
            this._isShutdown = true;
        }
        finally {
            this._shutdownLock.writeLock().unlock();
        }
        this.clearCachedReaders();
        this._readerMgr.shutdown();
        log.info((Object)"shut down complete.");
    }

    @Override
    public String getVersion() {
        if (this._currentZoie.getCurrentVersion() != null) {
            if (this._currentVersion == null) {
                this._currentVersion = this._currentZoie.getCurrentVersion();
                return this._currentVersion;
            }
            this._currentVersion = this._zConfig.getVersionComparator().compare(this._currentZoie.getCurrentVersion(), this._currentVersion) < 0 ? this._currentVersion : this._currentZoie.getCurrentVersion();
        }
        return this._currentVersion;
    }

    @Override
    public Comparator<String> getVersionComparator() {
        return this._zConfig.getVersionComparator();
    }

    public long getSizeBytes() {
        return this._dirMgrFactory.getDiskIndexSizeBytes();
    }

    @Override
    public void syncWithVersion(long timeInMillis, String version) throws ZoieException {
        if (this._currentZoie != null) {
            this._currentZoie.syncWithVersion(timeInMillis, version);
        }
    }

    @Override
    public StandardMBean getStandardMBean(String name) {
        if (name.equals(HOURGLASSADMIN)) {
            try {
                return new StandardMBean(this.getAdminMBean(), HourglassAdminMBean.class);
            }
            catch (NotCompliantMBeanException e) {
                log.info((Object)e);
                return null;
            }
        }
        return null;
    }

    @Override
    public HourglassAdminMBean getAdminMBean() {
        return new HourglassAdmin(this);
    }

    @Override
    public String[] getStandardMBeanNames() {
        return new String[]{HOURGLASSADMIN};
    }

    @Override
    public void start() {
        log.info((Object)"starting Hourglass... already done due by auto-start");
    }

    @Override
    public void flushEvents(long timeout) throws ZoieException {
        this._currentZoie.flushEvents(timeout);
    }

    @Override
    public String getCurrentReaderVersion() {
        return this._currentZoie == null ? null : this._currentZoie.getCurrentReaderVersion();
    }

    public void addHourglassListener(HourglassListener hourglassListener) {
        if (hourglassListener != null) {
            this._hourglassListeners.add(hourglassListener);
        }
    }
}

