/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.hourglass.impl;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.SimpleFSDirectory;
import proj.zoie.api.DefaultDirectoryManager;
import proj.zoie.api.DirectoryManager;
import proj.zoie.api.impl.util.FileUtil;
import proj.zoie.hourglass.impl.HourGlassScheduler;
import proj.zoie.impl.indexing.internal.IndexSignature;

public class HourglassDirectoryManagerFactory {
    public static final Logger log = Logger.getLogger(HourglassDirectoryManagerFactory.class);
    private final File _root;
    private final HourGlassScheduler _scheduler;
    private volatile File _location;
    private volatile DirectoryManager _currentDirMgr = null;
    private volatile boolean isRecentlyChanged = false;
    public static final String dateFormatString = "yyyy-MM-dd-HH-mm-ss";
    private final DirectoryManager.DIRECTORY_MODE _mode;
    private static ThreadLocal<SimpleDateFormat> dateFormatter = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat(HourglassDirectoryManagerFactory.dateFormatString);
        }
    };
    private volatile Calendar _nextUpdateTime = Calendar.getInstance();

    public HourGlassScheduler getScheduler() {
        return this._scheduler;
    }

    public HourglassDirectoryManagerFactory(File root, HourGlassScheduler scheduler) {
        this._root = root;
        this._scheduler = scheduler;
        this._mode = DirectoryManager.DIRECTORY_MODE.SIMPLE;
        log.info((Object)("starting HourglassDirectoryManagerFactory at " + root + " --- index rolling scheduler: " + this._scheduler + " mode: " + (Object)((Object)this._mode)));
        this.updateDirectoryManager();
    }

    public HourglassDirectoryManagerFactory(File root, HourGlassScheduler scheduler, DirectoryManager.DIRECTORY_MODE mode) {
        this._root = root;
        this._scheduler = scheduler;
        this._mode = mode;
        log.info((Object)("starting HourglassDirectoryManagerFactory at " + root + " --- index rolling scheduler: " + this._scheduler + " mode: " + (Object)((Object)this._mode)));
        this.updateDirectoryManager();
    }

    public DirectoryManager getDirectoryManager() {
        return this._currentDirMgr;
    }

    public DirectoryManager.DIRECTORY_MODE getMode() {
        return this._mode;
    }

    private FSDirectory getFSDirectoryFromFile(File f) throws IOException {
        SimpleFSDirectory dir = null;
        switch (this._mode) {
            case SIMPLE: {
                dir = new SimpleFSDirectory(f);
                break;
            }
            case NIO: {
                dir = new NIOFSDirectory(f);
                break;
            }
            case MMAP: {
                dir = new MMapDirectory(f);
            }
        }
        return dir;
    }

    protected void setNextUpdateTime() {
        this._nextUpdateTime = this._scheduler.getNextRoll();
        log.info((Object)("setNextUpdateTime: " + this._scheduler.getFolderName(this._nextUpdateTime)));
    }

    public boolean updateDirectoryManager() {
        Calendar now = Calendar.getInstance();
        now.setTimeInMillis(System.currentTimeMillis());
        if (now.before(this._nextUpdateTime)) {
            return false;
        }
        String folderName = this._scheduler.getFolderName(this._nextUpdateTime);
        this._location = new File(this._root, folderName);
        try {
            log.info((Object)("rolling forward with new path: " + this._location.getCanonicalPath()));
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        this._currentDirMgr = new DefaultDirectoryManager(this._location, this._mode);
        this.isRecentlyChanged = true;
        this.setNextUpdateTime();
        return this.isRecentlyChanged;
    }

    public boolean isRecentlyChanged() {
        return this.isRecentlyChanged;
    }

    public void clearRecentlyChanged() {
        this.isRecentlyChanged = false;
    }

    public File getRoot() {
        return this._root;
    }

    public long getDiskIndexSizeBytes() {
        return FileUtil.sizeFile(this._root);
    }

    public List<File> getAllArchivedDirs() {
        List emptyList = Collections.EMPTY_LIST;
        if (!this._root.exists()) {
            return emptyList;
        }
        Object[] files = this._root.listFiles();
        Arrays.sort(files);
        ArrayList<File> list = new ArrayList<File>();
        Calendar now = Calendar.getInstance();
        long timenow = System.currentTimeMillis();
        now.setTimeInMillis(timenow);
        Calendar threshold = this._scheduler.getTrimTime(now);
        log.info((Object)("getAllArchivedDirectories loading time threshold: " + this._scheduler.getFolderName(threshold)));
        boolean foundOldestToKeep = false;
        for (int i = files.length - 1; i >= 0; --i) {
            Object file = files[i];
            String name = ((File)file).getName();
            log.debug((Object)("getAllArchivedDirectories: " + name + " " + (((File)file).equals(this._location) ? "*" : "")));
            if (foundOldestToKeep) {
                log.info((Object)("getAllArchivedDirectories: skipping " + name + " for being too old"));
                continue;
            }
            Calendar time = null;
            try {
                time = HourglassDirectoryManagerFactory.getCalendarTime(name);
            }
            catch (ParseException e) {
                log.warn((Object)("potential index corruption. we skip folder: " + name), (Throwable)e);
                continue;
            }
            if (!((File)file).equals(this._location)) {
                list.add((File)file);
            }
            if (!time.before(threshold)) continue;
            foundOldestToKeep = true;
        }
        if (list.size() == 0) {
            return emptyList;
        }
        return list;
    }

    public List<Directory> getAllArchivedDirectories() {
        List emptyList = Collections.EMPTY_LIST;
        ArrayList<Directory> list = new ArrayList<Directory>();
        List<File> dirs = this.getAllArchivedDirs();
        if (dirs != null) {
            for (File dir : dirs) {
                try {
                    list.add((Directory)this.getFSDirectoryFromFile(dir));
                }
                catch (IOException e) {
                    log.error((Object)("potential index corruption: " + dir), (Throwable)e);
                }
            }
        }
        if (list.size() == 0) {
            return emptyList;
        }
        return list;
    }

    public String getArchivedVersion() {
        if (!this._root.exists()) {
            return null;
        }
        String version = null;
        Object[] files = this._root.listFiles();
        Arrays.sort(files);
        for (Object file : files) {
            String name = ((File)file).getName();
            log.debug((Object)("getAllArchivedDirectories" + name + " " + (((File)file).equals(this._location) ? "*" : "")));
            long ctime = 0L;
            try {
                long time = dateFormatter.get().parse(name).getTime();
                if (((File)file).equals(this._location)) continue;
                IndexSignature sig = this.getIndexSignature((File)file);
                if (sig != null) {
                    if (sig.getVersion() == null || time <= ctime) continue;
                    version = sig.getVersion();
                    ctime = time;
                    continue;
                }
                log.error((Object)("potential index corruption: indexSignature not in " + this._location));
            }
            catch (ParseException e) {
                log.warn((Object)("potential index corruption. we skip folder: " + name), (Throwable)e);
            }
        }
        return version;
    }

    public IndexSignature getIndexSignature(File file) {
        File directoryFile = new File(file, "index.directory");
        IndexSignature sig = DefaultDirectoryManager.readSignature(directoryFile);
        return sig;
    }

    public void saveIndexSignature(File tgt, IndexSignature sig) throws IOException {
        File tgtFile = new File(tgt, "index.directory");
        DefaultDirectoryManager.saveSignature(sig, tgtFile);
    }

    public static Calendar getCalendarTime(String date) throws ParseException {
        try {
            long time = dateFormatter.get().parse(date).getTime();
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(time);
            return cal;
        }
        catch (ParseException e) {
            log.error((Object)"date formate should be like yyyy-MM-dd-HH-mm-ss", (Throwable)e);
            throw e;
        }
    }
}

