/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.hourglass.impl;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.SimpleFSDirectory;
import proj.zoie.api.DirectoryManager;
import proj.zoie.api.DocIDMapper;
import proj.zoie.api.ZoieException;
import proj.zoie.api.ZoieIndexReader;
import proj.zoie.api.ZoieMultiReader;
import proj.zoie.api.impl.util.FileUtil;
import proj.zoie.api.indexing.IndexReaderDecorator;
import proj.zoie.hourglass.impl.Box;
import proj.zoie.hourglass.impl.CompositeHourglassListener;
import proj.zoie.hourglass.impl.Hourglass;
import proj.zoie.hourglass.impl.HourglassDirectoryManagerFactory;
import proj.zoie.hourglass.impl.HourglassListener;
import proj.zoie.impl.indexing.ZoieSystem;

public class HourglassReaderManager<R extends IndexReader, D> {
    public static final Logger log = Logger.getLogger((String)HourglassReaderManager.class.getName());
    private final HourglassDirectoryManagerFactory _dirMgrFactory;
    private final Hourglass<R, D> hg;
    private final IndexReaderDecorator<R> _decorator;
    private volatile Box<R, D> box;
    private volatile boolean isShutdown = false;
    private final Thread maintenanceThread;
    private final ExecutorService retireThreadPool = Executors.newCachedThreadPool();
    private final HourglassListener<R, D> listener;
    private final boolean _appendOnly;

    public HourglassReaderManager(final Hourglass<R, D> hourglass, HourglassDirectoryManagerFactory dirMgrFactory, IndexReaderDecorator<R> decorator, List<ZoieIndexReader<R>> initArchives, List<ZoieSystem<R, D>> initArchiveZoies, List<HourglassListener> hourglassListeners) {
        this.hg = hourglass;
        this._dirMgrFactory = dirMgrFactory;
        this._appendOnly = this._dirMgrFactory.getScheduler().isAppendOnly();
        this._decorator = decorator;
        this.listener = new CompositeHourglassListener(hourglassListeners);
        List emptyList = Collections.emptyList();
        this.box = new Box<R, D>(initArchives, initArchiveZoies, emptyList, emptyList, this._decorator);
        this.maintenanceThread = new Thread(new Runnable(){
            final int trimThreshold;
            {
                this.trimThreshold = hourglass._scheduler.getTrimThreshold();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    try {
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            this.wait(60000L);
                        }
                    }
                    catch (InterruptedException e) {
                        log.warn((Object)e);
                    }
                    LinkedList archives = new LinkedList(((HourglassReaderManager)HourglassReaderManager.this).box._archives);
                    LinkedList add = new LinkedList();
                    LinkedList archiveZoies = new LinkedList(((HourglassReaderManager)HourglassReaderManager.this).box._archiveZoies);
                    LinkedList addZoies = new LinkedList();
                    try {
                        hourglass._shutdownLock.readLock().lock();
                        if (HourglassReaderManager.this.isShutdown) {
                            log.info((Object)"Already shut down. Quiting maintenance thread.");
                            break;
                        }
                        if (HourglassReaderManager.this._appendOnly) {
                            if (archives.size() <= this.trimThreshold) continue;
                            log.info((Object)"to maintain");
                            HourglassReaderManager.this.trim(archives);
                            HourglassReaderManager.this.swapArchives(archives, add);
                            continue;
                        }
                        if (archiveZoies.size() <= this.trimThreshold) continue;
                        log.info((Object)"to maintain");
                        HourglassReaderManager.this.trimZoie(archiveZoies);
                        HourglassReaderManager.this.swapArchiveZoies(archiveZoies, addZoies);
                        continue;
                    }
                    finally {
                        hourglass._shutdownLock.readLock().unlock();
                        continue;
                    }
                    break;
                }
            }
        }, "HourglassReaderManager Zoie Maintenanace Thread");
        this.maintenanceThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimZoie(List<ZoieSystem<R, D>> toRemove) {
        long timenow = System.currentTimeMillis();
        LinkedList<ZoieSystem> toKeep = new LinkedList<ZoieSystem>();
        Calendar now = Calendar.getInstance();
        now.setTimeInMillis(timenow);
        Calendar threshold = this.hg._scheduler.getTrimTime(now);
        ArrayList<ZoieSystem<R, D>> zoieList = new ArrayList<ZoieSystem<R, D>>(toRemove);
        Collections.sort(zoieList, new Comparator<ZoieSystem<R, D>>(){

            @Override
            public int compare(ZoieSystem<R, D> r1, ZoieSystem<R, D> r2) {
                String name1 = r1.getIndexDir();
                String name2 = r2.getIndexDir();
                return name2.compareTo(name1);
            }
        });
        boolean foundOldestToKeep = false;
        for (ZoieSystem zoieSystem : zoieList) {
            File dir = new File(zoieSystem.getIndexDir());
            String path = dir.getName();
            if (foundOldestToKeep) {
                if (this.listener != null) {
                    List readers = null;
                    try {
                        readers = zoieSystem.getIndexReaders();
                        if (readers != null) {
                            for (ZoieIndexReader reader : readers) {
                                this.listener.onIndexReaderCleanUp(reader);
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)"Error happend on reader cleanup", (Throwable)e);
                    }
                    finally {
                        if (readers != null) {
                            zoieSystem.returnIndexReaders(readers);
                        }
                    }
                }
                zoieSystem.shutdown();
                log.info((Object)("trimming: remove " + path));
                log.info((Object)(path + " -before-- delete"));
                FileUtil.rmDir(dir);
                log.info((Object)(path + " -after-- delete"));
                continue;
            }
            toKeep.add(zoieSystem);
            Calendar archivetime = null;
            try {
                archivetime = HourglassDirectoryManagerFactory.getCalendarTime(path);
            }
            catch (ParseException e) {
                log.error((Object)"index directory name bad. potential corruption. Move on without trimming.", (Throwable)e);
                continue;
            }
            if (!archivetime.before(threshold)) continue;
            foundOldestToKeep = true;
        }
        toRemove.removeAll(toKeep);
    }

    private void trim(List<ZoieIndexReader<R>> toRemove) {
        long timenow = System.currentTimeMillis();
        LinkedList<ZoieIndexReader> toKeep = new LinkedList<ZoieIndexReader>();
        Calendar now = Calendar.getInstance();
        now.setTimeInMillis(timenow);
        Calendar threshold = this.hg._scheduler.getTrimTime(now);
        ArrayList<ZoieIndexReader<R>> readerList = new ArrayList<ZoieIndexReader<R>>(toRemove);
        Collections.sort(readerList, new Comparator<ZoieIndexReader<R>>(){

            @Override
            public int compare(ZoieIndexReader<R> r1, ZoieIndexReader<R> r2) {
                String name1 = ((SimpleFSDirectory)r1.directory()).getDirectory().getName();
                String name2 = ((SimpleFSDirectory)r2.directory()).getDirectory().getName();
                return name2.compareTo(name1);
            }
        });
        boolean foundOldestToKeep = false;
        for (ZoieIndexReader zoieIndexReader : readerList) {
            SimpleFSDirectory dir = (SimpleFSDirectory)zoieIndexReader.directory();
            String path = dir.getDirectory().getName();
            if (foundOldestToKeep) {
                if (this.listener != null) {
                    this.listener.onIndexReaderCleanUp(zoieIndexReader);
                }
                log.info((Object)("trimming: remove " + path));
                log.info((Object)(dir.getDirectory() + " -before--" + (dir.getDirectory().exists() ? " not deleted " : " deleted")));
                FileUtil.rmDir(dir.getDirectory());
                log.info((Object)(dir.getDirectory() + " -after--" + (dir.getDirectory().exists() ? " not deleted " : " deleted")));
                continue;
            }
            toKeep.add(zoieIndexReader);
            Calendar archivetime = null;
            try {
                archivetime = HourglassDirectoryManagerFactory.getCalendarTime(path);
            }
            catch (ParseException e) {
                log.error((Object)"index directory name bad. potential corruption. Move on without trimming.", (Throwable)e);
                continue;
            }
            if (!archivetime.before(threshold)) continue;
            foundOldestToKeep = true;
        }
        toRemove.removeAll(toKeep);
    }

    public synchronized void swapArchiveZoies(List<ZoieSystem<R, D>> remove, List<ZoieSystem<R, D>> add) {
        LinkedList<ZoieSystem<R, D>> archives = new LinkedList<ZoieSystem<R, D>>(add);
        if (!this.box._archiveZoies.containsAll(remove)) {
            log.error((Object)"swapArchiveZoies: potential sync issue. ");
        }
        archives.addAll(this.box._archiveZoies);
        archives.removeAll(remove);
        Box newbox = new Box(this.box._archives, archives, this.box._retiree, this.box._actives, this._decorator);
        this.box = newbox;
    }

    public synchronized void swapArchives(List<ZoieIndexReader<R>> remove, List<ZoieIndexReader<R>> add) {
        LinkedList<ZoieIndexReader<R>> archives = new LinkedList<ZoieIndexReader<R>>(add);
        if (!this.box._archives.containsAll(remove)) {
            log.error((Object)"swapArchives: potential sync issue. ");
        }
        archives.addAll(this.box._archives);
        archives.removeAll(remove);
        for (ZoieIndexReader<R> r : remove) {
            r.decZoieRef();
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("remove time " + r.directory() + " refCount: " + r.getRefCount()));
        }
        Box newbox = new Box(archives, this.box._archiveZoies, this.box._retiree, this.box._actives, this._decorator);
        this.box = newbox;
    }

    public synchronized ZoieSystem<R, D> retireAndNew(final ZoieSystem<R, D> old) {
        DirectoryManager _dirMgr = this._dirMgrFactory.getDirectoryManager();
        this._dirMgrFactory.clearRecentlyChanged();
        ZoieSystem<R, D> newzoie = this.hg.createZoie(_dirMgr);
        LinkedList actives = new LinkedList(this.box._actives);
        LinkedList retiring = new LinkedList(this.box._retiree);
        if (old != null) {
            actives.remove(old);
            retiring.add(old);
            this.retireThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    if (HourglassReaderManager.this.listener != null) {
                        HourglassReaderManager.this.listener.onRetiredZoie(old);
                    }
                    HourglassReaderManager.this.retire(old);
                }
            });
        }
        actives.add(newzoie);
        Box newbox = new Box(this.box._archives, this.box._archiveZoies, retiring, actives, this._decorator);
        this.box = newbox;
        if (this.listener != null) {
            this.listener.onNewZoie(newzoie);
        }
        return newzoie;
    }

    public synchronized void archive(ZoieSystem<R, D> zoie, ZoieMultiReader<R> reader) {
        LinkedList archives = new LinkedList(this.box._archives);
        LinkedList archiveZoies = new LinkedList(this.box._archiveZoies);
        LinkedList actives = new LinkedList(this.box._actives);
        LinkedList retiring = new LinkedList(this.box._retiree);
        retiring.remove(zoie);
        if (!this._appendOnly) {
            archiveZoies.add(zoie);
        }
        if (reader != null) {
            archives.add(reader);
        }
        Box newbox = new Box(archives, archiveZoies, retiring, actives, this._decorator);
        this.box = newbox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void preshutdown() {
        log.info((Object)"shutting down thread pool.");
        this.isShutdown = true;
        Thread thread = this.maintenanceThread;
        synchronized (thread) {
            this.maintenanceThread.notifyAll();
        }
        try {
            this.maintenanceThread.join(10000L);
        }
        catch (InterruptedException e) {
            log.info((Object)"Maintenance thread interrpted");
        }
        this.retireThreadPool.shutdown();
    }

    public void shutdown() {
        this.preshutdown();
        while (true) {
            TimeUnit unit = TimeUnit.SECONDS;
            long t = 10L;
            try {
                if (!this.retireThreadPool.awaitTermination(t, unit)) continue;
            }
            catch (InterruptedException e) {
                log.warn((Object)"Exception when trying to shutdown. Will retry.", (Throwable)e);
                continue;
            }
            break;
        }
        log.info((Object)"shutting down thread pool complete.");
        log.info((Object)"shutting down indices.");
        this.box.shutdown();
        log.info((Object)"shutting down indices complete.");
    }

    public synchronized List<ZoieIndexReader<R>> getIndexReaders() throws IOException {
        ArrayList<ZoieIndexReader<R>> list = new ArrayList<ZoieIndexReader<R>>();
        if (this._appendOnly) {
            for (ZoieIndexReader zoieIndexReader : this.box._archives) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"add reader from box archives");
                }
                zoieIndexReader.incZoieRef();
                list.add(zoieIndexReader);
            }
        } else {
            for (ZoieSystem zoieSystem : this.box._archiveZoies) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"add reader from box archiveZoies");
                }
                list.addAll(zoieSystem.getIndexReaders());
            }
        }
        for (ZoieSystem zoieSystem : this.box._retiree) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"add reader from box retiree");
            }
            list.addAll(zoieSystem.getIndexReaders());
        }
        for (ZoieSystem zoieSystem : this.box._actives) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"add reader from box actvies");
            }
            list.addAll(zoieSystem.getIndexReaders());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("returning reader of size: " + list.size()));
        }
        return list;
    }

    protected void retire(ZoieSystem<R, D> zoie) {
        long t0 = System.currentTimeMillis();
        log.info((Object)("retiring " + zoie.getAdminMBean().getIndexDir()));
        while (true) {
            long flushwait = 200000L;
            try {
                zoie.flushEvents(flushwait);
                zoie.getAdminMBean().setUseCompoundFile(true);
                zoie.getAdminMBean().optimize(1);
            }
            catch (IOException e) {
                log.error((Object)("retiring " + zoie.getAdminMBean().getIndexDir() + " Should investigate. But move on now."), (Throwable)e);
            }
            catch (ZoieException e) {
                if (e.getMessage().indexOf("timed out") < 0) break;
                log.info((Object)("retiring " + zoie.getAdminMBean().getIndexDir() + " flushing processing " + flushwait + "ms elapsed"));
                continue;
            }
            break;
        }
        ZoieMultiReader<R> zoiereader = null;
        if (this._appendOnly) {
            IndexReader reader = null;
            try {
                reader = this.getArchive(zoie);
            }
            catch (CorruptIndexException e) {
                log.error((Object)("retiring " + zoie.getAdminMBean().getIndexDir() + " Should investigate. But move on now."), (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)("retiring " + zoie.getAdminMBean().getIndexDir() + " Should investigate. But move on now."), (Throwable)e);
            }
            try {
                zoiereader = new ZoieMultiReader<R>(reader, this._decorator);
                DocIDMapper<?> mapper = this.hg.getzConfig().getDocidMapperFactory().getDocIDMapper(zoiereader);
                zoiereader.setDocIDMapper(mapper);
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
        this.archive(zoie, zoiereader);
        log.info((Object)("retired " + zoie.getAdminMBean().getIndexDir() + " in " + (System.currentTimeMillis() - t0) + "ms"));
        log.info((Object)("Disk Index Size Total Now: " + this.hg.getSizeBytes() / 1024L + "KB"));
        if (this._appendOnly) {
            zoie.shutdown();
        }
    }

    public List<ZoieSystem<R, D>> getArchiveZoies() {
        return this.box._archiveZoies;
    }

    private IndexReader getArchive(ZoieSystem<R, D> zoie) throws CorruptIndexException, IOException {
        String dirName = zoie.getAdminMBean().getIndexDir();
        SimpleFSDirectory dir = new SimpleFSDirectory(new File(dirName));
        IndexReader reader = null;
        if (IndexReader.indexExists((Directory)dir)) {
            reader = IndexReader.open((Directory)dir, (boolean)true);
        } else {
            log.info((Object)("empty index " + dirName));
            reader = null;
        }
        return reader;
    }
}

