/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.impl.indexing;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import proj.zoie.api.IndexReaderFactory;
import proj.zoie.api.ZoieException;
import proj.zoie.api.ZoieIndexReader;
import proj.zoie.impl.indexing.AbstractReaderCache;
import proj.zoie.impl.indexing.ReaderCacheFactory;

public class DefaultReaderCache<R extends IndexReader>
extends AbstractReaderCache<R> {
    private static final Logger log = Logger.getLogger(DefaultReaderCache.class);
    private final Thread _maintenance;
    private volatile boolean alreadyShutdown = false;
    private volatile List<ZoieIndexReader<R>> cachedreaders = new ArrayList<ZoieIndexReader<R>>(0);
    private volatile long cachedreaderTimestamp = 0L;
    private final ReentrantReadWriteLock cachedreadersLock = new ReentrantReadWriteLock();
    private volatile ConcurrentLinkedQueue<List<ZoieIndexReader<R>>> returningIndexReaderQueue = new ConcurrentLinkedQueue();
    private final ReentrantReadWriteLock returningIndexReaderQueueLock = new ReentrantReadWriteLock();
    private final Object cachemonitor = new Object();
    private long _freshness = 10000L;
    private final WeakReference<IndexReaderFactory<ZoieIndexReader<R>>> _readerfactory;
    public static ReaderCacheFactory FACTORY = new ReaderCacheFactory(){

        @Override
        public <R extends IndexReader> AbstractReaderCache<R> newInstance(IndexReaderFactory<ZoieIndexReader<R>> readerfactory) {
            return new DefaultReaderCache<R>(readerfactory);
        }
    };

    public DefaultReaderCache(IndexReaderFactory<ZoieIndexReader<R>> readerfactory) {
        this._readerfactory = new WeakReference<IndexReaderFactory<ZoieIndexReader<R>>>(readerfactory);
        this._maintenance = this.newMaintenanceThread();
        this._maintenance.setDaemon(true);
    }

    @Override
    public List<ZoieIndexReader<R>> getIndexReaders() {
        this.cachedreadersLock.readLock().lock();
        List<ZoieIndexReader<R>> readers = this.cachedreaders;
        for (ZoieIndexReader<R> r : readers) {
            r.incZoieRef();
        }
        this.cachedreadersLock.readLock().unlock();
        return readers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnIndexReaders(List<ZoieIndexReader<R>> readers) {
        if (readers == null || readers.size() == 0) {
            return;
        }
        this.returningIndexReaderQueueLock.readLock().lock();
        try {
            this.returningIndexReaderQueue.add(readers);
        }
        finally {
            this.returningIndexReaderQueueLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshCache(long timeout) throws ZoieException {
        long begintime = System.currentTimeMillis();
        while (this.cachedreaderTimestamp <= begintime) {
            Object object = this.cachemonitor;
            synchronized (object) {
                this.cachemonitor.notifyAll();
                long elapsed = System.currentTimeMillis() - begintime;
                if (elapsed > timeout) {
                    log.debug((Object)("refreshCached reader timeout in " + elapsed + "ms"));
                    throw new ZoieException("refreshCached reader timeout in " + elapsed + "ms");
                }
                long timetowait = Math.min(timeout - elapsed, 200L);
                try {
                    this.cachemonitor.wait(timetowait);
                }
                catch (InterruptedException e) {
                    log.warn((Object)"refreshCache", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void shutdown() {
        this._freshness = 30000L;
        this.alreadyShutdown = true;
    }

    @Override
    public void start() {
        this._maintenance.start();
    }

    @Override
    public long getFreshness() {
        return this._freshness;
    }

    @Override
    public void setFreshness(long freshness) {
        this._freshness = freshness;
    }

    private Thread newMaintenanceThread() {
        return new MaintenanceThread();
    }

    private class MaintenanceThread
    extends Thread {
        public MaintenanceThread() {
            super("DefaultReaderCache-zoie-indexReader-maintenance");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            do {
                try {
                    Object object = DefaultReaderCache.this.cachemonitor;
                    synchronized (object) {
                        DefaultReaderCache.this.cachemonitor.wait(DefaultReaderCache.this._freshness);
                    }
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
                List<Object> newreaders = null;
                if (DefaultReaderCache.this.alreadyShutdown) {
                    newreaders = new ArrayList();
                } else {
                    try {
                        IndexReaderFactory readerfactory = (IndexReaderFactory)DefaultReaderCache.this._readerfactory.get();
                        newreaders = readerfactory != null ? readerfactory.getIndexReaders() : new ArrayList();
                    }
                    catch (IOException e) {
                        log.info((Object)"DefaultReaderCache-zoie-indexReader-maintenance", (Throwable)e);
                        newreaders = new ArrayList();
                    }
                }
                List oldreaders = DefaultReaderCache.this.cachedreaders;
                DefaultReaderCache.this.cachedreadersLock.writeLock().lock();
                DefaultReaderCache.this.cachedreaders = newreaders;
                DefaultReaderCache.this.cachedreadersLock.writeLock().unlock();
                DefaultReaderCache.this.cachedreaderTimestamp = System.currentTimeMillis();
                Object object = DefaultReaderCache.this.cachemonitor;
                synchronized (object) {
                    DefaultReaderCache.this.cachemonitor.notifyAll();
                }
                if (!oldreaders.isEmpty()) {
                    DefaultReaderCache.this.returnIndexReaders(oldreaders);
                }
                DefaultReaderCache.this.returningIndexReaderQueueLock.writeLock().lock();
                ConcurrentLinkedQueue oldreturningIndexReaderQueue = DefaultReaderCache.this.returningIndexReaderQueue;
                DefaultReaderCache.this.returningIndexReaderQueue = new ConcurrentLinkedQueue();
                DefaultReaderCache.this.returningIndexReaderQueueLock.writeLock().unlock();
                for (List readers : oldreturningIndexReaderQueue) {
                    for (ZoieIndexReader r : readers) {
                        r.decZoieRef();
                    }
                }
            } while (DefaultReaderCache.this._readerfactory.get() != null || DefaultReaderCache.this.cachedreaders.size() != 0);
            log.info((Object)("ZoieSystem has been GCed. Exiting DefaultReaderCache Maintenance Thread " + this));
        }
    }
}

