/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.impl.indexing;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Stack;
import proj.zoie.api.DataConsumer;
import proj.zoie.impl.indexing.StreamDataProvider;

public class FileDataProvider
extends StreamDataProvider<File> {
    private final File _dir;
    private long _currentVersion = 0L;
    private Stack<Iterator<File>> _stack;
    private Iterator<File> _currentIterator;
    private boolean _looping;

    public FileDataProvider(File dir, Comparator<String> versionComparator) {
        super(versionComparator);
        if (!dir.exists()) {
            throw new IllegalArgumentException("dir: " + dir + " does not exist.");
        }
        this._dir = dir;
        this._stack = new Stack();
        this._looping = false;
        this.reset();
    }

    public File getDir() {
        return this._dir;
    }

    public String getZoieVersion() {
        return Long.toString(this._currentVersion);
    }

    public String getMinZoieVersion() {
        return Long.toString(0L);
    }

    public String nextZoieVersion() {
        return Long.toString(this._currentVersion + 1L);
    }

    @Override
    public void reset() {
        this._stack.clear();
        this._currentIterator = this._dir.isFile() ? Arrays.asList(this._dir).iterator() : Arrays.asList(this._dir.listFiles()).iterator();
    }

    public void setLooping(boolean looping) {
        this._looping = looping;
    }

    @Override
    public DataConsumer.DataEvent<File> next() {
        if (this._currentIterator.hasNext()) {
            File next = this._currentIterator.next();
            if (next.isFile()) {
                return new DataConsumer.DataEvent<File>(next, this.nextZoieVersion());
            }
            this._stack.push(this._currentIterator);
            this._currentIterator = Arrays.asList(next.listFiles()).iterator();
            return this.next();
        }
        if (this._stack.isEmpty()) {
            if (this._looping) {
                this.reset();
                return this.next();
            }
            return null;
        }
        this._currentIterator = this._stack.pop();
        return this.next();
    }

    @Override
    public void setStartingOffset(String version) {
        throw new UnsupportedOperationException("");
    }
}

