/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.impl.indexing;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import proj.zoie.api.indexing.AbstractZoieIndexable;
import proj.zoie.api.indexing.ZoieIndexable;
import proj.zoie.api.indexing.ZoieIndexableInterpreter;

public class FileIndexableInterpreter
implements ZoieIndexableInterpreter<File> {
    protected static int id = 0;
    private static final Logger log = Logger.getLogger(FileIndexableInterpreter.class);
    static ThreadLocal<StringBuilder> myStringBuilder = new ThreadLocal();
    static ThreadLocal<char[]> myCharBuffer = new ThreadLocal();

    @Override
    public ZoieIndexable convertAndInterpret(File src) {
        FileIndexable idxable = new FileIndexable(src, id);
        ++id;
        return idxable;
    }

    protected static class FileIndexable
    extends AbstractZoieIndexable {
        private File _file;
        private int _uid;

        private FileIndexable(File file, int uid) {
            this._file = file;
            this._uid = uid;
        }

        @Override
        public ZoieIndexable.IndexingReq[] buildIndexingReqs() {
            ZoieIndexable.IndexingReq req = new ZoieIndexable.IndexingReq(this.buildDocument(), null);
            return new ZoieIndexable.IndexingReq[]{req};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Document buildDocument() {
            Document doc = new Document();
            doc.add((Fieldable)new Field("foo", "bar", Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
            StringBuilder sb = myStringBuilder.get();
            char[] cb = myCharBuffer.get();
            if (sb == null || cb == null) {
                sb = new StringBuilder(15500);
                sb.ensureCapacity(15500);
                myStringBuilder.set(sb);
                cb = new char[15500];
                myCharBuffer.set(cb);
            }
            sb.append(this._file.getAbsoluteFile()).append("\n");
            doc.add((Fieldable)new Field("path", this._file.getAbsolutePath(), Field.Store.YES, Field.Index.ANALYZED));
            FileReader freader = null;
            try {
                freader = new FileReader(this._file);
                BufferedReader br = new BufferedReader(freader);
                int len = br.read(cb, 0, cb.length);
                int start = 0;
                for (int end = 0; end < len; ++end) {
                    if (cb[end] != '\n' && cb[end] != '\r') continue;
                    sb.append(cb, start, end - start).append('\n');
                    for (start = end; start < len && (cb[start] == '\n' || cb[start] == '\r'); ++start) {
                    }
                    end = start;
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            finally {
                if (freader != null) {
                    try {
                        freader.close();
                    }
                    catch (IOException e) {
                        log.error((Object)e);
                    }
                }
            }
            doc.add((Fieldable)new Field("content", sb.toString(), Field.Store.YES, Field.Index.ANALYZED));
            sb.setLength(0);
            return doc;
        }

        @Override
        public boolean isSkip() {
            return false;
        }

        @Override
        public boolean isDeleted() {
            return false;
        }

        @Override
        public long getUID() {
            return this._uid;
        }
    }
}

